/*
 * Decompiled with CFR 0.152.
 */
package net.davio.aquaticambitions.content.processing.conduit;

import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visual.TickableVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import dev.engine_room.flywheel.lib.visual.SimpleTickableVisual;
import java.util.function.Consumer;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.davio.aquaticambitions.content.processing.conduit.MechanicalConduitBlock;
import net.davio.aquaticambitions.content.processing.conduit.MechanicalConduitBlockEntity;
import net.davio.aquaticambitions.registry.CAAPartials;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class MechanicalConduitVisual
extends AbstractBlockEntityVisual<MechanicalConduitBlockEntity>
implements SimpleDynamicVisual,
SimpleTickableVisual {
    private MechanicalConduitBlock.ConduitPowerLevel conduitPowerLevel = MechanicalConduitBlock.ConduitPowerLevel.IDLE;
    private final TransformedInstance eye = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CAAPartials.CONDUIT_EYE)).createInstance();
    @Nullable
    private TransformedInstance inactiveConduit;
    @Nullable
    private TransformedInstance cage;

    public MechanicalConduitVisual(VisualizationContext ctx, MechanicalConduitBlockEntity blockEntity, float partialTick) {
        super(ctx, (BlockEntity)blockEntity, partialTick);
        this.eye.light(240);
        this.animate(partialTick);
    }

    public void tick(TickableVisual.Context context) {
        ((MechanicalConduitBlockEntity)this.blockEntity).tickAnimation();
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        if (!this.isVisible(ctx.frustum()) || this.doDistanceLimitThisFrame(ctx)) {
            return;
        }
        this.animate(ctx.partialTick());
    }

    private void animate(float partialTicks) {
        float animation = ((MechanicalConduitBlockEntity)this.blockEntity).eyeAnimation.getValue(partialTicks) * 0.175f;
        MechanicalConduitBlock.ConduitPowerLevel conduitPowerLevel = ((MechanicalConduitBlockEntity)this.blockEntity).getConduitLevelFromBlock();
        boolean isActive = conduitPowerLevel.isAwakened();
        if (conduitPowerLevel != this.conduitPowerLevel || this.cage == null & this.inactiveConduit == null) {
            if (isActive) {
                this.cage = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CAAPartials.CONDUIT_CAGE)).createInstance();
                this.cage.light(240);
                if (this.inactiveConduit != null) {
                    this.inactiveConduit.delete();
                    this.inactiveConduit = null;
                }
            } else {
                this.inactiveConduit = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CAAPartials.INACTIVE_CONDUIT)).createInstance();
                this.inactiveConduit.light(240);
                if (this.cage != null) {
                    this.cage.delete();
                    this.cage = null;
                }
            }
            this.conduitPowerLevel = conduitPowerLevel;
        }
        int hashCode = ((Object)((Object)((MechanicalConduitBlockEntity)this.blockEntity))).hashCode();
        float time = AnimationTickHolder.getRenderTime();
        float renderTick = time + (float)(hashCode % 13) * 16.0f;
        float offset = Mth.m_14031_((float)((float)((double)(renderTick / 16.0f) % (Math.PI * 2)))) / 16.0f;
        float mainY = offset - animation * 0.6f;
        float activeYOffset = 0.2f;
        float rotateYZ = (float)Math.PI / 180 * (time * 2.0f) % 360.0f;
        float rotateX = 0.5235988f * Mth.m_14031_((float)(time * 2.0f % 360.0f * ((float)Math.PI / 180)));
        float eyeAngle = AngleHelper.rad((double)((MechanicalConduitBlockEntity)this.blockEntity).eyeAngle.getValue(partialTicks));
        if (this.eye != null) {
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.eye.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).translateY(mainY + (isActive ? activeYOffset : 0.0f))).translate(0.5f)).rotateY(eyeAngle).translateBack(0.5f)).setChanged();
        }
        if (this.cage != null) {
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.cage.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).translateY(mainY + activeYOffset)).translate(0.5f)).rotateY(rotateYZ).rotateZ(rotateYZ).rotateX(rotateX).translateBack(0.5f)).setChanged();
        }
        if (this.inactiveConduit != null) {
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.inactiveConduit.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).translateY(mainY)).translate(0.5f)).rotateY(eyeAngle).translateBack(0.5f)).setChanged();
        }
    }

    public void updateLight(float partialTick) {
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
    }

    protected void _delete() {
        this.eye.delete();
        if (this.cage != null) {
            this.cage.delete();
        }
        if (this.inactiveConduit != null) {
            this.inactiveConduit.delete();
        }
    }
}

