/*
 * Decompiled with CFR 0.152.
 */
package net.davio.aquaticambitions.content.processing.conduit;

import com.mojang.serialization.Codec;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import net.createmod.catnip.lang.Lang;
import net.davio.aquaticambitions.content.processing.conduit.MechanicalConduitBlockEntity;
import net.davio.aquaticambitions.registry.CAABlockEntityTypes;
import net.davio.aquaticambitions.registry.CAAShapes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MechanicalConduitBlock
extends Block
implements IBE<MechanicalConduitBlockEntity>,
IWrenchable,
ProperWaterloggedBlock {
    public static final EnumProperty<ConduitPowerLevel> CONDUIT_POWER_LEVEL = EnumProperty.m_61587_((String)"conduit", ConduitPowerLevel.class);

    public MechanicalConduitBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(CONDUIT_POWER_LEVEL, (Comparable)((Object)ConduitPowerLevel.IDLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED});
        builder.m_61104_(new Property[]{CONDUIT_POWER_LEVEL});
    }

    public FluidState m_5888_(BlockState pState) {
        return this.fluidState(pState);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState defaultState = (BlockState)this.m_49966_().m_61124_(CONDUIT_POWER_LEVEL, (Comparable)((Object)ConduitPowerLevel.IDLE));
        return this.withWater(defaultState, context);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        return CAAShapes.MECH_CONDUIT_SHAPE;
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        this.updateWater(pLevel, pState, pCurrentPos);
        return pState;
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (context == CollisionContext.m_82749_()) {
            return AllShapes.HEATER_BLOCK_SPECIAL_COLLISION_SHAPE;
        }
        return this.m_5940_(blockState, level, pos, context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (random.m_188503_(10) != 0) {
            return;
        }
        if (((ConduitPowerLevel)((Object)state.m_61143_(CONDUIT_POWER_LEVEL))).equals((Object)ConduitPowerLevel.AWAKENED)) {
            world.m_7785_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), SoundEvents.f_11768_, SoundSource.BLOCKS, 0.5f + random.m_188501_(), random.m_188501_() * 0.7f + 0.6f, false);
        }
    }

    public static ConduitPowerLevel getConduitLevelOf(BlockState blockState) {
        return (ConduitPowerLevel)((Object)blockState.m_61143_(CONDUIT_POWER_LEVEL));
    }

    public Class<MechanicalConduitBlockEntity> getBlockEntityClass() {
        return MechanicalConduitBlockEntity.class;
    }

    public BlockEntityType<? extends MechanicalConduitBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CAABlockEntityTypes.MECHANICAL_CONDUIT.get();
    }

    public static int getLight(BlockState state) {
        ConduitPowerLevel level = (ConduitPowerLevel)((Object)state.m_61143_(CONDUIT_POWER_LEVEL));
        return switch (level) {
            case ConduitPowerLevel.IDLE -> 8;
            default -> 15;
        };
    }

    public static enum ConduitPowerLevel implements StringRepresentable
    {
        IDLE,
        AWAKENED;

        public static final Codec<ConduitPowerLevel> CODEC;

        public boolean isAwakened() {
            return this.ordinal() >= AWAKENED.ordinal();
        }

        public String m_7912_() {
            return Lang.asId((String)this.name());
        }

        static {
            CODEC = StringRepresentable.m_216439_(ConduitPowerLevel::values);
        }
    }
}

