/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal;

import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.SandSnapperEntity;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.sandstorm.ISandstormServerDataProvider;
import com.yungnickyoung.minecraft.yungscavebiomes.sandstorm.SandstormServerData;
import java.util.EnumSet;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class RunFromPlayerGoal
extends Goal {
    private static final double UPDATE_TARGET_POS_DISTANCE_SQUARED = 9.0;
    private static final int REFRESH_PATH_INTERVAL = 20;
    private final SandSnapperEntity sandSnapper;
    private final double speedModifier;
    private final double submergedSpeedModifier;
    @Nullable
    protected Player playerToAvoid;
    protected final float maxDist;
    @Nullable
    protected Path path;
    protected final PathNavigation pathNav;
    private final TargetingConditions avoidEntityTargeting;
    private int refreshPathTimer;

    public RunFromPlayerGoal(SandSnapperEntity sandSnapper, float dist, double speedModifier, double submergedSpeedModifier) {
        this(sandSnapper, dist, speedModifier, submergedSpeedModifier, EntitySelector.f_20406_::test);
    }

    private RunFromPlayerGoal(SandSnapperEntity sandSnapper, float maxDist, double speedModifier, double submergedSpeedModifier, Predicate<LivingEntity> avoidEntityPredicate) {
        this.sandSnapper = sandSnapper;
        this.maxDist = maxDist;
        this.speedModifier = speedModifier;
        this.submergedSpeedModifier = submergedSpeedModifier;
        this.pathNav = sandSnapper.m_21573_();
        this.avoidEntityTargeting = TargetingConditions.m_148352_().m_26883_((double)maxDist).m_26888_(avoidEntityPredicate);
        this.refreshPathTimer = this.m_183277_(20);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public void m_8056_() {
        this.pathNav.m_26536_(this.path, this.speedModifier);
        if (!this.sandSnapper.isSubmerged() && this.sandSnapper.canSubmerge(true)) {
            this.sandSnapper.setSubmerged(true);
        }
    }

    public void m_8041_() {
        this.playerToAvoid = null;
        this.refreshPathTimer = this.m_183277_(20);
    }

    public void m_8037_() {
        if (!this.sandSnapper.isSubmerged() && this.sandSnapper.canSubmerge(true)) {
            this.sandSnapper.setSubmerged(true);
            this.sandSnapper.tryPlayPanicSound();
        }
        double multiplier = this.sandSnapper.isSubmerged() ? this.submergedSpeedModifier : 1.0;
        this.sandSnapper.m_21573_().m_26517_(this.speedModifier * multiplier);
        --this.refreshPathTimer;
        if (this.playerToAvoid != null && this.refreshPathTimer <= 0 && this.playerToAvoid.m_20280_((Entity)this.sandSnapper) < 9.0) {
            this.refreshPathTimer = this.m_183277_(20);
            Vec3 newTargetPos = this.findTargetPos();
            if (newTargetPos != null && this.sandSnapper.canMove()) {
                this.path = this.pathNav.m_26524_(newTargetPos.f_82479_, newTargetPos.f_82480_, newTargetPos.f_82481_, 0);
                this.pathNav.m_26536_(this.path, this.speedModifier);
            }
        }
    }

    public boolean m_8036_() {
        if (this.sandSnapper.friendlyTimer > 0 || !this.sandSnapper.canMove() || this.sandSnapper.m_8077_()) {
            return false;
        }
        this.playerToAvoid = (Player)this.sandSnapper.m_9236_().m_45982_(this.sandSnapper.m_9236_().m_6443_(Player.class, this.sandSnapper.m_20191_().m_82377_((double)this.maxDist, 3.0, (double)this.maxDist), p -> true), this.avoidEntityTargeting, (LivingEntity)this.sandSnapper, this.sandSnapper.m_20185_(), this.sandSnapper.m_20186_(), this.sandSnapper.m_20189_());
        Vec3 targetPos = this.findTargetPos();
        if (targetPos == null) {
            return false;
        }
        this.path = this.pathNav.m_26524_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, 0);
        return this.path != null && !this.isInActiveSandstorm();
    }

    public boolean m_8045_() {
        return this.sandSnapper.friendlyTimer <= 0 && !this.pathNav.m_26571_() && !this.isInActiveSandstorm() && !this.sandSnapper.m_8077_();
    }

    public boolean m_6767_() {
        return false;
    }

    @Nullable
    private Vec3 findTargetPos() {
        if (this.playerToAvoid == null) {
            return null;
        }
        int minHorizontalDist = 4;
        int maxHorizontalDist = 16;
        int maxVerticalDist = 7;
        Function<BlockPos, Boolean> isValidSandPos = pos -> this.sandSnapper.m_9236_().m_8055_(pos).m_204336_(BlockModule.SAND_SNAPPER_BLOCKS) && this.sandSnapper.m_9236_().m_8055_(pos.m_7494_()).m_60795_();
        Vec3 targetPos = this.getPosAway(minHorizontalDist, maxHorizontalDist, maxVerticalDist, 1.5707963267948966, this.playerToAvoid.m_20182_(), isValidSandPos);
        if (targetPos == null) {
            targetPos = this.getPosAway(minHorizontalDist, maxHorizontalDist, maxVerticalDist, 4.71238898038469, this.playerToAvoid.m_20182_(), isValidSandPos);
        }
        if (targetPos == null) {
            targetPos = this.getPosAway(minHorizontalDist, maxHorizontalDist, maxVerticalDist, 1.5707963267948966, this.playerToAvoid.m_20182_(), null);
        }
        if (targetPos == null) {
            targetPos = this.getPosAway(0, maxHorizontalDist, maxVerticalDist, 1.5707963267948966, this.playerToAvoid.m_20182_(), null);
        }
        return targetPos;
    }

    @Nullable
    private Vec3 getPosAway(int minHorizontalDist, int maxHorizontalDist, int maxVerticalDist, double searchAngle, Vec3 avoidPos, @Nullable Function<BlockPos, Boolean> blockFilter) {
        Vec3 awayDirection = this.sandSnapper.m_20182_().m_82546_(avoidPos);
        return RandomPos.m_148542_((PathfinderMob)this.sandSnapper, () -> {
            BlockPos randomlyOffsetPos = RunFromPlayerGoal.generateRandomOffsetInDirection(this.sandSnapper.m_217043_(), minHorizontalDist, maxHorizontalDist, maxVerticalDist, awayDirection.f_82479_, awayDirection.f_82481_, searchAngle);
            BlockPos pos = BlockPos.m_274561_((double)(this.sandSnapper.m_20185_() + (double)randomlyOffsetPos.m_123341_()), (double)(this.sandSnapper.m_20186_() + (double)randomlyOffsetPos.m_123342_()), (double)(this.sandSnapper.m_20189_() + (double)randomlyOffsetPos.m_123343_()));
            return blockFilter == null || (Boolean)blockFilter.apply(pos) != false ? pos : null;
        });
    }

    private static BlockPos generateRandomOffsetInDirection(RandomSource random, int minHorizontalDist, int maxHorizontalDistance, int maxVerticalDistance, double dirX, double dirZ, double searchAngle) {
        double theta = Math.atan2(dirZ, dirX);
        double randomAngleOffset = random.m_188500_() * searchAngle - searchAngle / 2.0;
        double randomAngle = theta + randomAngleOffset;
        double amplitude = Math.sqrt(random.m_188500_()) * (double)(maxHorizontalDistance - minHorizontalDist) + (double)minHorizontalDist;
        double randomX = amplitude * Math.cos(randomAngle);
        double randomZ = amplitude * Math.sin(randomAngle);
        int randomY = random.m_188503_(2 * maxVerticalDistance + 1) - maxVerticalDistance;
        return BlockPos.m_274561_((double)randomX, (double)randomY, (double)randomZ);
    }

    private boolean isInActiveSandstorm() {
        SandstormServerData sandstormServerData = ((ISandstormServerDataProvider)this.sandSnapper.m_9236_()).getSandstormServerData();
        return sandstormServerData.isSandstormActive();
    }
}

