/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.personality.core.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.personality.client.model.FishingHookModel;
import com.teamabnormals.personality.core.PersonalityConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.FishingHookRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FishingHookRenderer.class})
public abstract class FishingHookRendererMixin
extends EntityRenderer<FishingHook> {
    @Unique
    private static final FishingHookModel MODEL = new FishingHookModel(FishingHookModel.createBodyLayer().m_171564_());
    @Unique
    private static final ResourceLocation TEXTURE = new ResourceLocation("personality", "textures/entity/fishing_bobber.png");
    @Unique
    private static final RenderType RENDER_TYPE = RenderType.m_110458_((ResourceLocation)TEXTURE);

    private FishingHookRendererMixin(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    @Shadow
    private static void m_174118_(float p_229104_0_, float p_229104_1_, float p_229104_2_, VertexConsumer p_229104_3_, PoseStack.Pose pose, float p_229104_4_, float p_229104_5_) {
        throw new AssertionError((Object)"Mixin failed");
    }

    @Shadow
    private static float m_114690_(int p_229105_0_, int p_229105_1_) {
        throw new AssertionError((Object)"Mixin failed");
    }

    @Inject(method={"render(Lnet/minecraft/world/entity/projectile/FishingHook;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(FishingHook bobber, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        if (!((Boolean)PersonalityConfig.CLIENT.fishingHookModel.get()).booleanValue()) {
            return;
        }
        Player player = bobber.m_37168_();
        if (player != null) {
            float playerEyeHeight;
            double playerPosZ;
            double playerPosY;
            double playerPosX;
            int hand;
            ItemStack mainRod = player.m_21205_();
            ItemStack offHandRod = player.m_21206_();
            boolean enchanted = mainRod.m_41720_() instanceof FishingRodItem && mainRod.m_41793_() || offHandRod.m_41720_() instanceof FishingRodItem && offHandRod.m_41793_();
            poseStack.m_85836_();
            poseStack.m_85836_();
            poseStack.m_85841_(1.0f, -1.0f, -1.0f);
            poseStack.m_85837_(0.0, -1.5, 0.0);
            MODEL.m_7695_(poseStack, ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)RENDER_TYPE, (boolean)false, (boolean)enchanted), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
            int n = hand = player.m_5737_() == HumanoidArm.RIGHT ? 1 : -1;
            if (!(mainRod.m_41720_() instanceof FishingRodItem)) {
                hand = -hand;
            }
            float swingProgress = player.m_21324_(partialTicks);
            float swingProgressSin = Mth.m_14031_((float)(Mth.m_14116_((float)swingProgress) * (float)Math.PI));
            float playerYaw = Mth.m_14179_((float)partialTicks, (float)player.f_20884_, (float)player.f_20883_) * ((float)Math.PI / 180);
            double yawSin = Mth.m_14031_((float)playerYaw);
            double yawCos = Mth.m_14089_((float)playerYaw);
            double handPos = (double)hand * 0.35;
            if ((this.f_114476_.f_114360_ == null || this.f_114476_.f_114360_.m_92176_().m_90612_()) && player == Minecraft.m_91087_().f_91074_) {
                double d7 = (double)((Integer)this.f_114476_.f_114360_.m_231837_().m_231551_()).intValue() / 100.0;
                Vec3 handVec = new Vec3((double)hand * -0.36 * d7, -0.045 * d7, 0.4);
                handVec = handVec.m_82496_(-Mth.m_14179_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_()) * ((float)Math.PI / 180));
                handVec = handVec.m_82524_(-Mth.m_14179_((float)partialTicks, (float)player.f_19859_, (float)player.m_146908_()) * ((float)Math.PI / 180));
                handVec = handVec.m_82524_(swingProgressSin * 0.5f);
                handVec = handVec.m_82496_(-swingProgressSin * 0.7f);
                playerPosX = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) + handVec.f_82479_;
                playerPosY = Mth.m_14139_((double)partialTicks, (double)player.f_19855_, (double)player.m_20186_()) + handVec.f_82480_;
                playerPosZ = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) + handVec.f_82481_;
                playerEyeHeight = player.m_20192_();
            } else {
                playerPosX = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) - yawCos * handPos - yawSin * 0.8;
                playerPosY = player.f_19855_ + (double)player.m_20192_() + (player.m_20186_() - player.f_19855_) * (double)partialTicks - 0.45;
                playerPosZ = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) - yawSin * handPos + yawCos * 0.8;
                playerEyeHeight = player.m_6047_() ? -0.1875f : 0.0f;
            }
            double posX = Mth.m_14139_((double)partialTicks, (double)bobber.f_19854_, (double)bobber.m_20185_());
            double posY = Mth.m_14139_((double)partialTicks, (double)bobber.f_19855_, (double)bobber.m_20186_()) + 0.25;
            double posZ = Mth.m_14139_((double)partialTicks, (double)bobber.f_19856_, (double)bobber.m_20189_());
            float stringPosX = (float)(playerPosX - posX);
            float stringPosY = (float)(playerPosY - posY) + playerEyeHeight;
            float stringPosZ = (float)(playerPosZ - posZ);
            VertexConsumer stringVertex = buffer.m_6299_(RenderType.m_173247_());
            PoseStack.Pose stringMatrix = poseStack.m_85850_();
            for (int i = 0; i <= 16; ++i) {
                FishingHookRendererMixin.m_174118_(stringPosX, stringPosY, stringPosZ, stringVertex, stringMatrix, FishingHookRendererMixin.m_114690_(i, 16), FishingHookRendererMixin.m_114690_(i + 1, 16));
            }
            poseStack.m_85849_();
            super.m_7392_((Entity)bobber, yaw, partialTicks, poseStack, buffer, packedLight);
        }
        ci.cancel();
    }
}

