/*
 * Decompiled with CFR 0.152.
 */
package com.cake.drill_drain.content.replacements;

import com.cake.drill_drain.Config;
import com.cake.drill_drain.content.replacements.DrillActorVisualReplacement;
import com.cake.drill_drain.foundation.DDRegistry;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ActorVisual;
import com.simibubi.create.content.kinetics.drill.DrillMovementBehaviour;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.ModList;

public class DrillMovementBehaviourReplacement
extends DrillMovementBehaviour {
    public void startMoving(MovementContext context) {
        StructureTemplate.StructureBlockInfo parentStructure;
        super.startMoving(context);
        if (context.blockEntityData.m_128441_("DrillDrainParent") && ((parentStructure = (StructureTemplate.StructureBlockInfo)context.contraption.getBlocks().get(context.localPos.m_121955_((Vec3i)BlockPos.m_122022_((long)context.blockEntityData.m_128454_("DrillDrainParent"))))) == null || !parentStructure.f_74676_().m_60713_((Block)DDRegistry.DRILL_DRAIN.get()))) {
            context.blockEntityData.m_128473_("DrillDrainParent");
            context.data.m_128379_("Disabled", true);
        }
    }

    public void tick(MovementContext context) {
        super.tick(context);
        int lazyTickCounter = !context.data.m_128441_("lazyTickCounter") ? 0 : context.data.m_128451_("lazyTickCounter") + 1;
        context.data.m_128405_("lazyTickCounter", lazyTickCounter);
        if (lazyTickCounter % 10 == 0) {
            this.tryCollectFluids(context, BlockPos.m_274446_((Position)context.contraption.entity.toGlobalVector(Vec3.m_82512_((Vec3i)context.localPos), 1.0f)));
        }
    }

    public void visitNewPosition(MovementContext context, BlockPos pos) {
        super.visitNewPosition(context, pos);
        this.tryCollectFluids(context, pos);
    }

    private void tryCollectFluids(MovementContext context, BlockPos pos) {
        if (context.blockEntityData.m_128441_("DrillDrainParent") && !context.world.f_46443_) {
            boolean consumePartialFluid = ModList.get().isLoaded("flowing_fluids");
            FluidStack currentState = this.getFluidFromFluidBlock(context, pos, true, consumePartialFluid);
            if (currentState == null) {
                return;
            }
            if (Config.fluidPickupModifier != 0.0 && !currentState.isEmpty()) {
                int simulatedFill = context.contraption.getStorage().getFluids().fill(currentState, IFluidHandler.FluidAction.SIMULATE);
                if (simulatedFill < currentState.getAmount()) {
                    return;
                }
                context.contraption.getStorage().getFluids().fill(currentState, IFluidHandler.FluidAction.EXECUTE);
            }
            this.getFluidFromFluidBlock(context, pos, false, consumePartialFluid);
            context.world.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 0.1f, 1.0f);
        }
    }

    @Nullable
    private FluidStack getFluidFromFluidBlock(MovementContext context, BlockPos pos, boolean simulate, boolean consumePartialFluid) {
        if (context.world == null) {
            return null;
        }
        if (!context.world.m_46749_(pos)) {
            return null;
        }
        BlockState state = context.world.m_8055_(pos);
        FluidState fluidState = state.m_60819_();
        boolean isWaterLoggableBlock = state.m_61138_((Property)BlockStateProperties.f_61362_);
        if (!isWaterLoggableBlock && !state.m_247087_()) {
            return null;
        }
        if (fluidState.m_76178_()) {
            return null;
        }
        FluidStack stack = new FluidStack(fluidState.m_76152_(), (int)(!consumePartialFluid || fluidState.m_76170_() ? 0.0 : (double)fluidState.m_76186_() * Config.fluidPickupModifier));
        if (simulate) {
            return stack;
        }
        if (isWaterLoggableBlock) {
            context.world.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)), 3);
            context.world.m_186469_(pos, (Fluid)Fluids.f_76193_, 1);
        } else {
            context.world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            if (!fluidState.m_76178_()) {
                context.world.m_186469_(pos, fluidState.m_76152_(), 1);
            }
        }
        return stack;
    }

    @Nullable
    public ActorVisual createVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext movementContext) {
        return new DrillActorVisualReplacement(visualizationContext, simulationWorld, movementContext);
    }
}

