/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.background;

import de.keksuccino.fancymenu.customization.background.MenuBackground;
import de.keksuccino.fancymenu.customization.background.MenuBackgroundBuilder;
import de.keksuccino.fancymenu.customization.background.MenuBackgroundRegistry;
import de.keksuccino.fancymenu.customization.background.backgrounds.image.ImageMenuBackground;
import de.keksuccino.fancymenu.customization.background.backgrounds.image.ImageMenuBackgroundBuilder;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.TooltipHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseMenuBackgroundScreen
extends Screen {
    protected static final MenuBackgroundBuilder<ImageMenuBackground> NO_BACKGROUND_TYPE = new ImageMenuBackgroundBuilder();
    public static final MenuBackground NO_BACKGROUND = new ImageMenuBackground(NO_BACKGROUND_TYPE);
    protected MenuBackgroundBuilder<?> backgroundType;
    protected MenuBackground background;
    protected Consumer<MenuBackground> callback;
    protected ScrollArea backgroundTypeListScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ScrollArea backgroundDescriptionScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedButton configureButton;
    protected ExtendedButton doneButton;
    protected ExtendedButton cancelButton;

    public ChooseMenuBackgroundScreen(@Nullable MenuBackground backgroundToEdit, boolean addResetBackgroundEntry, @NotNull Consumer<MenuBackground> callback) {
        super((Component)Component.m_237115_((String)"fancymenu.menu_background.choose"));
        this.background = backgroundToEdit;
        this.callback = callback;
        this.setContentOfBackgroundTypeList(addResetBackgroundEntry);
        if (this.background != null) {
            for (ScrollAreaEntry e : this.backgroundTypeListScrollArea.getEntries()) {
                if (!(e instanceof BackgroundTypeScrollEntry) || ((BackgroundTypeScrollEntry)e).backgroundType != this.background.builder) continue;
                e.setSelected(true);
                this.backgroundType = this.background.builder;
                this.setDescription(this.backgroundType);
                break;
            }
        }
        if (this.backgroundType == null) {
            this.background = null;
            if (addResetBackgroundEntry) {
                this.backgroundTypeListScrollArea.getEntries().get(0).setSelected(true);
                this.backgroundType = NO_BACKGROUND_TYPE;
                this.background = NO_BACKGROUND;
                this.setDescription(NO_BACKGROUND_TYPE);
            }
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.configureButton = new ExtendedButton(0, 0, 150, 20, (Component)Component.m_237115_((String)"fancymenu.menu_background.choose.configure_background"), button -> {
            if (this.backgroundType != null) {
                this.backgroundType.buildNewOrEditInstanceInternal(this, this.background, back -> {
                    if (back != null) {
                        this.background = back;
                    }
                });
            }
        }){

            @Override
            public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
                if (ChooseMenuBackgroundScreen.this.backgroundType == null) {
                    TooltipHandler.INSTANCE.addWidgetTooltip((AbstractWidget)this, Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.menu_background.choose.not_background_selected", new String[0])).setDefaultStyle(), false, true);
                    this.f_93623_ = false;
                } else {
                    this.f_93623_ = ChooseMenuBackgroundScreen.this.backgroundType != NO_BACKGROUND_TYPE;
                }
                super.m_88315_(graphics, mouseX, mouseY, partial);
            }
        };
        this.m_7787_((GuiEventListener)this.configureButton);
        UIBase.applyDefaultWidgetSkinTo(this.configureButton);
        this.doneButton = new ExtendedButton(0, 0, 150, 20, (Component)Component.m_237115_((String)"fancymenu.guicomponents.done"), button -> this.callback.accept(this.background)){

            @Override
            public void m_87963_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
                if (ChooseMenuBackgroundScreen.this.backgroundType == null) {
                    TooltipHandler.INSTANCE.addWidgetTooltip((AbstractWidget)this, Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.menu_background.choose.not_background_selected", new String[0])).setDefaultStyle(), false, true);
                    this.f_93623_ = false;
                } else if (ChooseMenuBackgroundScreen.this.background == null) {
                    TooltipHandler.INSTANCE.addWidgetTooltip((AbstractWidget)this, Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.menu_background.choose.not_configured", new String[0])).setDefaultStyle(), false, true);
                    this.f_93623_ = false;
                } else {
                    this.f_93623_ = true;
                }
                super.m_87963_(graphics, mouseX, mouseY, partial);
            }
        };
        this.m_7787_((GuiEventListener)this.doneButton);
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);
        this.cancelButton = new ExtendedButton(0, 0, 150, 20, (Component)Component.m_237115_((String)"fancymenu.guicomponents.cancel"), button -> this.callback.accept(null));
        this.m_7787_((GuiEventListener)this.cancelButton);
        UIBase.applyDefaultWidgetSkinTo(this.cancelButton);
        this.setDescription(this.backgroundType);
    }

    public void m_7379_() {
        this.callback.accept(null);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        MutableComponent titleComp = this.f_96539_.m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        graphics.m_280614_(this.f_96547_, (Component)titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"fancymenu.menu_background.choose.available_types"), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        this.backgroundTypeListScrollArea.setWidth(this.f_96543_ / 2 - 40, true);
        this.backgroundTypeListScrollArea.setHeight(this.f_96544_ - 85, true);
        this.backgroundTypeListScrollArea.setX(20, true);
        this.backgroundTypeListScrollArea.setY(65, true);
        this.backgroundTypeListScrollArea.render(graphics, mouseX, mouseY, partial);
        MutableComponent descLabel = Component.m_237115_((String)"fancymenu.menu_background.choose.type_description");
        int descLabelWidth = this.f_96547_.m_92852_((FormattedText)descLabel);
        graphics.m_280614_(this.f_96547_, (Component)descLabel, this.f_96543_ - 20 - descLabelWidth, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        this.backgroundDescriptionScrollArea.setWidth(this.f_96543_ / 2 - 40, true);
        this.backgroundDescriptionScrollArea.setHeight(Math.max(40, this.f_96544_ / 2 - 50 - 25), true);
        this.backgroundDescriptionScrollArea.setX(this.f_96543_ - 20 - this.backgroundDescriptionScrollArea.getWidthWithBorder(), true);
        this.backgroundDescriptionScrollArea.setY(65, true);
        this.backgroundDescriptionScrollArea.render(graphics, mouseX, mouseY, partial);
        this.doneButton.m_252865_(this.f_96543_ - 20 - this.doneButton.m_5711_());
        this.doneButton.m_253211_(this.f_96544_ - 20 - 20);
        this.doneButton.m_88315_(graphics, mouseX, mouseY, partial);
        this.cancelButton.m_252865_(this.f_96543_ - 20 - this.cancelButton.m_5711_());
        this.cancelButton.m_253211_(this.doneButton.m_252907_() - 5 - 20);
        this.cancelButton.m_88315_(graphics, mouseX, mouseY, partial);
        this.configureButton.m_252865_(this.f_96543_ - 20 - this.configureButton.m_5711_());
        this.configureButton.m_253211_(this.cancelButton.m_252907_() - 15 - 20);
        this.configureButton.m_88315_(graphics, mouseX, mouseY, partial);
        super.m_88315_(graphics, mouseX, mouseY, partial);
    }

    protected void setDescription(@Nullable MenuBackgroundBuilder<?> builder) {
        this.backgroundDescriptionScrollArea.clearEntries();
        if (builder == NO_BACKGROUND_TYPE) {
            return;
        }
        if (builder != null && builder.getDescription() != null) {
            for (Component c : builder.getDescription()) {
                TextScrollAreaEntry e = new TextScrollAreaEntry(this.backgroundDescriptionScrollArea, (Component)c.m_6881_().m_130948_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().description_area_text_color.getColorInt())), entry -> {});
                e.setSelectable(false);
                e.setBackgroundColorHover(e.getBackgroundColorIdle());
                e.setPlayClickSound(false);
                this.backgroundDescriptionScrollArea.addEntry(e);
            }
        }
    }

    protected void setContentOfBackgroundTypeList(boolean addResetBackgroundEntry) {
        this.backgroundTypeListScrollArea.clearEntries();
        if (addResetBackgroundEntry) {
            BackgroundTypeScrollEntry e = new BackgroundTypeScrollEntry(this.backgroundTypeListScrollArea, NO_BACKGROUND_TYPE, entry -> {
                if (this.backgroundType != NO_BACKGROUND_TYPE) {
                    this.backgroundType = NO_BACKGROUND_TYPE;
                    this.background = NO_BACKGROUND;
                    this.setDescription(NO_BACKGROUND_TYPE);
                }
            });
            this.backgroundTypeListScrollArea.addEntry(e);
        }
        for (MenuBackgroundBuilder<?> b : MenuBackgroundRegistry.getBuilders()) {
            if (LayoutEditorScreen.getCurrentInstance() != null && !b.shouldShowUpInEditorBackgroundMenu(LayoutEditorScreen.getCurrentInstance())) continue;
            BackgroundTypeScrollEntry e = new BackgroundTypeScrollEntry(this.backgroundTypeListScrollArea, b, entry -> {
                if (this.backgroundType != b) {
                    this.backgroundType = b;
                    this.background = null;
                    this.setDescription(b);
                }
            });
            this.backgroundTypeListScrollArea.addEntry(e);
        }
    }

    public boolean m_7933_(int button, int $$1, int $$2) {
        if (button == 257 && this.background != null) {
            this.callback.accept(this.background);
            return true;
        }
        return super.m_7933_(button, $$1, $$2);
    }

    public static class BackgroundTypeScrollEntry
    extends TextListScrollAreaEntry {
        public MenuBackgroundBuilder<?> backgroundType;
        @Nullable
        public Supplier<Tooltip> tooltipSupplier = null;

        public BackgroundTypeScrollEntry(ScrollArea parent, @NotNull MenuBackgroundBuilder<?> backgroundType, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, BackgroundTypeScrollEntry.getText(backgroundType), UIBase.getUIColorTheme().listing_dot_color_1.getColor(), onClick);
            this.backgroundType = backgroundType;
            if (this.backgroundType.isDeprecated()) {
                this.tooltipSupplier = () -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.menu_background.deprecated.details", new String[0])).setDefaultStyle().setTextBaseColor(UIBase.getUIColorTheme().warning_text_color);
            }
        }

        @Override
        public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            Tooltip t;
            if (this.tooltipSupplier != null && (t = this.tooltipSupplier.get()) != null) {
                TooltipHandler.INSTANCE.addTooltip(t, this::isHovered, false, true);
            }
            super.m_88315_(graphics, mouseX, mouseY, partial);
        }

        private static Component getText(MenuBackgroundBuilder<?> backgroundType) {
            if (backgroundType == NO_BACKGROUND_TYPE) {
                return Component.m_237115_((String)"fancymenu.menu_background.choose.entry.no_background").m_130948_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().error_text_color.getColorInt()));
            }
            MutableComponent c = backgroundType.getDisplayName().m_6881_().m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().description_area_text_color.getColorInt()));
            if (backgroundType.isDeprecated()) {
                c.m_7220_((Component)Component.m_237115_((String)"fancymenu.menu_background.deprecated").m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().warning_text_color.getColorInt())));
            }
            return c;
        }
    }
}

