/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.party.io.serialization.nbt;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import xaero.pac.common.parties.party.ally.PartyAlly;
import xaero.pac.common.parties.party.member.PartyInvite;
import xaero.pac.common.parties.party.member.PartyMember;
import xaero.pac.common.server.io.serialization.SimpleSerializer;
import xaero.pac.common.server.parties.party.PartyManager;
import xaero.pac.common.server.parties.party.ServerParty;
import xaero.pac.common.server.parties.party.io.serialization.nbt.member.PartyInviteNbtSerializer;
import xaero.pac.common.server.parties.party.io.serialization.nbt.member.PartyMemberNbtSerializer;

public final class PartyNbtSerializer
implements SimpleSerializer<CompoundTag, String, ServerParty, PartyManager> {
    private final PartyMemberNbtSerializer partyMemberNbtSerializer;
    private final PartyInviteNbtSerializer partyInviteNbtSerializer;

    public PartyNbtSerializer(PartyMemberNbtSerializer partyMemberNbtSerializer, PartyInviteNbtSerializer partyInviteNbtSerializer) {
        this.partyMemberNbtSerializer = partyMemberNbtSerializer;
        this.partyInviteNbtSerializer = partyInviteNbtSerializer;
    }

    @Override
    public CompoundTag serialize(ServerParty party) {
        CompoundTag result = new CompoundTag();
        result.m_128365_("owner", (Tag)this.partyMemberNbtSerializer.serialize(party.getOwner()));
        result.m_128356_("confirmedActivity", party.getRegisteredActivity());
        ListTag membersTag = new ListTag();
        ListTag invitesTag = new ListTag();
        ListTag alliesTag = new ListTag();
        party.getTypedInvitedPlayersStream().forEach(p -> invitesTag.add((Object)this.partyInviteNbtSerializer.serialize((PartyInvite)p)));
        party.getTypedAllyPartiesStream().forEach(a -> alliesTag.add((Object)NbtUtils.m_129226_((UUID)a.getPartyId())));
        party.getTypedMemberInfoStream().filter(mi -> mi != party.getOwner()).forEach(mi -> membersTag.add((Object)this.partyMemberNbtSerializer.serialize((PartyMember)mi)));
        result.m_128365_("invites", (Tag)invitesTag);
        result.m_128365_("allies", (Tag)alliesTag);
        result.m_128365_("members", (Tag)membersTag);
        return result;
    }

    @Override
    public ServerParty deserialize(String id, PartyManager manager, CompoundTag serializedData) {
        PartyMember owner = this.partyMemberNbtSerializer.deserialize(serializedData.m_128469_("owner"), true);
        long registeredActivity = serializedData.m_128454_("confirmedActivity");
        ListTag membersTag = serializedData.m_128437_("members", 10);
        ListTag invitesTag = serializedData.m_128437_("invites", 10);
        ListTag alliesTag = serializedData.m_128437_("allies", 11);
        HashMap members = new HashMap(32);
        HashMap invites = new HashMap(32);
        HashMap allies = new HashMap();
        membersTag.forEach(t -> {
            PartyMember member = this.partyMemberNbtSerializer.deserialize((CompoundTag)t, false);
            members.put(member.getUUID(), member);
        });
        invitesTag.forEach(t -> {
            PartyInvite invite = this.partyInviteNbtSerializer.deserialize((CompoundTag)t);
            invites.put(invite.getUUID(), invite);
        });
        alliesTag.forEach(t -> {
            UUID ally = NbtUtils.m_129233_((Tag)t);
            allies.put(ally, new PartyAlly(ally));
        });
        ServerParty result = ((ServerParty.Builder)((ServerParty.Builder)((ServerParty.Builder)ServerParty.Builder.begin().setManagedBy(manager).setOwner(owner).setId(UUID.fromString(id)).setMemberInfo((Map)members)).setInvitedPlayers((Map)invites)).setAllyParties((Map)allies)).build();
        result.setRegisteredActivity(registeredActivity);
        return result;
    }

    public static final class Builder {
        private Builder() {
        }

        private Builder setDefault() {
            return this;
        }

        public PartyNbtSerializer build() {
            return new PartyNbtSerializer(new PartyMemberNbtSerializer(), new PartyInviteNbtSerializer());
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

