/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.config;

import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.packet.config.PlayerConfigPacket;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.server.player.config.api.PlayerConfigType;
import xaero.pac.common.server.player.config.sub.PlayerSubConfigDeletionStarter;
import xaero.pac.common.server.player.data.ServerPlayerData;

public class ServerboundSubConfigExistencePacket
extends PlayerConfigPacket {
    private final String subId;
    private final UUID owner;
    private final PlayerConfigType type;
    private final boolean create;

    public ServerboundSubConfigExistencePacket(String subId, UUID owner, PlayerConfigType type, boolean create) {
        this.subId = subId;
        this.owner = owner;
        this.type = type;
        this.create = create;
    }

    public static class ServerHandler
    implements BiConsumer<ServerboundSubConfigExistencePacket, ServerPlayer> {
        @Override
        public void accept(ServerboundSubConfigExistencePacket t, ServerPlayer serverPlayer) {
            UUID ownerId;
            boolean isServer;
            if (t.type != PlayerConfigType.PLAYER && t.type != PlayerConfigType.SERVER) {
                OpenPartiesAndClaims.LOGGER.info("Someone is trying to create/delete a sub-config for an invalid config type! Name: " + serverPlayer.m_36316_().getName());
                return;
            }
            boolean isOP = serverPlayer.m_20310_(2);
            boolean bl = isServer = t.type == PlayerConfigType.SERVER;
            UUID uUID = isServer ? null : (ownerId = t.owner == null ? serverPlayer.m_20148_() : t.owner);
            if (!isOP) {
                if (isServer) {
                    OpenPartiesAndClaims.LOGGER.info("Non-op player is attempting to create/delete a sub-config without required permissions! Name: " + serverPlayer.m_36316_().getName());
                    return;
                }
                if (!Objects.equals(ownerId, serverPlayer.m_20148_())) {
                    OpenPartiesAndClaims.LOGGER.info("Non-op player is attempting to create/delete a sub-config for another player! Name: " + serverPlayer.m_36316_().getName());
                    return;
                }
            }
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverPlayer.m_20194_());
            IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
            IPlayerConfig config = !isServer ? playerConfigs.getLoadedConfig(ownerId) : playerConfigs.getServerClaimConfig();
            ServerPlayerData playerData = (ServerPlayerData)ServerPlayerData.from(serverPlayer);
            if (serverData.getServerTickHandler().getTickCounter() == playerData.getLastSubConfigCreationTick()) {
                return;
            }
            playerData.setLastSubConfigCreationTick(serverData.getServerTickHandler().getTickCounter());
            if (t.create) {
                boolean reachedLimit;
                boolean bl2 = reachedLimit = config.getSubCount() >= config.getSubConfigLimit();
                if (reachedLimit || config.createSubConfig(t.subId) == null || !isServer && !Objects.equals(ownerId, serverPlayer.m_20148_())) {
                    playerConfigs.getSynchronizer().confirmSubConfigCreationSync(serverPlayer, config);
                    if (reachedLimit) {
                        MutableComponent limitReachedMessage = Component.m_237110_((String)"gui.xaero_pac_config_create_sub_id_limit_reached", (Object[])new Object[]{config.getSubConfigLimit()});
                        limitReachedMessage.m_130938_(s -> s.m_131140_(ChatFormatting.RED));
                        serverPlayer.m_213846_((Component)limitReachedMessage);
                    }
                }
            } else {
                IPlayerConfig subConfig = config.getSubConfig(t.subId);
                if (subConfig == null) {
                    return;
                }
                if (subConfig == config) {
                    return;
                }
                IServerPlayerClaimInfo playerInfo = (IServerPlayerClaimInfo)serverData.getServerClaimsManager().getPlayerInfo(config.getPlayerId());
                if (playerInfo.hasReplacementTasks()) {
                    serverPlayer.m_213846_((Component)Component.m_237115_((String)"gui.xaero_pac_config_delete_sub_already_replacing"));
                    playerConfigs.getSynchronizer().syncGeneralState(serverPlayer, subConfig);
                    return;
                }
                new PlayerSubConfigDeletionStarter().start(serverPlayer, playerInfo, subConfig, serverData);
            }
        }
    }

    public static class Codec
    implements BiConsumer<ServerboundSubConfigExistencePacket, FriendlyByteBuf>,
    Function<FriendlyByteBuf, ServerboundSubConfigExistencePacket> {
        @Override
        public ServerboundSubConfigExistencePacket apply(FriendlyByteBuf input) {
            try {
                if (input.readableBytes() > 4096) {
                    return null;
                }
                CompoundTag nbt = input.m_130261_();
                if (nbt == null) {
                    return null;
                }
                String subId = nbt.m_128461_("subId");
                if (subId.isEmpty() || subId.length() > 100) {
                    return null;
                }
                String typeString = nbt.m_128461_("type");
                if (typeString.isEmpty() || typeString.length() > 100) {
                    return null;
                }
                PlayerConfigType type = null;
                try {
                    type = PlayerConfigType.valueOf(typeString);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (type == null) {
                    OpenPartiesAndClaims.LOGGER.info("Received unknown player config type!");
                    return null;
                }
                UUID owner = nbt.m_128441_("owner") ? nbt.m_128342_("owner") : null;
                boolean create = nbt.m_128471_("create");
                return new ServerboundSubConfigExistencePacket(subId, owner, type, create);
            }
            catch (Throwable t) {
                return null;
            }
        }

        @Override
        public void accept(ServerboundSubConfigExistencePacket t, FriendlyByteBuf u) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("subId", t.subId);
            if (t.owner != null) {
                nbt.m_128362_("owner", t.owner);
            }
            nbt.m_128359_("type", t.type.name());
            nbt.m_128379_("create", t.create);
            u.m_130079_(nbt);
        }
    }
}

