/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.BitStorage;
import net.minecraft.util.SimpleBitStorage;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundClaimsRegionPacket
extends LazyPacket<ClientboundClaimsRegionPacket> {
    public static final LazyPacket.Encoder<ClientboundClaimsRegionPacket> ENCODER = new LazyPacket.Encoder();
    public static final Decoder DECODER = new Decoder();
    private final int x;
    private final int z;
    private final int[] paletteInts;
    private final int bits;
    private final long[] data;

    public ClientboundClaimsRegionPacket(int x, int z, int[] paletteInts, int bits, long[] data) {
        this.x = x;
        this.z = z;
        this.paletteInts = paletteInts;
        this.bits = bits;
        this.data = data;
    }

    @Override
    protected Function<FriendlyByteBuf, ClientboundClaimsRegionPacket> getDecoder() {
        return DECODER;
    }

    @Override
    protected void writeOnPrepare(FriendlyByteBuf dest) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("x", this.x);
        nbt.m_128405_("z", this.z);
        nbt.m_128385_("p", this.paletteInts);
        nbt.m_128344_("b", (byte)this.bits);
        nbt.m_128388_("d", this.data);
        dest.m_130079_(nbt);
    }

    public static class Decoder
    implements Function<FriendlyByteBuf, ClientboundClaimsRegionPacket> {
        @Override
        public ClientboundClaimsRegionPacket apply(FriendlyByteBuf input) {
            try {
                if (input.readableBytes() > 16384) {
                    return null;
                }
                CompoundTag nbt = input.m_130261_();
                if (nbt == null) {
                    return null;
                }
                int x = nbt.m_128451_("x");
                int z = nbt.m_128451_("z");
                int[] paletteInts = nbt.m_128465_("p");
                byte bits = nbt.m_128445_("b");
                long[] data = nbt.m_128467_("d");
                return new ClientboundClaimsRegionPacket(x, z, paletteInts, bits, data);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet", t);
                return null;
            }
        }
    }

    public static class ClientHandler
    extends LazyPacket.Handler<ClientboundClaimsRegionPacket> {
        @Override
        public void handle(ClientboundClaimsRegionPacket t) {
            SimpleBitStorage regionData = new SimpleBitStorage(t.bits, 1024, t.data);
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onRegion(t.x, t.z, t.paletteInts, (BitStorage)regionData);
        }
    }
}

