/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.FrostWalkerEnchantment;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xaero.pac.common.server.core.ServerCore;

@Mixin(value={FrostWalkerEnchantment.class})
public class MixinFrostWalkerEnchantment {
    @Inject(method={"onEntityMoved"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onOnEntityMovedPre(LivingEntity living, Level level, BlockPos pos, int a, CallbackInfo ci) {
        if (ServerCore.preFrostWalkHandle(living, level)) {
            ci.cancel();
        }
    }

    @ModifyArg(method={"onEntityMoved"}, at=@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/world/level/Level;getBlockState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;"))
    private static BlockPos onOnEntityMovedPreBlockState(BlockPos pos) {
        return ServerCore.preBlockStateFetchOnFrostwalk(pos);
    }

    @Inject(method={"onEntityMoved"}, at={@At(value="RETURN")})
    private static void onOnEntityMovedPost(LivingEntity living, Level level, BlockPos pos, int a, CallbackInfo ci) {
        ServerCore.postFrostWalkHandle(level);
    }
}

