/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.gui;

import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import xaero.pac.client.gui.SimpleValueWidgetListElement;
import xaero.pac.client.gui.WidgetListScreen;
import xaero.pac.client.gui.widget.TextWidgetEditBox;

public final class TextWidgetListElement
extends SimpleValueWidgetListElement<String, TextWidgetListElement> {
    private final Component title;
    private EditBox editBox;
    private Button confirmButton;
    private Button cancelButton;
    private String confirmedText;
    private final BiConsumer<TextWidgetListElement, String> valueConfirmResponder;
    private final Predicate<String> validator;

    private TextWidgetListElement(int w, int h, boolean mutable, Component title, BiFunction<TextWidgetListElement, Vec3i, AbstractWidget> widgetSupplier, List<FormattedCharSequence> tooltip, BiConsumer<TextWidgetListElement, String> valueConfirmResponder, Predicate<String> validator, String startValue) {
        super(startValue, w, h, mutable, widgetSupplier, tooltip);
        this.confirmedText = startValue;
        this.title = title;
        this.valueConfirmResponder = valueConfirmResponder;
        this.validator = validator;
    }

    @Override
    public AbstractWidget screenInit(int x, int y, WidgetListScreen screen, List<EditBox> tickableBoxes) {
        this.editBox = (EditBox)super.screenInit(x, y, screen, tickableBoxes);
        this.confirmButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2714"), this::onConfirmButton).m_252987_(x + this.w - 40, y, 20, 20).m_253136_();
        screen.m_142416_(this.confirmButton);
        this.cancelButton = Button.m_253074_((Component)Component.m_237113_((String)"\u274c"), this::onCancelButton).m_252987_(x + this.w - 20, y, 20, 20).m_253136_();
        screen.m_142416_(this.cancelButton);
        this.confirmButton.f_93623_ = !this.confirmedText.equals(this.draftValue);
        this.cancelButton.f_93623_ = !this.confirmedText.equals(this.draftValue);
        return this.editBox;
    }

    public boolean onEnterPressed() {
        if (this.confirmButton.f_93623_) {
            this.confirmButton.m_5691_();
            return true;
        }
        return false;
    }

    private boolean updateBoxColor() {
        boolean validInput = this.validator.test((String)this.draftValue);
        this.editBox.m_94202_(validInput ? 0xE0E0E0 : -43691);
        return validInput;
    }

    private void onTextTyped(String value) {
        if (!((String)this.draftValue).equals(value)) {
            this.draftValue = value;
            this.confirmButton.f_93623_ = this.updateBoxColor();
            this.cancelButton.f_93623_ = true;
        }
    }

    private void onConfirmButton(Button b) {
        if (this.validator.test((String)this.draftValue)) {
            this.valueConfirmResponder.accept(this, (String)this.draftValue);
            this.confirmedText = (String)this.draftValue;
            this.confirmButton.f_93623_ = false;
            this.cancelButton.f_93623_ = false;
        }
    }

    public void clearBox() {
        this.editBox.m_94144_("");
    }

    private void onCancelButton(Button b) {
        this.draftValue = this.confirmedText;
        this.editBox.m_94144_((String)this.draftValue);
        this.confirmButton.f_93623_ = false;
        this.cancelButton.f_93623_ = false;
        this.updateBoxColor();
    }

    @Override
    public final void render(GuiGraphics guiGraphics) {
        super.render(guiGraphics);
        guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, this.title, this.x + 2, this.y + 6, this.mutable ? -1 : 0xE0E0E0);
    }

    public static final class Builder
    extends SimpleValueWidgetListElement.Builder<String, TextWidgetListElement, Builder> {
        private Component title;
        private BiConsumer<TextWidgetListElement, String> responder;
        private Predicate<String> filter;
        private Predicate<String> validator;
        private int boxWidth;
        private int maxLength;

        @Override
        public Builder setDefault() {
            super.setDefault();
            this.setBoxWidth(50);
            this.setTitle(null);
            this.setResponder(null);
            this.setFilter(Objects::nonNull);
            this.setValidator(Objects::nonNull);
            this.setMaxLength(32);
            return this;
        }

        public Builder setMaxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder setBoxWidth(int boxWidth) {
            this.boxWidth = boxWidth;
            return this;
        }

        public Builder setTitle(Component title) {
            this.title = title;
            return this;
        }

        public Builder setResponder(BiConsumer<TextWidgetListElement, String> responder) {
            this.responder = responder;
            return this;
        }

        public Builder setFilter(Predicate<String> filter) {
            this.filter = filter;
            return this;
        }

        public Builder setValidator(Predicate<String> validator) {
            this.validator = validator;
            return this;
        }

        @Override
        public TextWidgetListElement build() {
            if (this.title == null || this.filter == null) {
                throw new IllegalStateException();
            }
            return (TextWidgetListElement)super.build();
        }

        @Override
        protected TextWidgetListElement buildInternal() {
            BiFunction<TextWidgetListElement, Vec3i, AbstractWidget> widgetSupplier = (el, xy) -> {
                TextWidgetEditBox box = new TextWidgetEditBox((TextWidgetListElement)el, Minecraft.m_91087_().f_91062_, xy.m_123341_() + this.w - this.boxWidth - 42, xy.m_123342_(), this.boxWidth, this.h, this.title);
                box.m_94199_(this.maxLength);
                box.m_94144_((String)el.getDraftValue());
                box.m_94151_(s -> el.onTextTyped((String)s));
                box.m_94153_(this.filter);
                return box;
            };
            return new TextWidgetListElement(this.w, this.h, this.mutable, this.title, widgetSupplier, this.tooltip, this.responder, this.validator, (String)this.startValue);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

