/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.monster;

import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Flare
extends FlyingMob {
    private static final EntityDataAccessor<Integer> SIZE = SynchedEntityData.m_135353_(Flare.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Vec3 orbitOffset = Vec3.f_82478_;
    private BlockPos orbitPosition = BlockPos.f_121853_;
    private AttackPhase attackPhase = AttackPhase.CIRCLE;

    public Flare(EntityType<? extends Flare> type, Level world) {
        super(type, world);
        this.f_21364_ = 5;
        this.f_21342_ = new MoveHelperController((Mob)this);
        this.f_21365_ = new LookHelperController((Mob)this);
    }

    protected BodyRotationControl m_7560_() {
        return new BodyHelperController((Mob)this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new PickAttackGoal());
        this.f_21345_.m_25352_(2, (Goal)new SweepAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new OrbitPointGoal());
        this.f_21346_.m_25352_(1, (Goal)new AttackLivingEntityGoal());
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22266_(Attributes.f_22281_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SIZE, (Object)0);
    }

    public void setPhantomSize(int sizeIn) {
        this.f_19804_.m_135381_(SIZE, (Object)Mth.m_14045_((int)sizeIn, (int)0, (int)64));
    }

    private void updatePhantomSize() {
        this.m_6210_();
        this.m_21051_(Attributes.f_22281_).m_22100_((double)(12 + this.getPhantomSize()));
    }

    public int getPhantomSize() {
        return (Integer)this.f_19804_.m_135370_(SIZE);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.35f;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (SIZE.equals(key)) {
            this.updatePhantomSize();
        }
        super.m_7350_(key);
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            float f = Mth.m_14089_((float)((float)(this.m_19879_() * 3 + this.f_19797_) * 0.13f + (float)Math.PI));
            float f1 = Mth.m_14089_((float)((float)(this.m_19879_() * 3 + this.f_19797_ + 1) * 0.13f + (float)Math.PI));
            if (f > 0.0f && f1 <= 0.0f) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12230_, this.m_5720_(), 0.95f + this.f_19796_.m_188501_() * 0.05f, 0.95f + this.f_19796_.m_188501_() * 0.05f, false);
            }
            int i = this.getPhantomSize();
            float f2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float f3 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float f4 = (0.3f + f * 0.45f) * ((float)i * 0.2f + 1.0f);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20185_() + (double)f2, this.m_20186_() + (double)f4, this.m_20189_() + (double)f3, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20185_() - (double)f2, this.m_20186_() + (double)f4, this.m_20189_() - (double)f3, 0.0, 0.0, 0.0);
        }
        if (!this.m_9236_().f_46443_ && this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.orbitPosition = this.m_20183_().m_6630_(5);
        this.setPhantomSize(0);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("AX")) {
            this.orbitPosition = new BlockPos(compound.m_128451_("AX"), compound.m_128451_("AY"), compound.m_128451_("AZ"));
        }
        this.setPhantomSize(compound.m_128451_("Size"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("AX", this.orbitPosition.m_123341_());
        compound.m_128405_("AY", this.orbitPosition.m_123342_());
        compound.m_128405_("AZ", this.orbitPosition.m_123343_());
        compound.m_128405_("Size", this.getPhantomSize());
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        return true;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)UAItems.FLARE_SPAWN_EGG.get());
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12227_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12231_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12229_;
    }

    protected float m_6121_() {
        return 1.0f;
    }

    public boolean m_6549_(EntityType<?> typeIn) {
        return true;
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        int i = this.getPhantomSize();
        EntityDimensions entitysize = super.m_6972_(poseIn);
        float f = (entitysize.f_20377_ + 0.2f * (float)i) / entitysize.f_20377_;
        return entitysize.m_20388_(f);
    }

    static enum AttackPhase {
        CIRCLE,
        SWOOP;

    }

    class MoveHelperController
    extends MoveControl {
        private float speedFactor;

        public MoveHelperController(Mob entityIn) {
            super(entityIn);
            this.speedFactor = 0.1f;
        }

        public void m_8126_() {
            if (Flare.this.f_19862_) {
                Flare.this.m_146922_(Flare.this.m_146908_() + 180.0f);
                this.speedFactor = 0.1f;
            }
            float f = (float)(Flare.this.orbitOffset.f_82479_ - Flare.this.m_20185_());
            float f1 = (float)(Flare.this.orbitOffset.f_82480_ - Flare.this.m_20186_());
            float f2 = (float)(Flare.this.orbitOffset.f_82481_ - Flare.this.m_20189_());
            double d0 = Mth.m_14116_((float)(f * f + f2 * f2));
            double d1 = 1.0 - (double)Mth.m_14154_((float)(f1 * 0.7f)) / d0;
            f = (float)((double)f * d1);
            f2 = (float)((double)f2 * d1);
            d0 = Mth.m_14116_((float)(f * f + f2 * f2));
            double d2 = Mth.m_14116_((float)(f * f + f2 * f2 + f1 * f1));
            float f3 = Flare.this.m_146908_();
            float f4 = (float)Mth.m_14136_((double)f2, (double)f);
            float f5 = Mth.m_14177_((float)(Flare.this.m_146908_() + 90.0f));
            float f6 = Mth.m_14177_((float)(f4 * 57.295776f));
            Flare.this.m_146922_(Mth.m_14148_((float)f5, (float)f6, (float)4.0f) - 90.0f);
            Flare.this.f_20883_ = Flare.this.m_146908_();
            this.speedFactor = Mth.m_14145_((float)f3, (float)Flare.this.m_146908_()) < 3.0f ? Mth.m_14121_((float)this.speedFactor, (float)1.8f, (float)(0.005f * (1.8f / this.speedFactor))) : Mth.m_14121_((float)this.speedFactor, (float)0.2f, (float)0.025f);
            float f7 = (float)(-(Mth.m_14136_((double)(-f1), (double)d0) * 57.2957763671875));
            Flare.this.m_146926_(f7);
            float f8 = Flare.this.m_146908_() + 90.0f;
            double d3 = (double)(this.speedFactor * Mth.m_14089_((float)(f8 * ((float)Math.PI / 180)))) * Math.abs((double)f / d2);
            double d4 = (double)(this.speedFactor * Mth.m_14031_((float)(f8 * ((float)Math.PI / 180)))) * Math.abs((double)f2 / d2);
            double d5 = (double)(this.speedFactor * Mth.m_14031_((float)(f7 * ((float)Math.PI / 180)))) * Math.abs((double)f1 / d2);
            Vec3 vec3d = Flare.this.m_20184_();
            Flare.this.m_20256_(vec3d.m_82549_(new Vec3(d3, d5, d4).m_82546_(vec3d).m_82490_(0.2)));
        }
    }

    class LookHelperController
    extends LookControl {
        public LookHelperController(Mob entityIn) {
            super(entityIn);
        }

        public void m_8128_() {
        }
    }

    class BodyHelperController
    extends BodyRotationControl {
        public BodyHelperController(Mob p_i49925_2_) {
            super(p_i49925_2_);
        }

        public void m_8121_() {
            Flare.this.f_20885_ = Flare.this.f_20883_;
            Flare.this.f_20883_ = Flare.this.m_146908_();
        }
    }

    class PickAttackGoal
    extends Goal {
        private int tickDelay;

        private PickAttackGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = Flare.this.m_5448_();
            return livingentity != null && Flare.this.m_21040_(Flare.this.m_5448_(), TargetingConditions.f_26872_);
        }

        public void m_8056_() {
            this.tickDelay = 10;
            Flare.this.attackPhase = AttackPhase.CIRCLE;
            this.setAnchorAboveTarget();
        }

        public void m_8041_() {
            Flare.this.orbitPosition = Flare.this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING, Flare.this.orbitPosition).m_6630_(10 + Flare.this.f_19796_.m_188503_(20));
        }

        public void m_8037_() {
            if (Flare.this.attackPhase == AttackPhase.CIRCLE) {
                --this.tickDelay;
                if (this.tickDelay <= 0) {
                    Flare.this.attackPhase = AttackPhase.SWOOP;
                    this.setAnchorAboveTarget();
                    this.tickDelay = (8 + Flare.this.f_19796_.m_188503_(4)) * 20;
                    Flare.this.m_5496_(SoundEvents.f_12232_, 10.0f, 0.95f + Flare.this.f_19796_.m_188501_() * 0.1f);
                }
            }
        }

        private void setAnchorAboveTarget() {
            Flare.this.orbitPosition = Flare.this.m_5448_().m_20183_().m_6630_(20 + Flare.this.f_19796_.m_188503_(20));
            if (Flare.this.orbitPosition.m_123342_() < Flare.this.m_9236_().m_5736_()) {
                Flare.this.orbitPosition = new BlockPos(Flare.this.orbitPosition.m_123341_(), Flare.this.m_9236_().m_5736_() + 1, Flare.this.orbitPosition.m_123343_());
            }
        }
    }

    class SweepAttackGoal
    extends MoveGoal {
        private SweepAttackGoal() {
        }

        public boolean m_8036_() {
            return Flare.this.m_5448_() != null && Flare.this.attackPhase == AttackPhase.SWOOP;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = Flare.this.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (!(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_()) {
                List list;
                if (!this.m_8036_()) {
                    return false;
                }
                if (Flare.this.f_19797_ % 20 == 0 && !(list = Flare.this.m_9236_().m_6443_(Cat.class, Flare.this.m_20191_().m_82400_(16.0), EntitySelector.f_20402_)).isEmpty()) {
                    for (Cat catentity : list) {
                        catentity.m_28167_();
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        public void m_8056_() {
        }

        public void m_8041_() {
            if (Flare.this.m_5448_() instanceof Player) {
                Flare.this.m_6710_(null);
            }
            Flare.this.attackPhase = AttackPhase.CIRCLE;
        }

        public void m_8037_() {
            LivingEntity livingentity = Flare.this.m_5448_();
            Flare.this.orbitOffset = new Vec3(livingentity.m_20185_(), livingentity.m_20186_() + (double)livingentity.m_20206_() * 0.5, livingentity.m_20189_());
            if (Flare.this.m_20191_().m_82400_((double)0.2f).m_82381_(livingentity.m_20191_())) {
                Flare.this.m_7327_((Entity)livingentity);
                Flare.this.attackPhase = AttackPhase.CIRCLE;
                Flare.this.m_9236_().m_46796_(1039, Flare.this.m_20183_(), 0);
            } else if (Flare.this.f_19862_ || Flare.this.f_20916_ > 0) {
                Flare.this.attackPhase = AttackPhase.CIRCLE;
            }
        }
    }

    class OrbitPointGoal
    extends MoveGoal {
        private float angle;
        private float distance;
        private float height;
        private float clockwise;

        private OrbitPointGoal() {
        }

        public boolean m_8036_() {
            return Flare.this.m_5448_() == null || Flare.this.attackPhase == AttackPhase.CIRCLE;
        }

        public void m_8056_() {
            this.distance = 5.0f + Flare.this.f_19796_.m_188501_() * 10.0f;
            this.height = -4.0f + Flare.this.f_19796_.m_188501_() * 9.0f;
            this.clockwise = Flare.this.f_19796_.m_188499_() ? 1.0f : -1.0f;
            this.selectNext();
        }

        public void m_8037_() {
            if (Flare.this.f_19796_.m_188503_(350) == 0) {
                this.height = -4.0f + Flare.this.f_19796_.m_188501_() * 9.0f;
            }
            if (Flare.this.f_19796_.m_188503_(250) == 0) {
                this.distance += 1.0f;
                if (this.distance > 15.0f) {
                    this.distance = 5.0f;
                    this.clockwise = -this.clockwise;
                }
            }
            if (Flare.this.f_19796_.m_188503_(450) == 0) {
                this.angle = Flare.this.f_19796_.m_188501_() * 2.0f * (float)Math.PI;
                this.selectNext();
            }
            if (this.touchingTarget()) {
                this.selectNext();
            }
            if (Flare.this.orbitOffset.f_82480_ < Flare.this.m_20186_() && !Flare.this.m_9236_().m_46859_(Flare.this.m_20183_().m_6625_(1))) {
                this.height = Math.max(1.0f, this.height);
                this.selectNext();
            }
            if (Flare.this.orbitOffset.f_82480_ > Flare.this.m_20186_() && !Flare.this.m_9236_().m_46859_(Flare.this.m_20183_().m_6630_(1))) {
                this.height = Math.min(-1.0f, this.height);
                this.selectNext();
            }
        }

        private void selectNext() {
            if (BlockPos.f_121853_.equals((Object)Flare.this.orbitPosition)) {
                Flare.this.orbitPosition = Flare.this.m_20183_();
            }
            this.angle += this.clockwise * 15.0f * ((float)Math.PI / 180);
            Flare.this.orbitOffset = new Vec3((double)Flare.this.orbitPosition.m_123341_(), (double)Flare.this.orbitPosition.m_123342_(), (double)Flare.this.orbitPosition.m_123343_()).m_82520_((double)(this.distance * Mth.m_14089_((float)this.angle)), (double)(-4.0f + this.height), (double)(this.distance * Mth.m_14031_((float)this.angle)));
        }
    }

    public class AttackLivingEntityGoal
    extends Goal {
        private final TargetingConditions attackTargeting = TargetingConditions.m_148352_().m_26883_(64.0);
        private int tickDelay = 20;

        private AttackLivingEntityGoal() {
        }

        public boolean m_8036_() {
            if (this.tickDelay > 0) {
                --this.tickDelay;
                return false;
            }
            this.tickDelay = 60;
            List list = Flare.this.m_9236_().m_45971_(LivingEntity.class, this.attackTargeting, (LivingEntity)Flare.this, Flare.this.m_20191_().m_82377_(16.0, 64.0, 16.0));
            if (!list.isEmpty()) {
                for (LivingEntity mob : list) {
                    if (!Flare.this.m_21040_(mob, TargetingConditions.f_26872_)) continue;
                    if (mob instanceof ServerPlayer) {
                        ServerStatsCounter statisticsManager = ((ServerPlayer)mob).m_8951_();
                        if (statisticsManager.m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12992_)) >= 72000) continue;
                        Flare.this.m_6710_(mob);
                        return true;
                    }
                    if (mob instanceof Flare) continue;
                    Flare.this.m_6710_(mob);
                    return true;
                }
            }
            return false;
        }

        public boolean m_8045_() {
            ServerStatsCounter statisticsManager;
            LivingEntity livingentity = Flare.this.m_5448_();
            if (livingentity instanceof ServerPlayer && (statisticsManager = ((ServerPlayer)livingentity).m_8951_()).m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12992_)) < 72000) {
                return Flare.this.m_21040_(livingentity, TargetingConditions.f_26872_);
            }
            return livingentity != null;
        }
    }

    abstract class MoveGoal
    extends Goal {
        public MoveGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        protected boolean touchingTarget() {
            return Flare.this.orbitOffset.m_82531_(Flare.this.m_20185_(), Flare.this.m_20186_(), Flare.this.m_20189_()) < 4.0;
        }
    }
}

