/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.block.coralstone;

import com.teamabnormals.blueprint.core.util.BlockUtil;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CoralWallFanBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.Tags;

public class CoralstoneBlock
extends Block {
    public static final BooleanProperty POWERED = BooleanProperty.m_61465_((String)"powered");
    @Nullable
    private final Block[] growableCoralBlocks;
    private final boolean chiseled;

    public CoralstoneBlock(BlockBehaviour.Properties properties, boolean chiseled) {
        this(properties, chiseled, null);
    }

    public CoralstoneBlock(BlockBehaviour.Properties properties, boolean chiseled, @Nullable Block[] growableCoralBlocks) {
        super(properties);
        this.chiseled = chiseled;
        this.growableCoralBlocks = growableCoralBlocks;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_204117_(Tags.Items.SHEARS) && state.m_60734_() != UABlocks.CHISELED_CORALSTONE.get() && state.m_60734_() != UABlocks.CORALSTONE.get()) {
            BlockState newState = this.chiseled ? ((Block)UABlocks.CHISELED_CORALSTONE.get()).m_49966_() : ((Block)UABlocks.CORALSTONE.get()).m_49966_();
            world.m_5594_(null, pos, SoundEvents.f_12075_, SoundSource.PLAYERS, 1.0f, 0.8f);
            stack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(hand));
            world.m_7731_(pos, newState, 2);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (!worldIn.isAreaLoaded(pos, 3)) {
            return;
        }
        Block block = state.m_60734_();
        if (this.growableCoralBlocks == null && block != UABlocks.DEAD_CORALSTONE.get() && block != UABlocks.DEAD_CHISELED_CORALSTONE.get()) {
            CoralstoneBlock.tickConversion(this.chiseled ? UABlocks.CHISELED_CORALSTONE_CONVERSION_MAP : UABlocks.CORALSTONE_CONVERSION_MAP, state, worldIn, pos, random);
        }
        if (this.growableCoralBlocks != null && random.m_188501_() < 0.12f) {
            boolean isValidPosToGrow;
            Direction randDirection = this.growableCoralBlocks.length > 3 ? Direction.m_235672_((RandomSource)random) : Direction.m_122376_((int)(random.m_188503_(5) + 1));
            BlockPos growPos = pos.m_121945_(randDirection);
            FluidState fluidState = worldIn.m_8055_(growPos).m_60819_();
            boolean bl = isValidPosToGrow = worldIn.m_8055_(growPos).m_247087_() && fluidState.m_76186_() >= 8 && fluidState.m_205070_(FluidTags.f_13131_);
            if (isValidPosToGrow && ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
                if (randDirection.m_122411_() > 1) {
                    worldIn.m_7731_(growPos, (BlockState)this.growableCoralBlocks[2].m_49966_().m_61124_((Property)CoralWallFanBlock.f_49192_, (Comparable)randDirection), 2);
                } else if (randDirection.m_122411_() == 1) {
                    if (random.m_188499_()) {
                        worldIn.m_7731_(growPos, this.growableCoralBlocks[1].m_49966_(), 2);
                    } else {
                        worldIn.m_7731_(growPos, this.growableCoralBlocks[0].m_49966_(), 2);
                    }
                } else {
                    worldIn.m_7731_(growPos, this.growableCoralBlocks[3].m_49966_(), 2);
                }
            }
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!worldIn.f_46443_ && (flag = ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) != worldIn.m_276867_(pos)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_())));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED});
    }

    public static void tickConversion(Map<Supplier<Block>, Supplier<Block>> conversionMap, BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        for (int i = 0; i < 4; ++i) {
            Block randomBlock = world.m_8055_(pos.m_7918_(random.m_188503_(3) - 1, random.m_188503_(5) - 3, random.m_188503_(3) - 1)).m_60734_();
            conversionMap.forEach((input, output) -> {
                if (input.get() == randomBlock) {
                    world.m_7731_(pos, BlockUtil.transferAllBlockStates((BlockState)state, (BlockState)((Block)output.get()).m_49966_()), 2);
                }
            });
        }
    }
}

