/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.teamabnormals.upgrade_aquatic.common.block.JellyTorchBlock;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class JellyWallTorchBlock
extends JellyTorchBlock {
    public static final DirectionProperty HORIZONTAL_FACING = HorizontalDirectionalBlock.f_54117_;
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)13.0, (double)5.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)13.0, (double)10.5), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)13.0, (double)10.5)));
    private final JellyTorchBlock.JellyTorchType torchType;

    public JellyWallTorchBlock(BlockBehaviour.Properties properties, JellyTorchBlock.JellyTorchType torchType) {
        super(properties, torchType);
        this.torchType = torchType;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.m_61143_((Property)HORIZONTAL_FACING));
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
        BlockPos blockpos = pos.m_121945_(direction.m_122424_());
        BlockState blockstate = worldIn.m_8055_(blockpos);
        return blockstate.m_60783_((BlockGetter)worldIn, blockpos, direction);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction[] adirection;
        BlockState blockstate = this.m_49966_();
        Level iworldreader = context.m_43725_();
        FluidState ifluidstate = context.m_43725_().m_6425_(context.m_8083_());
        BlockPos blockpos = context.m_8083_();
        for (Direction direction : adirection = context.m_6232_()) {
            Direction direction1;
            if (!direction.m_122434_().m_122479_() || !(blockstate = (BlockState)blockstate.m_61124_((Property)HORIZONTAL_FACING, (Comparable)(direction1 = direction.m_122424_()))).m_60710_((LevelReader)iworldreader, blockpos)) continue;
            return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        FluidState ifluidstate = worldIn.m_6425_(currentPos);
        return facing.m_122424_() == stateIn.m_61143_((Property)HORIZONTAL_FACING) && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : (BlockState)stateIn.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        Direction direction = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
        double xOffset = random.m_188499_() ? -(Math.random() * 0.075) : Math.random() * 0.075;
        double yOffset = random.m_188499_() ? -(Math.random() * 0.075) : Math.random() * 0.075;
        double zOffset = random.m_188499_() ? -(Math.random() * 0.075) : Math.random() * 0.075;
        double d0 = (double)pos.m_123341_() + 0.5 + xOffset;
        double d1 = (double)pos.m_123342_() + 0.45 + yOffset;
        double d2 = (double)pos.m_123343_() + 0.5 + zOffset;
        double d3 = 0.18;
        double d4 = 0.3;
        Direction facing = direction.m_122424_();
        world.m_7106_((ParticleOptions)JellyTorchBlock.JellyTorchType.getTorchParticleType(this.torchType), d0 + d4 * (double)facing.m_122429_(), d1 + d3, d2 + d4 * (double)facing.m_122431_(), 0.0, 0.004, 0.0);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)HORIZONTAL_FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    @Override
    public void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HORIZONTAL_FACING, WATERLOGGED});
    }
}

