/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.hs_err;

import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReason;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogType;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.hs_err_parser.HsErrParser;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.hs_err_parser.HsErrParsingResult;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListDiff;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import java.util.HashMap;
import java.util.Optional;

public class InsufficientMemory
extends KnownCrashReason {
    public InsufficientMemory() {
        super(LogType.HS_ERR, InsufficientMemory.applyEndRecommendations(LanguageProvider.get((String)"warnings.insufficient_memory")), new String[0]);
    }

    public static String applyEndRecommendations(String message) {
        String endRecommendations = PlatformHelp.isLinkDefault() || ModListDiff.isModpackCreator() ? LanguageProvider.get((String)"warnings.insufficient_memory_indv", (HashMap)new HashMap<String, String>(){
            {
                this.put("$LINK.MODERN_FIX$", "ModernFix");
                this.put("$LINK.FERRITE_CORE$", "FerriteCore");
            }
        }) : LanguageProvider.get((String)"warnings.insufficient_memory_modpacks");
        return message.replace("$END_RECOMMENDATIONS$", endRecommendations);
    }

    @Override
    public boolean matches(Log log) {
        if (!HsErrParser.hsErrContainsOneOfFrames(log, "# There is insufficient memory for the Java Runtime Environment to continue.")) {
            return false;
        }
        Object additionalInfo = "";
        Optional<HsErrParsingResult> hsErrParsingResult = HsErrParser.parseHsErr(log);
        if (hsErrParsingResult.isPresent() && hsErrParsingResult.get().isPageFileDisabled()) {
            additionalInfo = (String)additionalInfo + LanguageProvider.get((String)"warnings.insufficient_memory.page_file_disabled");
        }
        if (!((String)additionalInfo).isEmpty()) {
            additionalInfo = "<span style=\"color:green\">" + (String)additionalInfo + "</span>\n";
        }
        this.message = this.message.replace("$FIRST_PRIORITY_WARNINGS$", (CharSequence)additionalInfo);
        return true;
    }
}

