/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.exceptions.DeclinedException;
import dev.kostromdan.mods.crash_assistant.app.exceptions.UploadException;
import dev.kostromdan.mods.crash_assistant.app.gui.ControlPanel;
import dev.kostromdan.mods.crash_assistant.app.gui.CrashAssistantGUI;
import dev.kostromdan.mods.crash_assistant.app.gui.FileListPanel;
import dev.kostromdan.mods.crash_assistant.app.gui.PrivacyPolicyDialog;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReasonMessage;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogAnalyser;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogType;
import dev.kostromdan.mods.crash_assistant.app.utils.ClipboardUtils;
import dev.kostromdan.mods.crash_assistant.app.utils.DragAndDrop;
import dev.kostromdan.mods.crash_assistant.app.utils.uploading_apis.ApiProvider;
import dev.kostromdan.mods.crash_assistant.app.utils.uploading_apis.Problem;
import dev.kostromdan.mods.crash_assistant.app.utils.uploading_apis.UploadLogResponse;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class FilePanel {
    private final JPanel panel;
    private final JButton showButton;
    private final JButton openButton;
    private final JButton uploadButton;
    private final JButton browserButton;
    private Exception lastError = null;
    private boolean waiting = true;
    private static final Set<FilePanel> awaitingPrivacyPolicyDialogs = Collections.synchronizedSet(new HashSet());
    private final Log log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilePanel(Log log) {
        this.log = log;
        this.panel = new JPanel(new BorderLayout());
        this.panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        DragAndDrop.enableDragAndDrop(this.panel, Collections.singletonList(log.getFile()));
        JLabel fileNameLabel = new JLabel(log.getName());
        this.panel.add((Component)fileNameLabel, "Center");
        JPanel spacerPanel = new JPanel();
        spacerPanel.setPreferredSize(new Dimension(0, 0));
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 5, 0));
        this.openButton = this.createButton(LanguageProvider.get((String)"gui.open_button"), e -> this.openFile());
        this.showButton = this.createButton(LanguageProvider.get((String)"gui.show_in_explorer_button"), e -> this.showInExplorer());
        this.uploadButton = this.createButton(LanguageProvider.get((String)"gui.upload_and_copy_link_button"), e -> this.uploadFile());
        Class<ControlPanel> clazz = ControlPanel.class;
        synchronized (ControlPanel.class) {
            this.uploadButton.setEnabled(ControlPanel.uploadButtonsActivated);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            this.browserButton = this.createButtonWithIcon("assets/internet.png", e -> this.openInBrowser());
            this.browserButton.setVisible(false);
            this.browserButton.setToolTipText(LanguageProvider.get((String)"gui.browser_button_tooltip"));
            buttonPanel.add(spacerPanel);
            buttonPanel.add(this.openButton);
            buttonPanel.add(this.showButton);
            buttonPanel.add(this.uploadButton);
            buttonPanel.add(this.browserButton);
            this.panel.add((Component)buttonPanel, "East");
            this.panel.setMinimumSize(new Dimension(0, this.panel.getPreferredSize().height));
            this.panel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.panel.getPreferredSize().height));
            return;
        }
    }

    public JButton createButton(String text, ActionListener actionListener) {
        JButton button = new JButton(text);
        button.addActionListener(actionListener);
        return button;
    }

    private JButton createButtonWithIcon(String iconPath, ActionListener actionListener) {
        JButton button = new JButton();
        try {
            InputStream imageStream = FilePanel.class.getClassLoader().getResourceAsStream(iconPath);
            if (imageStream != null) {
                BufferedImage originalImage = ImageIO.read(imageStream);
                JButton temp = new JButton("\ud83c\udf10");
                FontMetrics fm = temp.getFontMetrics(temp.getFont());
                int iconHeight = fm.getHeight();
                Image resized = originalImage.getScaledInstance(iconHeight, iconHeight, 4);
                ImageIcon icon = new ImageIcon(resized);
                button.setIcon(icon);
            } else {
                button.setText("\ud83c\udf10");
            }
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Error creating button with icon: ", (Throwable)e);
            button.setText("\ud83c\udf10");
        }
        Dimension textSize = new JButton("\ud83c\udf10").getPreferredSize();
        button.setPreferredSize(textSize);
        button.setMinimumSize(button.getPreferredSize());
        button.setMargin(new Insets(0, 0, 0, 0));
        button.addActionListener(actionListener);
        return button;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private void openFile() {
        ControlPanel.stopMovingToTop = true;
        try {
            Desktop.getDesktop().open(this.log.getFile());
        }
        catch (IOException e) {
            CrashAssistantApp.LOGGER.error("Failed to open file: ", (Throwable)e);
        }
    }

    private void showInExplorer() {
        ControlPanel.stopMovingToTop = true;
        try {
            if (System.getProperty("os.name").startsWith("Windows")) {
                new ProcessBuilder("explorer.exe", "/select,", this.log.getPath().toAbsolutePath().toString()).start();
            } else {
                Desktop.getDesktop().open(this.log.getFile().getParentFile());
            }
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Failed to show file in explorer: ", (Throwable)e);
        }
    }

    private void openInBrowser() {
        String linkToCopy = this.log.getLinkToUploadedFirstLines();
        if (this.log.getLinkToUploadedLastLines() != null) {
            linkToCopy = this.showLogPartSelectionDialog(LanguageProvider.get((String)"gui.split_log_dialog_action_browser"));
        }
        if (linkToCopy == null) {
            return;
        }
        try {
            Desktop.getDesktop().browse(new URL(linkToCopy).toURI());
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Failed to open in link browser: ", (Throwable)e);
        }
    }

    public Log getLog() {
        return this.log;
    }

    public Exception getLastError() {
        return this.lastError;
    }

    public boolean isUploadButtonEnabled() {
        return this.uploadButton.isEnabled();
    }

    public void setUploadButtonEnabled(boolean enabled) {
        this.uploadButton.setEnabled(enabled);
    }

    private void uploadFile() {
        this.uploadFile(true);
    }

    public synchronized void uploadFile(boolean fromButton) {
        ControlPanel.stopMovingToTop = true;
        if (!this.uploadButton.isEnabled()) {
            return;
        }
        this.uploadButton.setEnabled(false);
        new Thread(() -> {
            if (this.log.getLinkToUploadedFirstLines() == null) {
                this.lastError = null;
                this.uploadButton.setPreferredSize(new Dimension(this.uploadButton.getMinimumSize().width, 25));
                this.uploadButton.setText(LanguageProvider.get((String)"gui.uploading"));
                try {
                    awaitingPrivacyPolicyDialogs.add(this);
                    Class<FileListPanel> clazz = FileListPanel.class;
                    // MONITORENTER : dev.kostromdan.mods.crash_assistant.app.gui.FileListPanel.class
                    if (!awaitingPrivacyPolicyDialogs.contains(this)) {
                        throw new DeclinedException(LanguageProvider.get((String)"gui.privacy.declined"));
                    }
                    AtomicBoolean accepted = new AtomicBoolean(true);
                    SwingUtilities.invokeAndWait(() -> {
                        if (!PrivacyPolicyDialog.showPrivacyPolicyDialog()) {
                            awaitingPrivacyPolicyDialogs.clear();
                            accepted.set(false);
                        }
                    });
                    if (!accepted.get()) {
                        throw new DeclinedException(LanguageProvider.get((String)"gui.privacy.declined"));
                    }
                    // MONITOREXIT : clazz
                    String oldText = this.uploadButton.getText();
                    if (!fromButton && this.log.getType() == LogType.CRASH_ASSISTANT) {
                        List logsCodexSupports = CrashAssistantGUI.fileListPanel.filePanelList.stream().filter(x -> LogAnalyser.CodexSupportedLogTypes.contains((Object)x.getLog().getType())).collect(Collectors.toList());
                        while (!logsCodexSupports.isEmpty()) {
                            this.uploadButton.setText(LanguageProvider.get((String)"gui.delayed"));
                            Thread.sleep(100L);
                            if (logsCodexSupports.stream().anyMatch(x -> x.getLastError() != null)) {
                                throw new UploadException("Crash Assistant log must be uploaded after logs, Codex supports. But encountered error while uploading one of them.");
                            }
                            if (!logsCodexSupports.stream().allMatch(x -> x.getLog().getLinkToUploadedFirstLines() != null)) continue;
                        }
                    }
                    this.uploadButton.setText(LanguageProvider.get((String)"gui.preprocessing"));
                    this.log.getReader().readLogFile(true);
                    this.uploadButton.setText(oldText);
                    CompletableFuture<UploadLogResponse> completableResponseFirstLines = ApiProvider.getMcLogsClient().uploadLog(this.log.getReader().getFirstLinesString());
                    String lastLines = this.log.getReader().getLastLinesString();
                    if (lastLines != null) {
                        CompletableFuture<UploadLogResponse> completableResponseLastLines = ApiProvider.getMcLogsClient().uploadLog(lastLines);
                        UploadLogResponse responseLastLines = completableResponseLastLines.get();
                        responseLastLines.setClient(ApiProvider.getMcLogsClient());
                        if (!responseLastLines.isSuccess()) throw new UploadException("An error occurred when uploading file: " + responseLastLines.getError());
                        this.log.setLinkToUploadedLastLines(CrashAssistantGUI.transformLink(responseLastLines.getUrl()));
                    }
                    UploadLogResponse responseFirstLines = completableResponseFirstLines.get();
                    responseFirstLines.setClient(ApiProvider.getMcLogsClient());
                    if (!responseFirstLines.isSuccess()) throw new UploadException("An error occurred when uploading file: " + responseFirstLines.getError());
                    String link = CrashAssistantGUI.transformLink(responseFirstLines.getUrl());
                    if (LogAnalyser.CodexSupportedLogTypes.contains((Object)this.log.getType())) {
                        Class<KnownCrashReasonMessage> clazz2 = KnownCrashReasonMessage.class;
                        // MONITORENTER : dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReasonMessage.class
                        for (Problem problem : responseFirstLines.getInsights().get().getProblems()) {
                            KnownCrashReasonMessage.addCodexMessage(this.log, problem, link);
                        }
                        CrashAssistantGUI.showKnownCrashReasonsWarnings();
                        // MONITOREXIT : clazz2
                    }
                    this.log.setLinkToUploadedFirstLines(link);
                }
                catch (Exception e) {
                    this.lastError = e;
                    CrashAssistantApp.LOGGER.info("Failed to upload file \"" + String.valueOf(this.log.getPath()) + "\": ", (Throwable)e);
                    this.uploadButton.setText(LanguageProvider.get((String)"gui.error"));
                    CrashAssistantGUI.highlightButton(this.uploadButton, new Color(255, 100, 100), 3000L);
                    if (fromButton) {
                        Object message = LanguageProvider.get((String)"gui.failed_to_upload_file") + " \"" + String.valueOf(this.log.getPath()) + "\": " + String.valueOf(e);
                        if (e instanceof DeclinedException) {
                            message = e.getMessage();
                        }
                        JOptionPane.showMessageDialog(this.panel, message, LanguageProvider.get((String)"gui.failed_to_upload_file") + "!", 0);
                    }
                    new Timer().schedule(new TimerTask(){

                        @Override
                        public void run() {
                            FilePanel.this.uploadButton.setText(LanguageProvider.get((String)"gui.upload_and_copy_link_button"));
                            FilePanel.this.uploadButton.setEnabled(true);
                        }
                    }, 3000L);
                    return;
                }
            }
            String linkToCopy = this.log.getLinkToUploadedFirstLines();
            if (fromButton) {
                if (this.log.getLinkToUploadedLastLines() != null) {
                    linkToCopy = this.showLogPartSelectionDialog(LanguageProvider.get((String)"gui.split_log_dialog_action_copy"));
                }
                if (linkToCopy != null) {
                    ClipboardUtils.copy(linkToCopy);
                }
                this.transformCopyLinkButton();
                if (linkToCopy != null) {
                    this.uploadButton.setText(LanguageProvider.get((String)"gui.copied"));
                    CrashAssistantGUI.highlightButton(this.uploadButton, new Color(100, 255, 100), 3000L);
                    this.uploadButton.setEnabled(false);
                }
            }
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    FilePanel.this.uploadButton.setText(LanguageProvider.get((String)"gui.copy_link_button"));
                    FilePanel.this.transformCopyLinkButton();
                    FilePanel.this.uploadButton.setEnabled(true);
                }
            }, fromButton && linkToCopy != null ? 3000L : 0L);
        }).start();
    }

    private void transformCopyLinkButton() {
        String oldText = this.uploadButton.getText();
        this.browserButton.setVisible(true);
        this.uploadButton.setText(LanguageProvider.get((String)"gui.upload_and_copy_link_button"));
        this.uploadButton.setPreferredSize(new Dimension(this.uploadButton.getMinimumSize().width - this.browserButton.getMinimumSize().width - 5, this.uploadButton.getMinimumSize().height));
        this.uploadButton.setText(oldText);
    }

    public String getTooBigReasons(boolean forMsg) {
        Function langFunc = LanguageProvider.getLangFunction((boolean)forMsg);
        long size = this.log.getFile().length();
        ArrayList<CallSite> tooBigReasons = new ArrayList<CallSite>();
        if (size > 0xA00000L) {
            tooBigReasons.add((CallSite)((Object)("~" + size / 0x100000L + (String)langFunc.apply("msg.mb"))));
        }
        if (this.log.getReader().getCountedLines() > 25000) {
            tooBigReasons.add((CallSite)((Object)((String)(this.log.getReader().isLineCountInterrupted() ? (String)langFunc.apply("msg.over") + " " : "~") + this.log.getReader().getCountedLines() / 1000 + (String)langFunc.apply("msg.k_lines"))));
        }
        return tooBigReasons.isEmpty() ? "" : "(" + String.join((CharSequence)" & ", tooBigReasons) + ")";
    }

    public String getMessageWithBothLinks(boolean forMsg) {
        Function langFunc = LanguageProvider.getLangFunction((boolean)forMsg);
        return this.log.getParentName() + "[" + this.log.getFileName() + " " + ((String)langFunc.apply("gui.split_log_dialog_head")).toLowerCase() + "](<" + this.log.getLinkToUploadedFirstLines() + ">) / [" + ((String)langFunc.apply("gui.split_log_dialog_tail")).toLowerCase() + "](<" + this.log.getLinkToUploadedLastLines() + ">) " + this.getTooBigReasons(forMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String showLogPartSelectionDialog(String action) {
        JEditorPane logSelectionPane = CrashAssistantGUI.getEditorPane(LanguageProvider.get((String)"gui.copy_split_log_dialog_text").replace("$LOG_TOO_BIG_REASON$", this.getTooBigReasons(false)).replace("$FILE_NAME$", this.log.getFileName()).replace("$ACTION$", action), false);
        Object[] options = new Object[]{LanguageProvider.get((String)"gui.split_log_dialog_msg_with_both"), LanguageProvider.get((String)"gui.split_log_dialog_head"), LanguageProvider.get((String)"gui.split_log_dialog_tail")};
        JOptionPane optionPane = action.equals(LanguageProvider.get((String)"gui.split_log_dialog_action_copy")) ? new JOptionPane(logSelectionPane, 3, 1, null, options) : new JOptionPane(logSelectionPane, 3, 0, null, Arrays.copyOfRange(options, 1, 3));
        Class<FileListPanel> clazz = FileListPanel.class;
        synchronized (FileListPanel.class) {
            Object selectedValue;
            if (FileListPanel.currentLogSelectionDialog != null) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return null;
            }
            FileListPanel.currentLogSelectionDialog = optionPane.createDialog(this.panel, LanguageProvider.get((String)"gui.copy_split_log_dialog_title"));
            // ** MonitorExit[var5_5] (shouldn't be in output)
            FileListPanel.currentLogSelectionDialog.setVisible(true);
            while ((selectedValue = optionPane.getValue()) == JOptionPane.UNINITIALIZED_VALUE) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (selectedValue != null) {
                if (selectedValue.equals(options[0])) {
                    selectedValue = this.getMessageWithBothLinks(true);
                } else if (selectedValue.equals(options[1])) {
                    selectedValue = this.log.getLinkToUploadedFirstLines();
                } else if (selectedValue.equals(options[2])) {
                    selectedValue = this.log.getLinkToUploadedLastLines();
                }
            }
            FileListPanel.currentLogSelectionDialog = null;
            return (String)selectedValue;
        }
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    public void setWaiting(boolean waiting) {
        this.waiting = waiting;
    }
}

