/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.gui.CrashAssistantGUI;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantLocalConfig;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LinksProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import dev.kostromdan.mods.crash_assistant.common_config.utils.JavaBinaryLocator;
import dev.kostromdan.mods.crash_assistant.common_config.utils.maven_version_cmp.ComparableVersion;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class CreateDependencies {
    private static volatile boolean isCancelled = false;
    private static final List<Process> runningProcesses = Collections.synchronizedList(new ArrayList());
    private static ExecutorService executor;
    private static final Color ERROR_COLOR;
    private static final Color NORMAL_COLOR;
    private static final Color CREATE_MOD_COLOR;

    private static void appendStyledText(JTextPane textPane, String text, Color color) {
        StyledDocument doc = textPane.getStyledDocument();
        Style style = textPane.addStyle("Color Style", null);
        StyleConstants.setForeground(style, color);
        try {
            doc.insertString(doc.getLength(), text, style);
        }
        catch (BadLocationException e) {
            CrashAssistantApp.LOGGER.error("Error appending styled text: ", (Throwable)e);
            try {
                doc.insertString(doc.getLength(), text, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public static List<Mod> getCurrentCreateMods() {
        return ModListUtils.getCurrentModList((boolean)true).stream().filter(mod -> Objects.equals(mod.getModId(), "create")).collect(Collectors.toList());
    }

    public static boolean isCreateClass(String className) {
        return (className.startsWith("com/simibubi/create") || className.startsWith("com/jozufozu/flywheel") || className.startsWith("net/createmod") || className.startsWith("dev/engine_room")) && className.endsWith(".class");
    }

    public static String fixClassName(String className) {
        int dollarIndex;
        if (className.endsWith(".class")) {
            className = className.substring(0, className.length() - 6);
        }
        if ((dollarIndex = className.indexOf(36)) != -1) {
            className = className.substring(0, dollarIndex);
        }
        return className;
    }

    public static boolean validateJdepsPath(String jdepsPath) {
        try {
            new ProcessBuilder(jdepsPath, "-version").start();
            return true;
        }
        catch (Exception ex) {
            CrashAssistantApp.LOGGER.warn("Error while trying jdeps path: {}\n{}", (Object)jdepsPath, (Object)ex.getMessage());
            return false;
        }
    }

    public static String transformJavaHomeToJdepsPath(String javaHome) {
        if (javaHome != null && !javaHome.isEmpty()) {
            String osName = System.getProperty("os.name").toLowerCase();
            if (javaHome.endsWith(File.separator)) {
                javaHome = javaHome.substring(0, javaHome.length() - 1);
            }
            if (javaHome.endsWith("bin")) {
                if (osName.contains("win")) {
                    return javaHome + File.separator + "jdeps.exe";
                }
                return javaHome + File.separator + "jdeps";
            }
            if (osName.contains("win")) {
                return javaHome + File.separator + "bin" + File.separator + "jdeps.exe";
            }
            return javaHome + File.separator + "bin" + File.separator + "jdeps";
        }
        return null;
    }

    public static String transformJavaBinaryPathToJdepsPath(String javaBinaryPath) {
        return javaBinaryPath.replaceAll("(?<=[/\\\\])java(\\.exe)?$", "jdeps$1");
    }

    private static String removeVendorPrefix(String folderName) {
        return folderName.replaceAll("^[a-zA-Z]+-", "");
    }

    public static String getJDepsPath() {
        String valueFromConfig;
        ProcessBuilder processBuilder;
        String jdepsPath;
        String javaBinaryPath = JavaBinaryLocator.getJavaBinary();
        if (javaBinaryPath.contains("javaw")) {
            javaBinaryPath = javaBinaryPath.replace("javaw", "java");
        }
        if (CreateDependencies.validateJdepsPath(jdepsPath = CreateDependencies.transformJavaBinaryPathToJdepsPath(javaBinaryPath))) {
            return jdepsPath;
        }
        String javaHome = System.getenv("JAVA_HOME");
        CrashAssistantApp.LOGGER.info("System.getenv(\"JAVA_HOME\"): {}", (Object)javaHome);
        String javaHomeToJdepsPath = CreateDependencies.transformJavaHomeToJdepsPath(javaHome);
        if (CreateDependencies.validateJdepsPath(javaHomeToJdepsPath)) {
            return javaHomeToJdepsPath;
        }
        try {
            processBuilder = PlatformHelp.isWindows() ? new ProcessBuilder("cmd.exe", "/c", "echo %JAVA_HOME%") : new ProcessBuilder("/bin/sh", "-c", "echo $JAVA_HOME");
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = reader.readLine();
            CrashAssistantApp.LOGGER.info("Echo JAVA_HOME output: {}", (Object)string);
            String echoJdepsPath = CreateDependencies.transformJavaHomeToJdepsPath(string);
            if (CreateDependencies.validateJdepsPath(echoJdepsPath)) {
                return echoJdepsPath;
            }
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.warn("Error while trying to get JAVA_HOME from echo: {}", (Object)e.getMessage());
        }
        try {
            String osName = System.getProperty("os.name").toLowerCase();
            processBuilder = osName.contains("win") ? new ProcessBuilder("cmd.exe", "/c", "where java") : new ProcessBuilder("/bin/sh", "-c", "which java");
            Process process = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String javaPath = bufferedReader.readLine();
            CrashAssistantApp.LOGGER.info("Java command location: {}", (Object)javaPath);
            String cmdJdepsPath = CreateDependencies.transformJavaBinaryPathToJdepsPath(javaPath);
            if (CreateDependencies.validateJdepsPath(cmdJdepsPath)) {
                return cmdJdepsPath;
            }
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.warn("Error while trying to get Java from command location: {}", (Object)e.getMessage());
        }
        if (CreateDependencies.validateJdepsPath("jdeps")) {
            return "jdeps";
        }
        if (PlatformHelp.isWindows()) {
            ArrayList<Object> javaDirectories = new ArrayList<Object>();
            javaDirectories.add("C:\\Program Files\\Java");
            javaDirectories.add("C:\\Program Files\\Eclipse Adoptium");
            javaDirectories.add(System.getProperty("user.home") + "\\.jdks");
            ArrayList<File> javaFolders = new ArrayList<File>();
            for (String string : javaDirectories) {
                File[] folders;
                File dir = new File(string);
                if (!dir.exists() || !dir.isDirectory() || (folders = dir.listFiles(File::isDirectory)) == null) continue;
                for (File folder : folders) {
                    javaFolders.add(folder);
                }
            }
            javaFolders.sort((f1, f2) -> {
                try {
                    String name1 = CreateDependencies.removeVendorPrefix(f1.getName());
                    String name2 = CreateDependencies.removeVendorPrefix(f2.getName());
                    ComparableVersion v1 = new ComparableVersion(name1);
                    ComparableVersion v2 = new ComparableVersion(name2);
                    return v2.compareTo(v1);
                }
                catch (Exception e) {
                    CrashAssistantApp.LOGGER.warn("Error while comparing Java versions: {}", (Object)e.getMessage());
                    return f1.getName().compareTo(f2.getName());
                }
            });
            for (File file : javaFolders) {
                String folderJdepsPath = CreateDependencies.transformJavaHomeToJdepsPath(file.getAbsolutePath());
                if (!CreateDependencies.validateJdepsPath(folderJdepsPath)) continue;
                return folderJdepsPath;
            }
        }
        if ((valueFromConfig = (String)CrashAssistantLocalConfig.get((String)"JDK_PATH")) != null && !valueFromConfig.isEmpty()) {
            String jdepsPathFromLocalConfig = CreateDependencies.transformJavaHomeToJdepsPath(valueFromConfig);
            if (CreateDependencies.validateJdepsPath(jdepsPathFromLocalConfig)) {
                return jdepsPathFromLocalConfig;
            }
        } else if (valueFromConfig != null) {
            CrashAssistantApp.LOGGER.warn("JDK_PATH is empty in local config.");
        }
        return null;
    }

    public static HashSet<String> getCurrentCreateClasses(Mod createMod) {
        HashSet<String> currentCreateClasses = new HashSet<String>();
        try {
            try (JarFile jarFile = new JarFile(Paths.get("mods", createMod.getJarName()).toFile());){
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (CreateDependencies.isCreateClass(name)) {
                        currentCreateClasses.add(CreateDependencies.fixClassName(name));
                        continue;
                    }
                    if (!name.startsWith("META-INF/jarjar/") || !name.endsWith(".jar")) continue;
                    InputStream nestedJarStream = jarFile.getInputStream(entry);
                    try (JarInputStream nestedJar = new JarInputStream(nestedJarStream);){
                        JarEntry nestedEntry;
                        while ((nestedEntry = nestedJar.getNextJarEntry()) != null) {
                            String className = nestedEntry.getName();
                            if (!CreateDependencies.isCreateClass(className)) continue;
                            currentCreateClasses.add(CreateDependencies.fixClassName(className));
                        }
                    }
                }
            }
            CrashAssistantApp.LOGGER.info("Found " + currentCreateClasses.size() + " create classes in " + createMod.getJarName());
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Error while analysing create mod deps: ", (Throwable)e);
        }
        return currentCreateClasses;
    }

    public static void showCreateAnalysisDialog(JFrame parent) {
        JDialog dialog = new JDialog(parent, LanguageProvider.get((String)"gui.menu.analysis.create_dependencies") + " (" + LanguageProvider.get((String)"gui.window_name") + ")", true);
        dialog.setLayout(new BorderLayout());
        JLabel headerLabel = new JLabel("<html>Wait for analysis to finish.<br>Try removing/updating/downgrading all <font color='red'>problematic mods</font> detected below to match the current <font color='#0000FF'>Create mod</font> version.<br>&nbsp;</html>");
        headerLabel.setHorizontalAlignment(2);
        JPanel topPanel = new JPanel(new BorderLayout());
        JLabel statusLabel = new JLabel("Analyzing mods...");
        statusLabel.setHorizontalAlignment(2);
        JLabel currentJarLabel = new JLabel("Current mod: None");
        currentJarLabel.setHorizontalAlignment(2);
        JProgressBar progressBar = new JProgressBar(0, 100);
        progressBar.setValue(0);
        topPanel.add((Component)statusLabel, "North");
        topPanel.add((Component)currentJarLabel, "Center");
        topPanel.add((Component)progressBar, "South");
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.add((Component)headerLabel, "North");
        headerPanel.add((Component)topPanel, "South");
        dialog.add((Component)headerPanel, "North");
        JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setCaretPosition(0);
        DefaultCaret caret = (DefaultCaret)textPane.getCaret();
        caret.setUpdatePolicy(1);
        JScrollPane scrollPane = new JScrollPane(textPane);
        dialog.add((Component)scrollPane, "Center");
        dialog.setSize(900, 500);
        dialog.setLocationRelativeTo(parent);
        isCancelled = false;
        runningProcesses.clear();
        executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        dialog.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent e) {
                CrashAssistantApp.LOGGER.info("Window closed, interrupting all create dep analysis processes...");
                isCancelled = true;
                executor.shutdownNow();
                List<Process> list = runningProcesses;
                synchronized (list) {
                    for (Process p : runningProcesses) {
                        p.destroy();
                    }
                    runningProcesses.clear();
                }
            }
        });
        new Thread(() -> {
            List<Mod> createMods = CreateDependencies.getCurrentCreateMods();
            if (createMods.isEmpty()) {
                SwingUtilities.invokeLater(() -> {
                    String message = "No Create mod found.\n";
                    CreateDependencies.appendStyledText(textPane, message, NORMAL_COLOR);
                    CrashAssistantApp.LOGGER.info(message.trim());
                    CreateDependencies.addOkButton(dialog);
                });
                return;
            }
            if (createMods.size() > 1) {
                String message = "Multiple Create mods found: " + createMods.stream().map(Mod::getJarName).collect(Collectors.joining(", ")) + "\nAnalysis cannot proceed with multiple Create mods.\nPlease fix the duplicated mods issue first.\n";
                SwingUtilities.invokeLater(() -> {
                    CreateDependencies.appendStyledText(textPane, message, ERROR_COLOR);
                    CrashAssistantApp.LOGGER.info(message.trim());
                    CreateDependencies.addOkButton(dialog);
                });
                return;
            }
            String jdepsPath = CreateDependencies.getJDepsPath();
            if (jdepsPath == null) {
                SwingUtilities.invokeLater(() -> {
                    CreateDependencies.showJdepsWarn(parent, dialog);
                    dialog.dispose();
                });
                return;
            }
            Mod createMod = createMods.get(0);
            HashSet<String> currentCreateClasses = CreateDependencies.getCurrentCreateClasses(createMod);
            List modsToAnalyze = ModListUtils.getCurrentModList((boolean)true).stream().filter(mod -> !Objects.equals(mod.getModId(), "create")).collect(Collectors.toList());
            int totalMods = modsToAnalyze.size();
            if (totalMods == 0) {
                SwingUtilities.invokeLater(() -> {
                    String message = "No mods to analyze.\n";
                    CreateDependencies.appendStyledText(textPane, message, NORMAL_COLOR);
                    CrashAssistantApp.LOGGER.info(message.trim());
                    CreateDependencies.addOkButton(dialog);
                });
                return;
            }
            ConcurrentHashMap missingClassesMap = new ConcurrentHashMap();
            AtomicInteger completedTasks = new AtomicInteger(0);
            SwingUtilities.invokeLater(() -> progressBar.setMaximum(totalMods));
            for (Mod mod2 : modsToAnalyze) {
                executor.submit(() -> {
                    Set invalidDeps;
                    HashSet<String> deps;
                    block18: {
                        if (isCancelled) {
                            return;
                        }
                        SwingUtilities.invokeLater(() -> currentJarLabel.setText("Current mod: " + mod2.getJarName()));
                        Process process = null;
                        deps = new HashSet<String>();
                        try {
                            ProcessBuilder jdepsProcessBuilder = new ProcessBuilder(jdepsPath, "-verbose:class", Paths.get("mods", mod2.getJarName()).toAbsolutePath().toString());
                            jdepsProcessBuilder.redirectErrorStream(true);
                            process = jdepsProcessBuilder.start();
                            runningProcesses.add(process);
                            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                                String line;
                                while ((line = reader.readLine()) != null) {
                                    String dependency;
                                    if (isCancelled) {
                                        break;
                                    }
                                    int arrowIndex = (line = line.trim()).indexOf("->");
                                    if (arrowIndex == -1 || (dependency = line.substring(arrowIndex + 2).trim()).endsWith(".class")) continue;
                                    int spaceIndex = dependency.indexOf(32);
                                    Object classPath = dependency.substring(0, spaceIndex == -1 ? dependency.length() : spaceIndex).replace('.', '/');
                                    if (!CreateDependencies.isCreateClass((String)(classPath = (String)classPath + ".class"))) continue;
                                    deps.add(CreateDependencies.fixClassName((String)classPath));
                                }
                            }
                            process.waitFor();
                            if (process == null) break block18;
                            runningProcesses.remove(process);
                        }
                        catch (InterruptedException ignored) {
                            CrashAssistantApp.LOGGER.warn("Analysis of " + mod2.getJarName() + " was interrupted.");
                        }
                        catch (Exception e) {
                            CrashAssistantApp.LOGGER.error("Error while analysing create mod deps for " + mod2.getJarName() + ": ", (Throwable)e);
                            break block18;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                        }
                        finally {
                            if (process != null) {
                                runningProcesses.remove(process);
                            }
                        }
                    }
                    if (!(invalidDeps = deps.stream().filter(dep -> !currentCreateClasses.contains(dep)).collect(Collectors.toSet())).isEmpty()) {
                        missingClassesMap.put(mod2, invalidDeps);
                        String jarName = mod2.getJarName();
                        int depCount = invalidDeps.size();
                        String createJarName = createMod.getJarName();
                        SwingUtilities.invokeLater(() -> {
                            if (!isCancelled) {
                                CreateDependencies.appendStyledText(textPane, "Found ", NORMAL_COLOR);
                                CreateDependencies.appendStyledText(textPane, String.valueOf(depCount), ERROR_COLOR);
                                CreateDependencies.appendStyledText(textPane, " Create mod class dependency(ies) in ", NORMAL_COLOR);
                                CreateDependencies.appendStyledText(textPane, jarName, ERROR_COLOR);
                                CreateDependencies.appendStyledText(textPane, ", which are missing from the current ", NORMAL_COLOR);
                                CreateDependencies.appendStyledText(textPane, createJarName, CREATE_MOD_COLOR);
                                CreateDependencies.appendStyledText(textPane, "\n", NORMAL_COLOR);
                                String logMessage = String.format("Found %d Create mod class dependency(ies) in %s, which are missing from the current %s", depCount, jarName, createJarName);
                                CrashAssistantApp.LOGGER.info(logMessage);
                            }
                        });
                    }
                    int completed = completedTasks.incrementAndGet();
                    SwingUtilities.invokeLater(() -> {
                        if (!isCancelled) {
                            progressBar.setValue(completed);
                        }
                    });
                });
            }
            executor.shutdown();
            try {
                executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (!isCancelled) {
                SwingUtilities.invokeLater(() -> {
                    statusLabel.setText("Analysis complete");
                    currentJarLabel.setText("Current mod: None");
                    if (missingClassesMap.isEmpty()) {
                        String createJarName = createMod.getJarName();
                        CreateDependencies.appendStyledText(textPane, "Haven't found in any mod, Create mod class dependency(ies), which are missing from the current ", NORMAL_COLOR);
                        CreateDependencies.appendStyledText(textPane, createJarName, CREATE_MOD_COLOR);
                        CreateDependencies.appendStyledText(textPane, "\n", NORMAL_COLOR);
                        String logMessage = String.format("Haven't found in any mod, Create mod class dependency(ies), which are missing from the current %s", createJarName);
                        CrashAssistantApp.LOGGER.info(logMessage);
                    } else {
                        CreateDependencies.appendStyledText(textPane, "\n\n\nDetailed walkthrough of mods which rely on missing Create mod classes:\n", NORMAL_COLOR);
                        ArrayList sortedMods = new ArrayList(missingClassesMap.keySet());
                        sortedMods.sort(Comparator.comparing(Mod::getJarName));
                        for (Mod mod : sortedMods) {
                            Set missingClasses = (Set)missingClassesMap.get(mod);
                            ArrayList sortedClasses = new ArrayList(missingClasses);
                            Collections.sort(sortedClasses);
                            CreateDependencies.appendStyledText(textPane, "Mod: ", NORMAL_COLOR);
                            CreateDependencies.appendStyledText(textPane, mod.getJarName(), ERROR_COLOR);
                            CreateDependencies.appendStyledText(textPane, "\n", NORMAL_COLOR);
                            CreateDependencies.appendStyledText(textPane, "Missing classes of create:\n", NORMAL_COLOR);
                            CreateDependencies.appendStyledText(textPane, String.join((CharSequence)"\n", sortedClasses) + "\n\n", NORMAL_COLOR);
                            String logMessage = String.format("Mod: %s\nMissing classes of create:\n%s\n\n", mod.getJarName(), String.join((CharSequence)"\n", sortedClasses));
                            CrashAssistantApp.LOGGER.info(logMessage.trim());
                        }
                    }
                    CreateDependencies.addOkButton(dialog);
                });
            }
        }).start();
        dialog.setVisible(true);
    }

    private static void addOkButton(JDialog dialog) {
        JButton okButton = new JButton("OK");
        okButton.addActionListener(e -> dialog.dispose());
        dialog.add((Component)okButton, "South");
        dialog.revalidate();
    }

    private static boolean showJdepsWarn(JFrame parent, JDialog dialog) {
        JdkWarningDialog warnDialog = new JdkWarningDialog(parent, dialog);
        warnDialog.setVisible(true);
        String jdepsPath = CreateDependencies.getJDepsPath();
        return jdepsPath != null;
    }

    static {
        ERROR_COLOR = Color.RED;
        NORMAL_COLOR = Color.BLACK;
        CREATE_MOD_COLOR = Color.BLUE;
    }

    private static class JdkWarningDialog
    extends JDialog {
        public JdkWarningDialog(JFrame parent, JDialog parentDialog) {
            super(parent, "JDK Required", true);
            this.setLayout(new BorderLayout());
            String message = "<strong>JDK is required</strong> for analysis of jar files. <strong>JRE is not suitable</strong> for this!\n\nWe've tried JAVA_HOME, jdeps cmd and java used for launching game.\n\nYou have the following options:\n1. Install JDK via winget (<strong>Oracle JDK 21</strong>)\n2. Select an existing JDK installation directory\n3. Close this dialog and install JDK manually from:\n<a href=\"" + LinksProvider.ADOPTIUM_JDK.getLink() + "\">" + LinksProvider.ADOPTIUM_JDK.getLink() + "</a>\nMake sure to select <strong>JAVA_HOME</strong> check box in the installation settings.\n\n\nAfter any of this done, try to use this analysis again.";
            JEditorPane textPane = CrashAssistantGUI.getEditorPane(message, true, 550);
            JScrollPane scrollPane = new JScrollPane(textPane);
            scrollPane.setHorizontalScrollBarPolicy(31);
            this.add((Component)scrollPane, "Center");
            JPanel buttonPanel = new JPanel(new FlowLayout(1));
            JButton installButton = new JButton("Install JDK via winget");
            installButton.addActionListener(e -> {
                try {
                    int option = JOptionPane.showConfirmDialog(this, "Installing JDK using winget. A console window will open to show progress.\nInstallation will start after clicking OK.\n\nAfter finished, try analysis again.", "Installing JDK", 2, 1);
                    if (option != 0) {
                        return;
                    }
                    ProcessBuilder pb = new ProcessBuilder("cmd.exe", "/c", "start", "cmd.exe", "/k", "winget", "install", "--id=Oracle.JDK.21", "-e");
                    pb.start();
                    this.dispose();
                    if (parentDialog != null) {
                        parentDialog.dispose();
                    }
                }
                catch (Exception ex) {
                    CrashAssistantApp.LOGGER.error("Error installing JDK via winget: ", (Throwable)ex);
                    JOptionPane.showMessageDialog(this, "Error installing JDK: " + ex.getMessage(), "Installation Error", 0);
                }
            });
            buttonPanel.add(installButton);
            JButton selectButton = new JButton("Select JDK");
            selectButton.addActionListener(e -> {
                JOptionPane.showMessageDialog(this, "Please specify path to JDK directory.", "Select JDK", 1);
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileSelectionMode(1);
                fileChooser.setDialogTitle("Select JDK Directory");
                fileChooser.setCurrentDirectory(new File("C:\\"));
                fileChooser.setPreferredSize(new Dimension(600, 400));
                if (fileChooser.showOpenDialog(this) == 0) {
                    File selectedFolder = fileChooser.getSelectedFile();
                    String jdkPath = selectedFolder.getAbsolutePath();
                    CrashAssistantLocalConfig.set((String)"JDK_PATH", (Object)jdkPath);
                    JOptionPane.showMessageDialog(this, "Success! Try analysis again.", "JDK Path Saved", 1);
                    this.dispose();
                    if (parentDialog != null) {
                        parentDialog.dispose();
                    }
                }
            });
            buttonPanel.add(selectButton);
            JButton closeButton = new JButton("Close");
            closeButton.addActionListener(e -> {
                this.dispose();
                if (parentDialog != null) {
                    parentDialog.dispose();
                }
            });
            buttonPanel.add(closeButton);
            this.add((Component)buttonPanel, "South");
            this.setSize(600, 400);
            this.setLocationRelativeTo(parent);
        }
    }
}

