/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.util;

import java.util.Objects;

public class Pair<F, S> {
    protected F first;
    protected S second;

    protected Pair(F first, S second) {
        this.first = first;
        this.second = second;
    }

    public static <F, S> Pair<F, S> of(F first, S second) {
        return new Pair<F, S>(first, second);
    }

    public F getFirst() {
        return this.first;
    }

    public S getSecond() {
        return this.second;
    }

    public void setFirst(F first) {
        this.first = first;
    }

    public void setSecond(S second) {
        this.second = second;
    }

    public Pair<F, S> copy() {
        return Pair.of(this.first, this.second);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Pair) {
            Pair other = (Pair)obj;
            return Objects.equals(this.first, other.first) && Objects.equals(this.second, other.second);
        }
        return false;
    }

    public int hashCode() {
        return this.nullHash(this.first) * 31 ^ this.nullHash(this.second);
    }

    private int nullHash(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ")";
    }

    public Pair<S, F> swap() {
        return Pair.of(this.second, this.first);
    }
}

