/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.util;

import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.util.BinaryMatrix4x4;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class NBTHelper {
    public static boolean equalIgnoring(CompoundTag tag1, CompoundTag tag2, String ... ignoredKeys) {
        if (tag1 == tag2) {
            return true;
        }
        HashSet<String> checkedKeys = new HashSet<String>();
        if (tag1 != null) {
            block0: for (String key : tag1.m_128431_()) {
                checkedKeys.add(key);
                for (String ignoredKey : ignoredKeys) {
                    if (key.equals(ignoredKey)) continue block0;
                }
                if (tag2 != null && Objects.equals(tag1.m_128423_(key), tag2.m_128423_(key))) continue;
                return false;
            }
        }
        if (tag2 != null) {
            block2: for (String key : tag2.m_128431_()) {
                if (checkedKeys.contains(key)) continue;
                for (String ignoredKey : ignoredKeys) {
                    if (key.equals(ignoredKey)) continue block2;
                }
                if (tag1 != null && Objects.equals(tag1.m_128423_(key), tag2.m_128423_(key))) continue;
                return false;
            }
        }
        return true;
    }

    public static <T> List<T> readCompoundList(ListTag tag, Function<CompoundTag, T> reader) {
        return tag.stream().map(CompoundTag.class::cast).map(reader).collect(Collectors.toList());
    }

    public static <T> ListTag writeCompoundList(List<T> list, Function<T, CompoundTag> writer) {
        ListTag tag = new ListTag();
        list.stream().map(writer).forEach(arg_0 -> tag.add(arg_0));
        return tag;
    }

    public static <E extends Enum<E>> E readEnum(CompoundTag tag, String key, Class<E> enumClass) {
        return (E)((Enum[])enumClass.getEnumConstants())[tag.m_128451_(key)];
    }

    public static <E extends Enum<E>> void writeEnum(CompoundTag tag, String key, E enumValue) {
        tag.m_128405_(key, enumValue.ordinal());
    }

    public static Vec3 readVec3(ListTag tag, BlockPos origin) {
        return Vec3.m_82528_((Vec3i)origin).m_82520_(tag.m_128772_(0), tag.m_128772_(1), tag.m_128772_(2));
    }

    public static ListTag writeVec3(Vec3 vec, BlockPos origin) {
        vec = vec.m_82546_(Vec3.m_82528_((Vec3i)origin));
        ListTag tag = new ListTag();
        tag.add((Object)DoubleTag.m_128500_((double)vec.m_7096_()));
        tag.add((Object)DoubleTag.m_128500_((double)vec.m_7098_()));
        tag.add((Object)DoubleTag.m_128500_((double)vec.m_7094_()));
        return tag;
    }

    public static int readBinaryMatrix4x4(CompoundTag tag, String key) {
        if (!tag.m_128425_(key, 2)) {
            return 0;
        }
        return BinaryMatrix4x4.fromShort(tag.m_128448_(key));
    }

    public static void writeBinaryMatrix4x4(CompoundTag tag, String key, int binaryMatrix) {
        tag.m_128376_(key, BinaryMatrix4x4.asShort(binaryMatrix));
    }

    public static <OBJECT> OBJECT readRegistryObject(CompoundTag tag, String key, ResourceKey<Registry<OBJECT>> registryKey, Level level) {
        return NBTHelper.readRegistryObject(tag, key, registryKey, level.m_9598_());
    }

    public static <OBJECT> void writeRegistryObject(CompoundTag tag, String key, ResourceKey<Registry<OBJECT>> registryKey, Level level, OBJECT object) {
        NBTHelper.writeRegistryObject(tag, key, registryKey, level.m_9598_(), object);
    }

    public static <OBJECT> OBJECT readRegistryObject(CompoundTag tag, String key, ResourceKey<Registry<OBJECT>> registryKey, RegistryAccess registryAccess) {
        return (OBJECT)registryAccess.m_175515_(registryKey).m_7745_(new ResourceLocation(tag.m_128461_(key)));
    }

    public static <OBJECT> void writeRegistryObject(CompoundTag tag, String key, ResourceKey<Registry<OBJECT>> registryKey, RegistryAccess registryAccess, OBJECT object) {
        ResourceLocation rl = registryAccess.m_175515_(registryKey).m_7981_(object);
        if (rl != null) {
            tag.m_128359_(key, rl.toString());
        }
    }

    public static <OBJECT> OBJECT readRegistryObject(CompoundTag tag, String key, ResourceKey<Registry<OBJECT>> registryKey) {
        return (OBJECT)PetrolparkRegistries.getRegistry(registryKey).getValue(new ResourceLocation(tag.m_128461_(key)));
    }

    public static <OBJECT> void writeRegistryObject(CompoundTag tag, String key, ResourceKey<Registry<OBJECT>> registryKey, OBJECT object) {
        ResourceLocation rl = PetrolparkRegistries.getRegistry(registryKey).getKey(object);
        if (rl != null) {
            tag.m_128359_(key, rl.toString());
        }
    }

    public static <OBJECT> OBJECT readDataRegistryObject(CompoundTag tag, String key, ResourceKey<Registry<OBJECT>> dataRegistryKey) {
        return (OBJECT)PetrolparkRegistries.getDataRegistry(dataRegistryKey).m_7745_(new ResourceLocation(tag.m_128461_(key)));
    }

    public static <OBJECT> void writeDataRegistryObject(CompoundTag tag, String key, ResourceKey<Registry<OBJECT>> dataRegistryKey, OBJECT dataObject) {
        ResourceLocation rl = PetrolparkRegistries.getDataRegistry(dataRegistryKey).m_7981_(dataObject);
        if (rl != null) {
            tag.m_128359_(key, rl.toString());
        }
    }
}

