/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.team.scoreboard;

import com.petrolpark.network.PetrolparkMessages;
import com.petrolpark.team.data.ITeamDataType;
import com.petrolpark.team.scoreboard.ScoreboardTeam;
import com.petrolpark.team.scoreboard.ScoreboardTeamDataChangedPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class ScoreboardTeamManager {
    protected final Map<PlayerTeam, ScoreboardTeam> teams = new HashMap<PlayerTeam, ScoreboardTeam>();
    protected Scoreboard scoreboard;
    protected ScoreboardTeamSavedData savedData;

    public Optional<ScoreboardTeam> get(String teamName) {
        if (this.scoreboard == null) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::findScoreboardClient);
        }
        if (this.scoreboard == null) {
            return Optional.empty();
        }
        PlayerTeam team = this.scoreboard.m_83489_(teamName);
        if (team == null) {
            return Optional.empty();
        }
        return Optional.of(this.teams.computeIfAbsent(team, ScoreboardTeam::new));
    }

    public void dataChanged(Level level, ScoreboardTeam team, ITeamDataType<?> dataType) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> PetrolparkMessages.sendToAllClients(new ScoreboardTeamDataChangedPacket(level, team, dataType)));
        if (this.savedData != null) {
            this.savedData.m_77762_();
        }
    }

    public void setData(Level level, String teamName, ITeamDataType<?> dataType, CompoundTag dataTag) {
        this.get(teamName).ifPresent(team -> team.loadTeamData(level, dataTag, dataType));
    }

    public void playerLogin(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.loadSavedData(serverPlayer.m_20194_());
            for (ScoreboardTeam team : this.teams.values()) {
                team.streamNonBlankTeamData().forEach(dt -> PetrolparkMessages.sendToClient(new ScoreboardTeamDataChangedPacket(serverPlayer.m_9236_(), team, dt), serverPlayer));
            }
        }
    }

    public void playerLogout(Player player) {
    }

    public void levelLoaded(LevelAccessor level) {
        MinecraftServer server = level.m_7654_();
        if (server == null || server.m_129783_() != level) {
            return;
        }
        this.teams.clear();
        this.scoreboard = null;
        this.savedData = null;
        this.loadSavedData(server);
    }

    private void loadSavedData(MinecraftServer server) {
        if (this.savedData != null) {
            return;
        }
        this.scoreboard = server.m_129896_();
        this.savedData = (ScoreboardTeamSavedData)server.m_129783_().m_8895_().m_164861_(tag -> this.load((Level)server.m_129783_(), (CompoundTag)tag), () -> new ScoreboardTeamSavedData((Level)server.m_129783_()), "petrolpark_teams");
    }

    private void findScoreboardClient() {
        Minecraft mc = Minecraft.m_91087_();
        this.scoreboard = mc.f_91073_.m_6188_();
    }

    protected ScoreboardTeamSavedData load(Level overworld, CompoundTag tag) {
        ScoreboardTeamSavedData savedData = new ScoreboardTeamSavedData(overworld);
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 10)) continue;
            this.get(key).ifPresent(team -> team.loadTeamData(overworld, tag.m_128469_(key)));
        }
        return savedData;
    }

    public class ScoreboardTeamSavedData
    extends SavedData {
        protected final Level overworld;

        public ScoreboardTeamSavedData(Level overworld) {
            this.overworld = overworld;
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            for (ScoreboardTeam team : ScoreboardTeamManager.this.teams.values()) {
                tag.m_128365_(team.team.m_5758_(), (Tag)team.saveTeamData(this.overworld));
            }
            return tag;
        }
    }
}

