/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.recipe.advancedprocessing;

import com.petrolpark.RequiresCreate;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

@RequiresCreate
public interface IBiomeSpecificProcessingRecipe {
    public void setAllowedBiomes(Set<BiomeValue> var1);

    public Set<BiomeValue> getAllowedBiomes();

    default public boolean isValidIn(Holder<Biome> biome) {
        return this.getAllowedBiomes().size() == 0 || this.getAllowedBiomes().stream().anyMatch(v -> v.matches(biome));
    }

    default public boolean isValidAt(Level level, BlockPos pos) {
        return this.isValidIn((Holder<Biome>)level.m_204166_(pos));
    }

    public static BiomeValue valueFromString(String string) {
        if (string.startsWith("#")) {
            return new TagBiomeValue((TagKey<Biome>)TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(string.substring(1))));
        }
        return new SingleBiomeValue(new ResourceLocation(string));
    }

    public static class TagBiomeValue
    implements BiomeValue {
        public final TagKey<Biome> tag;

        public TagBiomeValue(TagKey<Biome> tag) {
            this.tag = tag;
        }

        @Override
        public boolean matches(Holder<Biome> biome) {
            return biome.m_203656_(this.tag);
        }

        @Override
        public Collection<Biome> getBiomes(RegistryAccess registryAccess) {
            return registryAccess.m_175515_(Registries.f_256952_).m_203431_(this.tag).map(named -> named.m_203614_().map(Holder::get).toList()).orElse(Collections.emptyList());
        }

        @Override
        public String serialize() {
            return "#" + this.tag.f_203868_();
        }
    }

    public static class SingleBiomeValue
    implements BiomeValue {
        public final ResourceLocation biomeId;

        public SingleBiomeValue(ResourceLocation biomeId) {
            this.biomeId = biomeId;
        }

        @Override
        public boolean matches(Holder<Biome> biome) {
            return biome.m_203543_().map(key -> key.m_135782_().equals((Object)this.biomeId)).orElse(false);
        }

        @Override
        public Collection<Biome> getBiomes(RegistryAccess registryAccess) {
            return Collections.singleton((Biome)registryAccess.m_175515_(Registries.f_256952_).m_6612_(this.biomeId).orElseThrow(() -> new IllegalStateException("No biome with ID '" + this.biomeId.toString() + "'.")));
        }

        @Override
        public String serialize() {
            return this.biomeId.toString();
        }
    }

    public static interface BiomeValue {
        public boolean matches(Holder<Biome> var1);

        public Collection<Biome> getBiomes(RegistryAccess var1);

        public String serialize();
    }
}

