/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.mixin;

import com.petrolpark.contamination.IContamination;
import com.petrolpark.contamination.IItemStackDuck;
import com.petrolpark.contamination.ItemContamination;
import com.petrolpark.item.decay.IDecayingItem;
import com.petrolpark.util.ItemHelper;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class ItemStackMixin
implements IItemStackDuck {
    @Unique
    private IContamination<?, ?> contamination;

    @Inject(method={"copy"}, at={@At(value="RETURN")}, cancellable=true)
    public void inCopy(CallbackInfoReturnable<ItemStack> cir) {
        cir.setReturnValue((Object)IDecayingItem.checkDecay((ItemStack)cir.getReturnValue()));
    }

    @Inject(method={"isSameItemSameTags"}, at={@At(value="HEAD")}, cancellable=true)
    private static void inIsSameItemSameTags(ItemStack stack, ItemStack otherStack, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)ItemHelper.equalIgnoringTags(stack, otherStack, new String[0]));
    }

    @Override
    public IContamination<?, ?> getContamination() {
        if (this.contamination == null) {
            this.contamination = ItemContamination.create(this.self());
        }
        return this.contamination;
    }

    @Override
    public void onContaminationSaved() {
        this.contamination = null;
    }

    private ItemStack self() {
        return (ItemStack)this;
    }
}

