/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.data.reward.generator;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.petrolpark.data.reward.IReward;
import com.petrolpark.data.reward.RewardGeneratorTypes;
import com.petrolpark.data.reward.generator.IRewardGenerator;
import com.petrolpark.data.reward.generator.RewardGeneratorType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.GsonAdapterFactory;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;

public class DirectRewardGenerator
implements IRewardGenerator {
    public final List<IReward> rewards;

    public DirectRewardGenerator(List<IReward> payments) {
        this.rewards = payments;
    }

    @Override
    public List<IReward> generate(LootContext context) {
        return this.rewards;
    }

    @Override
    public RewardGeneratorType getType() {
        return (RewardGeneratorType)((Object)RewardGeneratorTypes.DIRECT.get());
    }

    public Set<LootContextParam<?>> m_6231_() {
        return this.rewards.stream().flatMap(p -> p.m_6231_().stream()).collect(Collectors.toSet());
    }

    public JsonArray asJsonArray(JsonSerializationContext serializationContext) {
        JsonArray jsonArray = new JsonArray();
        for (IReward reward : this.rewards) {
            jsonArray.add(serializationContext.serialize((Object)reward));
        }
        return jsonArray;
    }

    public static DirectRewardGenerator fromJsonArray(JsonArray array, JsonDeserializationContext deserializationContext) {
        ArrayList<IReward> rewards = new ArrayList<IReward>(array.size());
        for (JsonElement element : array) {
            IReward reward = (IReward)GsonHelper.m_13808_((JsonElement)element, (String)"reward", (JsonDeserializationContext)deserializationContext, IReward.class);
            rewards.add(reward);
        }
        return new DirectRewardGenerator(rewards);
    }

    public static class InlineSerializer
    implements GsonAdapterFactory.InlineSerializer<DirectRewardGenerator> {
        public JsonElement serialize(DirectRewardGenerator value, JsonSerializationContext context) {
            return value.asJsonArray(context);
        }

        public DirectRewardGenerator deserialize(JsonElement json, JsonDeserializationContext deserializationContext) {
            try {
                return new DirectRewardGenerator(List.of((IReward)GsonHelper.m_13808_((JsonElement)json, (String)"reward", (JsonDeserializationContext)deserializationContext, IReward.class)));
            }
            catch (JsonSyntaxException e) {
                return DirectRewardGenerator.fromJsonArray(GsonHelper.m_13924_((JsonElement)json, (String)"rewards"), deserializationContext);
            }
        }
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<DirectRewardGenerator> {
        public void serialize(JsonObject json, DirectRewardGenerator value, JsonSerializationContext serializationContext) {
            json.add("rewards", (JsonElement)value.asJsonArray(serializationContext));
        }

        public DirectRewardGenerator deserialize(JsonObject json, JsonDeserializationContext deserializationContext) {
            return DirectRewardGenerator.fromJsonArray(GsonHelper.m_13933_((JsonObject)json, (String)"rewards"), deserializationContext);
        }
    }
}

