/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.contamination;

import com.petrolpark.contamination.Contaminant;
import com.petrolpark.contamination.IContamination;
import com.petrolpark.contamination.IntrinsicContaminants;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Stream;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public abstract class Contamination<OBJECT, OBJECT_STACK>
implements IContamination<OBJECT, OBJECT_STACK> {
    protected final OBJECT_STACK stack;
    protected final SortedSet<Contaminant> orphanContaminants = new TreeSet<Contaminant>(Contaminant::compareTo);
    protected final Set<Contaminant> contaminants = new HashSet<Contaminant>();

    protected Contamination(OBJECT_STACK stack) {
        this.stack = stack;
    }

    @Override
    public final boolean has(Contaminant contaminant) {
        return IntrinsicContaminants.get(this).contains(contaminant) || this.contaminants.contains(contaminant);
    }

    @Override
    public final boolean hasAnyContaminant() {
        return !IntrinsicContaminants.get(this).isEmpty() || this.hasAnyExtrinsicContaminant();
    }

    @Override
    public final boolean hasAnyExtrinsicContaminant() {
        return !this.contaminants.isEmpty();
    }

    @Override
    public final Stream<Contaminant> streamAllContaminants() {
        return Stream.concat(IntrinsicContaminants.get(this).stream(), this.contaminants.stream());
    }

    @Override
    public final Stream<Contaminant> streamOrphanExtrinsicContaminants() {
        return this.orphanContaminants.stream();
    }

    @Override
    public final boolean contaminate(Contaminant contaminant) {
        if (IntrinsicContaminants.get(this).contains(contaminant)) {
            return false;
        }
        if (!this.contaminants.add(contaminant)) {
            return false;
        }
        this.orphanContaminants.removeAll(contaminant.getChildren());
        this.orphanContaminants.add(contaminant);
        this.contaminants.addAll(contaminant.getChildren());
        this.save();
        return true;
    }

    @Override
    public final boolean contaminateAll(Stream<Contaminant> contaminantsStream) {
        boolean changed;
        boolean bl = changed = !contaminantsStream.dropWhile(IntrinsicContaminants.get(this)::contains).filter(this.contaminants::add).map(contaminant -> {
            this.orphanContaminants.removeAll(contaminant.getChildren());
            this.orphanContaminants.add((Contaminant)contaminant);
            this.contaminants.addAll(contaminant.getChildren());
            return contaminant;
        }).toList().isEmpty();
        if (changed) {
            this.save();
        }
        return changed;
    }

    @Override
    public final boolean decontaminate(Contaminant contaminant) {
        if (IntrinsicContaminants.get(this).contains(contaminant)) {
            return false;
        }
        if (!this.orphanContaminants.remove(contaminant)) {
            return false;
        }
        this.contaminants.remove(contaminant);
        for (Contaminant child : contaminant.getChildren()) {
            if (!Collections.disjoint(this.contaminants, child.getParents())) continue;
            this.contaminants.remove(child);
        }
        this.save();
        return true;
    }

    @Override
    public final boolean decontaminateOnly(Contaminant contaminant) {
        if (IntrinsicContaminants.get(this).contains(contaminant)) {
            return false;
        }
        if (!this.orphanContaminants.remove(contaminant)) {
            return false;
        }
        this.contaminants.remove(contaminant);
        for (Contaminant child : contaminant.getChildren()) {
            if (!Collections.disjoint(this.contaminants, child.getParents())) continue;
            this.orphanContaminants.add(child);
        }
        this.save();
        return true;
    }

    @Override
    public final boolean fullyDecontaminate() {
        if (this.orphanContaminants.isEmpty()) {
            return false;
        }
        this.orphanContaminants.clear();
        this.contaminants.clear();
        this.save();
        return true;
    }

    public void readNBT(ListTag contaminationTag) {
        this.contaminateAll(contaminationTag.stream().map(Tag::m_7916_).map(ResourceLocation::new).map(Contaminant::get));
    }

    public ListTag writeNBT() {
        ListTag tag = new ListTag();
        this.orphanContaminants.forEach(c -> tag.add((Object)StringTag.m_129297_((String)c.getLocation().toString())));
        return tag;
    }
}

