/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.jei.ingredient;

import com.petrolpark.client.rendering.PetrolparkGuiTexture;
import com.petrolpark.compat.jei.JEITextureDrawable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.Nullable;

public class BiomeIngredientType
implements IIngredientType<Biome> {
    public static final BiomeIngredientType TYPE = new BiomeIngredientType();
    public static final Helper HELPER = new Helper();
    public static final Renderer RENDERER = new Renderer();

    public Class<? extends Biome> getIngredientClass() {
        return Biome.class;
    }

    public static class Helper
    implements IIngredientHelper<Biome> {
        private final Minecraft mc = Minecraft.m_91087_();
        private final RegistryAccess registryAccess;

        public Helper() {
            this.registryAccess = this.mc.f_91073_.m_9598_();
        }

        public IIngredientType<Biome> getIngredientType() {
            return TYPE;
        }

        public String getDisplayName(Biome ingredient) {
            return this.getDisplayNameComponent(ingredient).getString();
        }

        public Component getDisplayNameComponent(Biome ingredient) {
            ResourceLocation rl = this.getResourceLocation(ingredient);
            if (rl == null) {
                return Component.m_237115_((String)"biome.petrolpark.unknown");
            }
            return Component.m_237115_((String)this.getResourceLocation(ingredient).m_214296_("biome"));
        }

        public String getUniqueId(Biome ingredient, UidContext context) {
            ResourceLocation rl = this.getResourceLocation(ingredient);
            if (rl == null) {
                return "Unknown Biome";
            }
            return rl.toString();
        }

        public ResourceLocation getResourceLocation(Biome ingredient) {
            return this.registryAccess.m_175515_(Registries.f_256952_).m_7981_((Object)ingredient);
        }

        public Biome copyIngredient(Biome ingredient) {
            return ingredient;
        }

        public String getErrorInfo(@Nullable Biome ingredient) {
            return "";
        }
    }

    public static class Renderer
    implements IIngredientRenderer<Biome> {
        private final JEITextureDrawable globe = JEITextureDrawable.of(PetrolparkGuiTexture.JEI_GLOBE);

        public void render(GuiGraphics guiGraphics, Biome ingredient) {
            this.globe.draw(guiGraphics, 0, 1);
        }

        public List<Component> getTooltip(Biome ingredient, TooltipFlag tooltipFlag) {
            ResourceLocation rl = HELPER.getResourceLocation(ingredient);
            if (rl == null) {
                return Collections.emptyList();
            }
            ArrayList<Component> tooltip = new ArrayList<Component>(tooltipFlag.m_7050_() ? 2 : 1);
            tooltip.add(HELPER.getDisplayNameComponent(ingredient));
            if (tooltipFlag.m_7050_()) {
                tooltip.add((Component)Component.m_237113_((String)rl.toString()).m_130940_(ChatFormatting.DARK_GRAY));
            }
            return tooltip;
        }
    }
}

