/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.core.tube;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.petrolpark.RequiresCreate;
import com.petrolpark.client.key.PetrolparkKeys;
import com.petrolpark.compat.create.CreateClient;
import com.petrolpark.compat.create.core.tube.BuildTubePacket;
import com.petrolpark.compat.create.core.tube.ITubeBlock;
import com.petrolpark.compat.create.core.tube.TubeSpline;
import com.petrolpark.network.PetrolparkMessages;
import com.petrolpark.util.BlockFace;
import com.petrolpark.util.RayHelper;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.foundation.gui.RemovedGuiUtils;
import com.simibubi.create.foundation.mixin.accessor.MouseHandlerAccessor;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CClient;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.theme.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
@RequiresCreate
public class ClientTubePlacementHandler {
    protected static ItemStack currentStack = ItemStack.f_41583_;
    protected static ITubeBlock tubeBlock = null;
    protected static BlockFace start = null;
    protected static BlockFace end = null;
    protected static TubeSpline spline = null;
    protected static int ttl = 0;
    protected static int targetedControlPoint = -1;
    protected static double distanceToSelectedControlPoint = 0.0;
    protected static boolean draggingSelectedControlPoint = false;
    protected static List<AABB> controlPointBoxes = new ArrayList<AABB>();
    protected static boolean canAfford = true;
    public static final IGuiOverlay OVERLAY = ClientTubePlacementHandler::renderOverlay;

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent event) {
        Vec3 point;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null || !ItemStack.m_150942_((ItemStack)mc.f_91074_.m_21205_(), (ItemStack)currentStack) && !AllItems.WRENCH.isIn(mc.f_91074_.m_21205_()) || currentStack.m_41619_() || start != null && mc.f_91073_.m_8055_(start.getPos()).m_60734_() != tubeBlock) {
            ClientTubePlacementHandler.cancel();
            return;
        }
        if (ttl > 0) {
            --ttl;
        } else {
            ClientTubePlacementHandler.cancel();
        }
        if (!ClientTubePlacementHandler.active()) {
            return;
        }
        if (mc.f_91073_.m_8055_(end.getPos()).m_60734_() != tubeBlock) {
            ClientTubePlacementHandler.cancel();
            return;
        }
        boolean buildable = ClientTubePlacementHandler.spline.getResult().success;
        int color = buildable ? -11671936 : -1684096;
        for (int i = 0; i < spline.getPoints().size() - 1; ++i) {
            point = spline.getPoints().get(i);
            Vec3 tangent = spline.getTangents().get(i);
            CreateClient.OUTLINER.showLine(Pair.of((Object)point, (Object)tangent), point, spline.getPoints().get(i + 1)).colored(color);
        }
        spline.checkBlocked((Level)mc.f_91073_, pos -> CreateClient.OUTLINER.chaseAABB(Pair.of((Object)"blocking_tube", (Object)pos), new AABB(pos)).colored(-1684096));
        canAfford = spline.checkCanAfford((Player)mc.f_91074_, currentStack.m_41720_(), tubeBlock);
        if (controlPointBoxes.isEmpty()) {
            controlPointBoxes = spline.getControlPoints().stream().map(v -> new AABB(v.m_82492_(0.09375, 0.09375, 0.09375), v.m_82520_(0.09375, 0.09375, 0.09375))).toList();
        }
        if (!draggingSelectedControlPoint && !controlPointBoxes.isEmpty()) {
            point = RayHelper.getHitResult(controlPointBoxes, (Entity)mc.f_91074_, AnimationTickHolder.getPartialTicks(), false);
            if (point instanceof RayHelper.CustomHitResult) {
                RayHelper.CustomHitResult hr = (RayHelper.CustomHitResult)point;
                targetedControlPoint = hr.index;
            } else {
                targetedControlPoint = -1;
            }
        } else if (targetedControlPoint != -1) {
            ClientTubePlacementHandler.relocateControlPoint();
        }
        for (int i = 0; i < controlPointBoxes.size(); ++i) {
            AABB controlPointBox = controlPointBoxes.get(i);
            CreateClient.OUTLINER.showBox(Pair.of((Object)"control_point", (Object)i), controlPointBox.m_82400_(i == targetedControlPoint ? 0.0625 : 0.0), 2).colored(color);
        }
        mc.f_91074_.m_5661_(ClientTubePlacementHandler.spline.result.translate(currentStack), true);
    }

    /*
     * WARNING - void declaration
     */
    public static void renderOverlay(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        void var11_15;
        if (spline == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ItemStack itemIcon = currentStack.m_255036_(1);
        String requiredItemCount = "" + tubeBlock.getItemsForTubeLength(spline.getLength());
        ArrayList<Object> tooltip = new ArrayList<Object>();
        tooltip.add(Component.m_237110_((String)"petrolpark.tube.title", (Object[])new Object[]{requiredItemCount, currentStack.m_41786_()}));
        Controls[] controlsArray = Controls.values();
        int n = controlsArray.length;
        boolean bl = false;
        while (var11_15 < n) {
            Controls control = controlsArray[var11_15];
            if (control.useCondition.get().booleanValue()) {
                tooltip.add(control.translate());
            }
            ++var11_15;
        }
        int tooltipTextWidth = 0;
        for (Component component : tooltip) {
            tooltipTextWidth = Math.max(tooltipTextWidth, mc.f_91062_.m_92852_((FormattedText)component));
        }
        int tooltipHeight = tooltip.size() * 10;
        CClient cClient = AllConfigs.client();
        int posX = width / 2 + (Integer)cClient.overlayOffsetX.get();
        int posY = height / 2 + (Integer)cClient.overlayOffsetY.get();
        posX = Math.min(posX, width - tooltipTextWidth - 20);
        posY = Math.min(posY, height - tooltipHeight - 20);
        boolean useCustom = (Boolean)cClient.overlayCustomColor.get();
        Color colorBackground = useCustom ? new Color(((Integer)cClient.overlayBackgroundColor.get()).intValue()) : new Color(1007685648);
        Color colorBorderTop = useCustom ? new Color(((Integer)cClient.overlayBorderColorTop.get()).intValue()) : new Color(-3565748);
        Color colorBorderBot = useCustom ? new Color(((Integer)cClient.overlayBorderColorBot.get()).intValue()) : new Color(-926343);
        PoseStack ms = graphics.m_280168_();
        ms.m_85836_();
        GuiGameElement.of((ItemStack)itemIcon).at((float)(posX + 10), (float)(posY - 16), 450.0f).render(graphics);
        if (!Mods.MODERNUI.isLoaded()) {
            RemovedGuiUtils.drawHoveringText((GuiGraphics)graphics, tooltip, (int)posX, (int)posY, (int)width, (int)height, (int)-1, (int)colorBackground.getRGB(), (int)colorBorderTop.getRGB(), (int)colorBorderBot.getRGB(), (Font)mc.f_91062_);
            ms.m_252880_(0.0f, 0.0f, 100.0f);
        } else {
            MouseHandler mouseHandler = mc.f_91067_;
            Window window = mc.m_91268_();
            double guiScale = window.m_85449_();
            double cursorX = mouseHandler.m_91589_();
            double cursorY = mouseHandler.m_91594_();
            ((MouseHandlerAccessor)mouseHandler).create$setXPos((double)Math.round(cursorX / guiScale) * guiScale);
            ((MouseHandlerAccessor)mouseHandler).create$setYPos((double)Math.round(cursorY / guiScale) * guiScale);
            RemovedGuiUtils.drawHoveringText((GuiGraphics)graphics, tooltip, (int)posX, (int)posY, (int)width, (int)height, (int)-1, (int)colorBackground.getRGB(), (int)colorBorderTop.getRGB(), (int)colorBorderBot.getRGB(), (Font)mc.f_91062_);
            ((MouseHandlerAccessor)mouseHandler).create$setXPos(cursorX);
            ((MouseHandlerAccessor)mouseHandler).create$setYPos(cursorY);
        }
        ms.m_85849_();
    }

    @SubscribeEvent
    public static void onUseMouse(InputEvent.MouseButton event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && spline != null && targetedControlPoint > 0 && targetedControlPoint < spline.getControlPoints().size() - 1 && event.getButton() == 1 && draggingSelectedControlPoint == (event.getAction() == 0)) {
            draggingSelectedControlPoint = !draggingSelectedControlPoint;
            distanceToSelectedControlPoint = mc.f_91074_.m_146892_().m_82554_(spline.getControlPoints().get(targetedControlPoint));
            event.setCanceled(true);
            ClientTubePlacementHandler.resetTTL();
        }
    }

    @SubscribeEvent
    public static void onScrollMouse(InputEvent.MouseScrollingEvent event) {
        if (draggingSelectedControlPoint) {
            distanceToSelectedControlPoint = Mth.m_14008_((double)(distanceToSelectedControlPoint + event.getScrollDelta() / 8.0), (double)Math.min(distanceToSelectedControlPoint, 0.5), (double)Math.max(distanceToSelectedControlPoint, 6.0));
            ClientTubePlacementHandler.relocateControlPoint();
            event.setCanceled(true);
            ClientTubePlacementHandler.resetTTL();
        }
    }

    @SubscribeEvent
    public static void onUseKey(InputEvent.Key event) {
        if (spline == null) {
            return;
        }
        if (event.getAction() == 0) {
            Minecraft mc = Minecraft.m_91087_();
            for (Controls control : Controls.values()) {
                if (!control.useCondition.get().booleanValue() || control.key == null || event.getKey() != control.key.keybind.getKey().m_84873_()) continue;
                control.key.keybind.m_90859_();
                control.action.run();
                if (spline != null) {
                    controlPointBoxes = new ArrayList<AABB>();
                    ClientTubePlacementHandler.revalidateSpline(mc);
                }
                ClientTubePlacementHandler.resetTTL();
                return;
            }
        }
    }

    protected static void relocateControlPoint() {
        Minecraft mc = Minecraft.m_91087_();
        if (spline.moveControlPoint(targetedControlPoint, mc.f_91074_.m_146892_().m_82549_(mc.f_91074_.m_20252_(AnimationTickHolder.getPartialTicks()).m_82490_(distanceToSelectedControlPoint)))) {
            controlPointBoxes = new ArrayList<AABB>();
            mc.f_91073_.m_5594_((Player)mc.f_91074_, mc.f_91074_.m_20097_(), SoundEvents.f_12013_, SoundSource.BLOCKS, 0.25f, 0.1f);
            ClientTubePlacementHandler.revalidateSpline(mc);
        }
    }

    public static void tryConnect(BlockFace location, ItemStack stack, ITubeBlock tubeBlock, boolean manualPlacement) {
        Minecraft mc = Minecraft.m_91087_();
        if (start == null) {
            currentStack = stack;
            ClientTubePlacementHandler.tubeBlock = tubeBlock;
            start = location;
            spline = null;
            if (manualPlacement) {
                mc.f_91074_.m_5661_((Component)Component.m_237110_((String)"petrolpark.tube.connect_another", (Object[])new Object[]{stack.m_41786_()}), true);
            }
            ClientTubePlacementHandler.resetTTL();
        } else if (spline == null) {
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)currentStack)) {
                ClientTubePlacementHandler.cancel();
                return;
            }
            end = location;
            spline = new TubeSpline(start, end, tubeBlock.getTubeMaxAngle(), tubeBlock.getTubeSegmentLength(), tubeBlock.getTubeSegmentRadius());
            if (manualPlacement) {
                spline.addControlPoint(start.getCenter().m_82549_(end.getCenter()).m_82490_(0.5));
            }
            ClientTubePlacementHandler.revalidateSpline(mc);
            ClientTubePlacementHandler.resetTTL();
        } else {
            ClientTubePlacementHandler.cancel();
            ClientTubePlacementHandler.tryConnect(location, stack, tubeBlock, manualPlacement);
        }
    }

    public static void revalidateSpline(Minecraft mc) {
        spline.validate((Level)mc.f_91073_, (Player)mc.f_91074_, currentStack.m_41720_(), tubeBlock);
    }

    public static void addControlPointWithoutRevalidating(Vec3 controlPoint) {
        if (spline != null) {
            spline.addControlPoint(controlPoint);
        }
    }

    public static void resetTTL() {
        ttl = 2400;
    }

    public static boolean active() {
        return spline != null;
    }

    public static void cancel() {
        currentStack = ItemStack.f_41583_;
        tubeBlock = null;
        start = null;
        end = null;
        spline = null;
        ttl = 0;
        targetedControlPoint = -1;
        distanceToSelectedControlPoint = 0.0;
        draggingSelectedControlPoint = false;
        controlPointBoxes = new ArrayList<AABB>();
        canAfford = true;
    }

    protected static enum Controls {
        BUILD(() -> ClientTubePlacementHandler.spline.getResult().success, () -> {
            PetrolparkMessages.sendToServer(new BuildTubePacket(tubeBlock, spline));
            ClientTubePlacementHandler.cancel();
        }, PetrolparkKeys.TUBE_BUILD),
        GRAB_CONTROL_POINT(() -> targetedControlPoint > 0 && targetedControlPoint < spline.getControlPoints().size() - 1, () -> {}, null),
        MOVE_CONTROL_POINT(() -> draggingSelectedControlPoint, () -> {}, null),
        DELETE_CONTROL_POINT(() -> targetedControlPoint > 0 && targetedControlPoint < spline.getControlPoints().size() - 1 && !draggingSelectedControlPoint, () -> spline.removeControlPoint(targetedControlPoint), PetrolparkKeys.TUBE_DELETE_CONTROL_POINT),
        ADD_CONTROL_POINT_AFTER(() -> spline.getControlPoints().size() < 16 && targetedControlPoint >= 0 && targetedControlPoint < spline.getControlPoints().size() - 1 && !draggingSelectedControlPoint, () -> spline.addInterpolatedControlPoint(targetedControlPoint + 1), PetrolparkKeys.TUBE_ADD_CONTROL_POINT_AFTER),
        ADD_CONTROL_POINT_BEFORE(() -> spline.getControlPoints().size() < 16 && targetedControlPoint > 0 && targetedControlPoint < spline.getControlPoints().size(), () -> spline.addInterpolatedControlPoint(targetedControlPoint), PetrolparkKeys.TUBE_ADD_CONTROL_POINT_BEFORE),
        CANCEL(() -> true, ClientTubePlacementHandler::cancel, PetrolparkKeys.TUBE_CANCEL);

        public final Supplier<Boolean> useCondition;
        public final Runnable action;
        public final PetrolparkKeys key;

        private Controls(Supplier<Boolean> useCondition, Runnable action, PetrolparkKeys key) {
            this.useCondition = useCondition;
            this.action = action;
            this.key = key;
        }

        public Component translate() {
            return Component.m_237110_((String)("petrolpark.tube.control." + Lang.asId((String)this.name())), (Object[])new Object[]{this.key == null ? null : this.key.keybind.getKey().m_84875_()}).m_130940_(ChatFormatting.GRAY);
        }
    }
}

