/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.config.GlobalConfigs;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.OrderData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.ApiData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.PlanService;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.BHOrderScreen;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.ProcessStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.SelectPlanTypeStep;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraftforge.client.gui.widget.ForgeSlider;

public class SelectPackageStep
extends ProcessStep {
    private ForgeSlider slider;
    private final PlanService planService;
    private int packageIndex;
    private final Component perfectPlan = Component.m_237115_((String)"step.select_package.plan");
    private final Component moveSlider = Component.m_237115_((String)"step.select_package.slider");

    public SelectPackageStep(OrderData orderData) {
        super(orderData);
        this.planService = orderData.isPremium ? (PlanService)ApiData.PLANS.getLeft() : (PlanService)ApiData.PLANS.getRight();
        this.packageIndex = this.getPackagePlanIndexFromRecommendations();
    }

    @Override
    public void init(BHOrderScreen screen, Consumer<GuiEventListener> children) {
        super.init(screen, children);
        int y = Mth.m_14045_((int)(screen.f_96544_ / 2 - 10), (int)120, (int)(screen.f_96544_ - 50));
        this.slider = new ForgeSlider(screen.f_96543_ / 2 - 100, y, 200, 20, (Component)Component.m_237113_((String)""), (Component)Component.m_237113_((String)""), 0.0, this.planService.plans.size() - 1, this.packageIndex, false){

            protected void m_5697_() {
                SelectPackageStep.this.packageIndex = this.getValueInt();
            }
        };
        Button button = Button.m_253074_((Component)Component.m_237115_((String)"step.select_package.order_plan"), b -> {
            this.orderData.packageId = this.getCurrentPlan().id;
            this.openOrderUrl();
            screen.getMinecraft().m_91152_(screen.parent);
        }).m_252794_(screen.f_96543_ / 2 - 50, y + 30).m_252780_(100).m_253136_();
        children.accept((GuiEventListener)this.slider);
        children.accept((GuiEventListener)button);
    }

    @Override
    public void render(BHOrderScreen screen, Font font, GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        PlanService.PackagePlan currentPlan = this.getCurrentPlan();
        graphics.m_280430_(font, this.perfectPlan, (screen.f_96543_ - font.m_92852_((FormattedText)this.perfectPlan)) / 2, this.slider.m_252907_() - 77, 0xFFFFFF);
        String plan = currentPlan.name;
        graphics.m_280488_(font, plan, (screen.f_96543_ - font.m_92895_(plan)) / 2, this.slider.m_252907_() - 50, 0xFFFFFF);
        MutableComponent price = Component.m_237110_((String)"step.select_package.price", (Object[])new Object[]{Float.valueOf(currentPlan.price)});
        graphics.m_280430_(font, (Component)price, (screen.f_96543_ - font.m_92852_((FormattedText)price)) / 2, this.slider.m_252907_() - 40, 0xFFFFFF);
        graphics.m_280430_(font, this.moveSlider, (screen.f_96543_ - font.m_92852_((FormattedText)this.moveSlider)) / 2, this.slider.m_252907_() - 15, 0xFFFFFF);
    }

    private void openOrderUrl() {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append("https://bisecthosting.com/modredirect.php?pid=");
        urlBuilder.append(this.orderData.packageId);
        urlBuilder.append("&configoption[");
        urlBuilder.append(this.orderData.isPremium ? 29 : 32);
        urlBuilder.append("]=");
        urlBuilder.append(this.orderData.getJarId());
        urlBuilder.append("&source=mod");
        String partnerId = (String)GlobalConfigs.partnerId.get();
        if (!partnerId.isEmpty()) {
            urlBuilder.append("&aid=");
            urlBuilder.append(partnerId);
        }
        ModRef.LOGGER.info("Setting up order link " + urlBuilder);
        Util.m_137581_().m_137646_(urlBuilder.toString());
    }

    private PlanService.PackagePlan getCurrentPlan() {
        return this.planService.plans.get(this.packageIndex);
    }

    private int getPackagePlanIndexFromRecommendations() {
        int recommendedRam = ApiData.RAM_RECOMMENDATIONS.get(this.orderData.getJarId()).getRamForPlayers(this.orderData.playerCount);
        int planIndex = 0;
        boolean planFound = false;
        for (PlanService.PackagePlan plan : this.planService.plans) {
            if (plan.ram / 1024 >= recommendedRam) {
                planFound = true;
                break;
            }
            ++planIndex;
        }
        if (!planFound) {
            planIndex = 0;
        }
        return planIndex;
    }

    @Override
    public void onClose(BHOrderScreen screen) {
        screen.setStep(new SelectPlanTypeStep(this.orderData));
    }
}

