/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.apothecary.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.gobies.apothecary.config.CommonConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.registries.ForgeRegistries;

public class BlacklistedEffects {
    private static Set<ResourceLocation> CLEANSED_BLACKLISTED_EFFECTS = null;
    private static Set<ResourceLocation> CORRUPTED_BLACKLISTED_EFFECTS = null;

    public static void initCleansedBlacklist() {
        if (CLEANSED_BLACKLISTED_EFFECTS == null) {
            CLEANSED_BLACKLISTED_EFFECTS = new HashSet<ResourceLocation>();
            for (String effects : (List)CommonConfig.CLEANSED_BLACKLIST_EFFECTS.get()) {
                CLEANSED_BLACKLISTED_EFFECTS.add(new ResourceLocation(effects));
            }
        }
    }

    public static boolean isHarmfulEffectBlacklisted(MobEffect effect) {
        ResourceLocation effectRegistryName;
        if (CLEANSED_BLACKLISTED_EFFECTS == null) {
            BlacklistedEffects.initCleansedBlacklist();
        }
        return (effectRegistryName = ForgeRegistries.MOB_EFFECTS.getKey((Object)effect)) == null || !CLEANSED_BLACKLISTED_EFFECTS.contains(effectRegistryName);
    }

    public static boolean isHarmfulEffectApplicable(LivingEntity ignoredEntity, MobEffectInstance effectInstance) {
        MobEffect effect = effectInstance.m_19544_();
        return effect.m_19483_() == MobEffectCategory.HARMFUL && BlacklistedEffects.isHarmfulEffectBlacklisted(effect);
    }

    public static void initCorruptedBlacklist() {
        if (CORRUPTED_BLACKLISTED_EFFECTS == null) {
            CORRUPTED_BLACKLISTED_EFFECTS = new HashSet<ResourceLocation>();
            for (String effects : (List)CommonConfig.CORRUPTED_BLACKLIST_EFFECTS.get()) {
                CORRUPTED_BLACKLISTED_EFFECTS.add(new ResourceLocation(effects));
            }
        }
    }

    public static boolean isBeneficialEffectBlacklisted(MobEffect effect) {
        ResourceLocation effectRegistryName;
        if (CORRUPTED_BLACKLISTED_EFFECTS == null) {
            BlacklistedEffects.initCorruptedBlacklist();
        }
        return (effectRegistryName = ForgeRegistries.MOB_EFFECTS.getKey((Object)effect)) == null || !CORRUPTED_BLACKLISTED_EFFECTS.contains(effectRegistryName);
    }

    public static boolean isBeneficialEffectApplicable(LivingEntity ignoredEntity, MobEffectInstance effectInstance) {
        MobEffect effect = effectInstance.m_19544_();
        return effect.m_19483_() == MobEffectCategory.BENEFICIAL && BlacklistedEffects.isBeneficialEffectBlacklisted(effect);
    }
}

