/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.apothecary.mixin;

import java.util.Objects;
import net.gobies.apothecary.config.CommonConfig;
import net.gobies.apothecary.util.AUtils;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Witch.class})
public abstract class WitchMixin {
    @Unique
    private int apothecary$potionsThrown = 0;
    @Unique
    private long apothecary$lastCooldownTime = 0L;

    @Inject(method={"performRangedAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void apothecaryPotions(LivingEntity pTarget, float pDistanceFactor, CallbackInfo ci) {
        if (((Boolean)CommonConfig.ENABLE_WORLD_EVENTS.get()).booleanValue()) {
            Witch witch = (Witch)this;
            long currentTime = witch.m_9236_().m_46467_();
            if (!witch.m_34161_() && pTarget instanceof Player) {
                Player player = (Player)pTarget;
                if (currentTime - this.apothecary$lastCooldownTime < 20L * (long)((Integer)CommonConfig.WITCH_POTION_COOLDOWN.get()).intValue()) {
                    ci.cancel();
                    return;
                }
                if (this.apothecary$potionsThrown < (Integer)CommonConfig.WITCH_POTION_COUNT.get()) {
                    RandomSource random = witch.m_217043_();
                    Potion selectedPotion = AUtils.determinePotionByRarity(random);
                    if (selectedPotion != null && !player.m_21023_(((MobEffectInstance)selectedPotion.m_43488_().get(0)).m_19544_())) {
                        ThrownPotion thrownPotion = new ThrownPotion(witch.m_9236_(), (LivingEntity)witch);
                        double d0 = player.m_20185_() + player.m_20184_().f_82479_ - witch.m_20185_();
                        double d1 = player.m_20188_() - (double)1.1f - witch.m_20186_();
                        double d2 = player.m_20189_() + player.m_20184_().f_82481_ - witch.m_20189_();
                        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                        thrownPotion.m_37446_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)Objects.requireNonNull(selectedPotion)));
                        thrownPotion.m_146926_(thrownPotion.m_146909_() + 20.0f);
                        thrownPotion.m_6686_(d0, d1 + d3 * 0.2, d2, 0.75f, 8.0f);
                        if (!witch.m_20067_()) {
                            witch.m_9236_().m_6263_(null, witch.m_20185_(), witch.m_20186_(), witch.m_20189_(), SoundEvents.f_12553_, witch.m_5720_(), 1.0f, 0.8f + witch.m_217043_().m_188501_() * 0.4f);
                        }
                        witch.m_9236_().m_7967_((Entity)thrownPotion);
                        witch.m_6710_(null);
                        ++this.apothecary$potionsThrown;
                        if (this.apothecary$potionsThrown >= (Integer)CommonConfig.WITCH_POTION_COUNT.get()) {
                            this.apothecary$lastCooldownTime = currentTime;
                            this.apothecary$potionsThrown = 0;
                        }
                        ci.cancel();
                    }
                } else {
                    this.apothecary$lastCooldownTime = currentTime;
                    this.apothecary$potionsThrown = 0;
                }
            }
        }
    }
}

