/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.apothecary.effect;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import net.gobies.apothecary.compat.OreCompat;
import net.gobies.apothecary.config.CommonConfig;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Vector3f;

public class Spelunker
extends MobEffect {
    public Spelunker(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        Level level = livingEntity.m_9236_();
        BlockPos entityPos = livingEntity.m_20183_();
        if (level.m_5776_() && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ClientLevel clientWorld = (ClientLevel)level;
            this.detectAndSpawnOreParticles(player, clientWorld, entityPos, amplifier);
        }
    }

    public boolean m_6584_(int pDuration, int pAmplifier) {
        return pDuration % 10 == 0;
    }

    private void detectAndSpawnOreParticles(Player player, ClientLevel clientLevel, BlockPos entityPos, int amplifier) {
        int radius = 7 * (amplifier + 1);
        int maxOres = 1;
        Vec3 entityVec = player.m_20182_();
        PriorityQueue<BlockPos> orePositions = new PriorityQueue<BlockPos>(Comparator.comparingDouble(pos -> pos.m_123331_((Vec3i)entityPos)));
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos2 = entityPos.m_7918_(x, y, z);
                    BlockState state = clientLevel.m_8055_(pos2);
                    if (!this.isOre(state.m_60734_()) && !this.isConfigOre(state.m_60734_()) && !OreCompat.isModdedOre(state.m_60734_())) continue;
                    orePositions.offer(pos2);
                }
            }
        }
        int oreCount = 0;
        while (!orePositions.isEmpty() && oreCount < maxOres) {
            BlockPos pos3 = orePositions.poll();
            Vec3 oreVec = Vec3.m_82512_((Vec3i)pos3);
            Vec3 direction = oreVec.m_82546_(entityVec).m_82541_();
            double distanceToOre = entityVec.m_82554_(oreVec);
            if (distanceToOre <= 2.0) {
                ++oreCount;
                continue;
            }
            for (double d = 0.1; d < 2.5; d += 0.1) {
                double particleX = entityVec.f_82479_ + direction.f_82479_ * d;
                double particleY = entityVec.f_82480_ + direction.f_82480_ * d + 0.5;
                double particleZ = entityVec.f_82481_ + direction.f_82481_ * d;
                particleX = Math.min(Math.max(particleX, entityVec.f_82479_ - 5.0), entityVec.f_82479_ + 5.0);
                particleY = Math.min(Math.max(particleY, entityVec.f_82480_ - 5.0), entityVec.f_82480_ + 5.0);
                particleZ = Math.min(Math.max(particleZ, entityVec.f_82481_ - 5.0), entityVec.f_82481_ + 5.0);
                clientLevel.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 1.0f), particleX, particleY, particleZ, 0.0, 0.0, 0.0);
            }
            ++oreCount;
        }
    }

    private boolean isOre(Block block) {
        List<Block> ORE_BLOCKS = Arrays.asList(Blocks.f_49997_, Blocks.f_152469_, Blocks.f_152505_, Blocks.f_152506_, Blocks.f_49996_, Blocks.f_152468_, Blocks.f_49995_, Blocks.f_152467_, Blocks.f_50089_, Blocks.f_152474_, Blocks.f_50173_, Blocks.f_152473_, Blocks.f_50264_, Blocks.f_152479_, Blocks.f_50059_, Blocks.f_152472_, Blocks.f_49998_, Blocks.f_50331_, Blocks.f_50722_);
        return ORE_BLOCKS.contains(block);
    }

    private boolean isConfigOre(Block block) {
        Set oreBlockLocations = ((List)CommonConfig.SPELUNKER_ORE_LIST.get()).stream().map(ResourceLocation::new).collect(Collectors.toSet());
        return oreBlockLocations.contains(ForgeRegistries.BLOCKS.getKey((Object)block));
    }
}

