/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.apothecary.effect;

import java.util.Objects;
import java.util.UUID;
import net.gobies.apothecary.config.CommonConfig;
import net.gobies.apothecary.init.AEffects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class Chilled
extends MobEffect {
    private static final UUID MOVEMENT_SPEED_UUID = UUID.randomUUID();
    private static final UUID ATTACK_SPEED_UUID = UUID.randomUUID();

    public Chilled(MobEffectCategory category, int color) {
        super(category, color);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        if (livingEntity.m_21023_((MobEffect)AEffects.Chilled.get()) && (livingEntity.m_6060_() || livingEntity.m_20077_())) {
            livingEntity.m_21195_((MobEffect)AEffects.Chilled.get());
        }
    }

    public void m_6385_(@NotNull LivingEntity livingEntity, @NotNull AttributeMap attribute, int amplifier) {
        AttributeInstance MovementSpeed;
        super.m_6385_(livingEntity, attribute, amplifier);
        AttributeInstance AttackSpeed = livingEntity.m_21051_(Attributes.f_22283_);
        if (AttackSpeed != null && AttackSpeed.m_22111_(ATTACK_SPEED_UUID) == null) {
            double attackSpeed = (Double)CommonConfig.CHILLED_SPEED_DECREASE.get() * (double)(amplifier + 1);
            AttackSpeed.m_22125_(new AttributeModifier(ATTACK_SPEED_UUID, "Chilled Reduced Attack Speed", -attackSpeed, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if ((MovementSpeed = livingEntity.m_21051_(Attributes.f_22279_)) != null && MovementSpeed.m_22111_(MOVEMENT_SPEED_UUID) == null) {
            double movementSpeed = (Double)CommonConfig.CHILLED_SPEED_DECREASE.get() * (double)(amplifier + 1);
            MovementSpeed.m_22125_(new AttributeModifier(MOVEMENT_SPEED_UUID, "Chilled Reduced Movement Speed", -movementSpeed, AttributeModifier.Operation.MULTIPLY_BASE));
        }
    }

    public void m_6386_(@NotNull LivingEntity entity, @NotNull AttributeMap attribute, int amplifier) {
        AttributeInstance MovementSpeed;
        super.m_6386_(entity, attribute, amplifier);
        AttributeInstance AttackSpeed = entity.m_21051_(Attributes.f_22283_);
        if (AttackSpeed != null && AttackSpeed.m_22111_(ATTACK_SPEED_UUID) != null) {
            AttackSpeed.m_22120_(ATTACK_SPEED_UUID);
        }
        if ((MovementSpeed = entity.m_21051_(Attributes.f_22279_)) != null && MovementSpeed.m_22111_(MOVEMENT_SPEED_UUID) != null) {
            MovementSpeed.m_22120_(MOVEMENT_SPEED_UUID);
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        if (player.m_21023_((MobEffect)AEffects.Chilled.get())) {
            int amplifier = Objects.requireNonNull(player.m_21124_((MobEffect)AEffects.Chilled.get())).m_19564_();
            double miningSpeedDecrease = 0.0;
            if (amplifier >= 0) {
                miningSpeedDecrease = (Double)CommonConfig.CHILLED_SPEED_DECREASE.get() * (double)(amplifier + 1);
            }
            double newBreakSpeed = (double)event.getNewSpeed() * (1.0 - miningSpeedDecrease);
            event.setNewSpeed((float)newBreakSpeed);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    static {
        MinecraftForge.EVENT_BUS.register(Chilled.class);
    }
}

