/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.apothecary.compat;

import java.util.HashMap;
import java.util.Map;
import net.gobies.apothecary.init.AEffects;
import net.gobies.apothecary.util.DurationUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidEffectEvents {
    private static final Map<LivingEntity, Integer> acidDurationMap = new HashMap<LivingEntity, Integer>();

    public static void loadCompat() {
        MinecraftForge.EVENT_BUS.register((Object)new FluidEffectEvents());
    }

    @SubscribeEvent
    public void fluidEffects(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        BlockPos blockPos = entity.m_20183_();
        FluidState fluidState = level.m_6425_(blockPos);
        ResourceLocation fluidLocation = ForgeRegistries.FLUIDS.getKey((Object)fluidState.m_76152_());
        if (ModList.get().isLoaded("alexscaves") && fluidLocation != null) {
            boolean isAcid = fluidLocation.equals((Object)new ResourceLocation("alexscaves", "acid"));
            boolean isAcidFlowing = fluidLocation.equals((Object)new ResourceLocation("alexscaves", "acid_flowing"));
            if ((isAcid || isAcidFlowing) && !FluidEffectEvents.isWearingHazmatArmor(entity)) {
                MobEffectInstance existingEffect;
                acidDurationMap.put(entity, acidDurationMap.getOrDefault(entity, 0) + 1);
                int duration = acidDurationMap.get(entity);
                int amplifier = 0;
                int effectDuration = isAcid ? DurationUtils.getRandomVeryLongDuration() : DurationUtils.getRandomMediumDuration();
                if (duration > 500) {
                    amplifier = 1;
                }
                if (duration > 1000) {
                    amplifier = 2;
                }
                if ((existingEffect = entity.m_21124_((MobEffect)AEffects.Corrosion.get())) == null) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)AEffects.Corrosion.get(), effectDuration, amplifier));
                } else {
                    int existingAmplifier = existingEffect.m_19564_();
                    int existingDuration = existingEffect.m_19557_();
                    if (existingAmplifier < amplifier) {
                        entity.m_7292_(new MobEffectInstance((MobEffect)AEffects.Corrosion.get(), existingDuration, amplifier));
                    } else {
                        int newDuration = existingDuration + 20;
                        entity.m_7292_(new MobEffectInstance((MobEffect)AEffects.Corrosion.get(), Math.min(newDuration, effectDuration), existingAmplifier));
                    }
                }
            } else {
                acidDurationMap.remove(entity);
            }
        }
        if (ModList.get().isLoaded("biomesoplenty") && fluidLocation != null) {
            boolean isBlood = fluidLocation.equals((Object)new ResourceLocation("biomesoplenty", "blood"));
            boolean isBloodFlowing = fluidLocation.equals((Object)new ResourceLocation("biomesoplenty", "flowing_blood"));
            if (isBlood || isBloodFlowing) {
                entity.m_7292_(new MobEffectInstance((MobEffect)AEffects.Indolence.get(), DurationUtils.getRandomLongDuration(), 0));
            }
        }
    }

    private static boolean isWearingHazmatArmor(LivingEntity entity) {
        ItemStack head = entity.m_6844_(EquipmentSlot.HEAD);
        ItemStack chest = entity.m_6844_(EquipmentSlot.CHEST);
        ItemStack legs = entity.m_6844_(EquipmentSlot.LEGS);
        ItemStack feet = entity.m_6844_(EquipmentSlot.FEET);
        ResourceLocation headLocation = ForgeRegistries.ITEMS.getKey((Object)head.m_41720_());
        ResourceLocation chestLocation = ForgeRegistries.ITEMS.getKey((Object)chest.m_41720_());
        ResourceLocation legsLocation = ForgeRegistries.ITEMS.getKey((Object)legs.m_41720_());
        ResourceLocation feetLocation = ForgeRegistries.ITEMS.getKey((Object)feet.m_41720_());
        return headLocation != null && headLocation.equals((Object)new ResourceLocation("alexscaves", "hazmat_mask")) && chestLocation != null && chestLocation.equals((Object)new ResourceLocation("alexscaves", "hazmat_chestplate")) && legsLocation != null && legsLocation.equals((Object)new ResourceLocation("alexscaves", "hazmat_leggings")) && feetLocation != null && feetLocation.equals((Object)new ResourceLocation("alexscaves", "hazmat_boots"));
    }
}

