/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.smarterfarmers;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.misc.FrequencyOrderedCollection;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.smarterfarmers.FarmTaskDebugRenderer;
import net.mehvahdjukaar.smarterfarmers.FarmTaskLogic;
import net.mehvahdjukaar.smarterfarmers.SFPlatformStuff;
import net.mehvahdjukaar.smarterfarmers.SmarterFarmers;
import net.mehvahdjukaar.smarterfarmers.integration.QuarkIntegration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.HarvestFarmland;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class SFHarvestFarmland
extends HarvestFarmland {
    public int plantTimer;
    public BlockPos aboveFarmlandPos = null;
    public ItemStack seedToHold = null;
    @VisibleForTesting
    public boolean active = false;
    @VisibleForTesting
    public List<Pair<BlockPos, Action>> farmlandAround;
    @VisibleForTesting
    public long lastTriedToStart;

    protected boolean m_6114_(ServerLevel level, Villager owner) {
        this.lastTriedToStart = level.m_46467_();
        if (!level.m_46469_().m_46207_(GameRules.f_46132_)) {
            return false;
        }
        if (owner.m_7141_().m_35571_() != VillagerProfession.f_35590_) {
            return false;
        }
        this.farmlandAround = this.getValidFarmlandAround(level, owner);
        if (this.farmlandAround.isEmpty()) {
            return false;
        }
        Pair<BlockPos, Action> chosen = this.farmlandAround.get(level.m_213780_().m_188503_(this.farmlandAround.size()));
        this.aboveFarmlandPos = (BlockPos)chosen.getFirst();
        this.seedToHold = null;
        if (chosen.getSecond() == Action.PLANT) {
            ItemStack seed = this.getSeedToPlantAt(this.aboveFarmlandPos, level, owner);
            if (!seed.m_41619_()) {
                this.seedToHold = seed;
            } else {
                this.farmlandAround.removeIf(e -> e.getSecond() == Action.PLANT);
                if (this.farmlandAround.isEmpty()) {
                    return false;
                }
                chosen = this.farmlandAround.get(level.m_213780_().m_188503_(this.farmlandAround.size()));
                this.aboveFarmlandPos = (BlockPos)chosen.getFirst();
            }
        }
        return true;
    }

    private List<Pair<BlockPos, Action>> getValidFarmlandAround(ServerLevel level, Villager owner) {
        ArrayList<Pair<BlockPos, Action>> validFarmland = new ArrayList<Pair<BlockPos, Action>>();
        BlockPos.MutableBlockPos mutableBlockPos = owner.m_20183_().m_122032_();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    mutableBlockPos.m_122169_(owner.m_20185_() + (double)i, owner.m_20186_() + (double)j, owner.m_20189_() + (double)k);
                    Action actionForPos = this.getActionForPos((BlockPos)mutableBlockPos, level);
                    if (actionForPos == null) continue;
                    validFarmland.add((Pair<BlockPos, Action>)Pair.of((Object)new BlockPos((Vec3i)mutableBlockPos), (Object)((Object)actionForPos)));
                }
            }
        }
        return validFarmland;
    }

    @NotNull
    protected ItemStack getSeedToPlantAt(BlockPos targetPos, ServerLevel level, Villager entity) {
        FrequencyOrderedCollection blockAsItemAround = new FrequencyOrderedCollection();
        BlockPos.MutableBlockPos mutableBlockPos = targetPos.m_122032_();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && z == 0) continue;
                    mutableBlockPos.m_122178_(targetPos.m_123341_() + x, targetPos.m_123342_() + y, targetPos.m_123343_() + z);
                    BlockState blockState = level.m_8055_((BlockPos)mutableBlockPos);
                    Item item = blockState.m_60734_().m_5456_();
                    if (item == Items.f_41852_) continue;
                    blockAsItemAround.add((Object)item);
                }
            }
        }
        SimpleContainer inventory = entity.m_35311_();
        HashSet<Item> availableSeeds = new HashSet<Item>();
        HashMap<Item, ItemStack> villagerSeedsInInventory = new HashMap<Item, ItemStack>();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            Block isCrop;
            ItemStack itemStack = inventory.m_8020_(i);
            Item it = itemStack.m_41720_();
            if (itemStack.m_41619_() || (isCrop = SFPlatformStuff.getCropFromSeed(level, targetPos, it)) == null) continue;
            availableSeeds.add(it);
            villagerSeedsInInventory.put(it, itemStack);
        }
        if (availableSeeds.isEmpty()) {
            return ItemStack.f_41583_;
        }
        for (Item item : blockAsItemAround) {
            if (!availableSeeds.contains(item)) continue;
            return (ItemStack)villagerSeedsInInventory.get(item);
        }
        return (ItemStack)villagerSeedsInInventory.get(availableSeeds.iterator().next());
    }

    protected void m_6735_(ServerLevel level, Villager entity, long gameTime) {
        this.active = true;
        this.plantTimer = SmarterFarmers.TIME_TO_HARVEST.get();
        Preconditions.checkNotNull((Object)this.aboveFarmlandPos);
        entity.m_8061_(EquipmentSlot.MAINHAND, this.seedToHold != null ? this.seedToHold.m_41777_() : FarmTaskLogic.getHoe(entity));
        entity.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.aboveFarmlandPos));
        entity.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget((PositionTracker)new BlockPosTracker(this.aboveFarmlandPos), 0.5f, 1));
        if (PlatHelper.getPhysicalSide() == PlatHelper.Side.CLIENT) {
            FarmTaskDebugRenderer.INSTANCE.trackTask(entity, this);
        }
    }

    protected void m_6732_(ServerLevel level, Villager entity, long gameTime) {
        this.active = false;
        entity.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        entity.m_6274_().m_21936_(MemoryModuleType.f_26371_);
        entity.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        this.aboveFarmlandPos = null;
        this.farmlandAround.clear();
    }

    @Nullable
    protected Action getActionForPos(BlockPos pos, ServerLevel level) {
        BlockState farmState;
        boolean validFarmland;
        BlockState cropState = level.m_8055_(pos);
        if (cropState.m_60713_(Blocks.f_50133_)) {
            boolean bl = true;
        }
        if (validFarmland = FarmTaskLogic.isValidFarmland((farmState = level.m_8055_(pos.m_7495_())).m_60734_())) {
            if (FarmTaskLogic.isCropMature(cropState, pos, (Level)level)) {
                return Action.HARVEST_AND_REPLANT;
            }
            if (cropState.m_60795_()) {
                return Action.PLANT;
            }
        }
        if (cropState.m_204336_(SmarterFarmers.HARVESTABLE_ON_DIRT_NO_REPLANT) && farmState.m_204336_(SmarterFarmers.FARMLAND_DIRT)) {
            return Action.HARVEST;
        }
        if (cropState.m_204336_(SmarterFarmers.HARVESTABLE_ON_DIRT) && farmState.m_204336_(SmarterFarmers.FARMLAND_DIRT)) {
            return Action.HARVEST_AND_REPLANT;
        }
        return null;
    }

    public void m_6725_(ServerLevel level, Villager villager, long tickCount) {
        if (!this.aboveFarmlandPos.m_203195_((Position)villager.m_20182_(), 2.0)) {
            return;
        }
        --this.plantTimer;
        if (this.plantTimer > 0) {
            return;
        }
        BlockState targetState = level.m_8055_(this.aboveFarmlandPos);
        BlockPos belowPos = this.aboveFarmlandPos.m_7495_();
        Item toReplace = Items.f_41852_;
        if (!targetState.m_60795_()) {
            if (targetState.m_204336_(SmarterFarmers.SPECIAL_HARVESTABLE) || targetState.m_204336_(SmarterFarmers.HARVESTABLE_ON_DIRT) || targetState.m_204336_(SmarterFarmers.HARVESTABLE_ON_DIRT_NO_REPLANT)) {
                level.m_46953_(this.aboveFarmlandPos, true, (Entity)villager);
                BlockState below = level.m_8055_(belowPos);
                if (SFPlatformStuff.tillBlock(below, belowPos, level)) {
                    level.m_5594_(null, belowPos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                if (targetState.m_204336_(SmarterFarmers.HARVESTABLE_ON_DIRT_NO_REPLANT)) {
                    this.aboveFarmlandPos = null;
                    return;
                }
            } else if (FarmTaskLogic.isCropMature(targetState, this.aboveFarmlandPos, (Level)level)) {
                if (SmarterFarmers.QUARK && QuarkIntegration.breakWithAutoReplant(level, this.aboveFarmlandPos, (LivingEntity)villager)) {
                    this.aboveFarmlandPos = null;
                    return;
                }
                toReplace = targetState.m_60734_().m_5456_();
                level.m_46953_(this.aboveFarmlandPos, true, (Entity)villager);
            }
        }
        BlockState farmlandBlock = level.m_8055_(belowPos);
        targetState = level.m_8055_(this.aboveFarmlandPos);
        if (targetState.m_60795_() && FarmTaskLogic.isValidFarmland(farmlandBlock.m_60734_())) {
            ItemStack itemToPlant = ItemStack.f_41583_;
            if (toReplace != Items.f_41852_) {
                itemToPlant = this.findSameItem(villager.m_35311_(), toReplace);
            }
            if (itemToPlant.m_41619_()) {
                itemToPlant = this.getSeedToPlantAt(this.aboveFarmlandPos, level, villager);
            }
            if (!itemToPlant.m_41619_()) {
                BlockState plant = SFPlatformStuff.getPlant(level, this.aboveFarmlandPos, itemToPlant);
                if (plant != null) {
                    level.m_7731_(this.aboveFarmlandPos, plant, 3);
                    level.m_220407_(GameEvent.f_157797_, this.aboveFarmlandPos, GameEvent.Context.m_223719_((Entity)villager, (BlockState)plant));
                    level.m_6263_(null, (double)this.aboveFarmlandPos.m_123341_(), (double)this.aboveFarmlandPos.m_123342_(), (double)this.aboveFarmlandPos.m_123343_(), SoundEvents.f_11839_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    itemToPlant.m_41774_(1);
                } else {
                    SmarterFarmers.LOGGER.error("Failed to plant seed at {} from item {} and block {}: ", (Object)this.aboveFarmlandPos, (Object)itemToPlant, (Object)toReplace);
                }
            }
        }
        this.aboveFarmlandPos = null;
    }

    @NotNull
    private ItemStack findSameItem(SimpleContainer inventory, Item toReplace) {
        if (toReplace != Items.f_41852_ && toReplace instanceof BlockItem) {
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                ItemStack is = inventory.m_8020_(i);
                if (is.m_41720_() != toReplace) continue;
                return is;
            }
        }
        return ItemStack.f_41583_;
    }

    protected boolean m_6737_(ServerLevel level, Villager entity, long gameTime) {
        return this.aboveFarmlandPos != null;
    }

    public static enum Action {
        HARVEST,
        HARVEST_AND_REPLANT,
        PLANT;


        public boolean harvests() {
            return this == HARVEST || this == HARVEST_AND_REPLANT;
        }
    }
}

