/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.report;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.exception.AbortedException;
import com.bawnorton.neruina.exception.InProgressException;
import com.bawnorton.neruina.handler.MessageHandler;
import com.bawnorton.neruina.report.Storage;
import com.bawnorton.neruina.thread.AbortableCountDownLatch;
import com.bawnorton.neruina.version.VersionedText;
import com.google.gson.JsonObject;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.github.GitHub;

public final class GithubAuthManager {
    private static final String CLIENT_ID = "1907e7c3f988a98face9";
    private static final String GITHUB_AUTH_URL = "https://github.com/login/oauth/authorize";
    private static final String GITHUB_TOKEN_URL = "https://github.com/login/oauth/access_token";
    private static final int PORT = 25595;
    private static final Map<UUID, LoginRecord> logins = new HashMap<UUID, LoginRecord>();

    public static boolean cancelLogin(ServerPlayer player) {
        LoginRecord record = logins.get(player.m_20148_());
        if (record == null || !record.inProgress) {
            return false;
        }
        record.authLatch.abort();
        return true;
    }

    public static CompletableFuture<GitHub> getOrLogin(ServerPlayer player) {
        MessageHandler messageHandler = Neruina.getInstance().getMessageHandler();
        LoginRecord record = logins.computeIfAbsent(player.m_20148_(), uuid -> new LoginRecord());
        if (record.gitHub != null) {
            messageHandler.sendToPlayer((Player)player, VersionedText.translatable("commands.neruina.report.reporting", new Object[0]), false, new Component[0]);
            return CompletableFuture.completedFuture(record.gitHub);
        }
        if (record.inProgress) {
            return CompletableFuture.failedFuture(new InProgressException("Login already in progress"));
        }
        messageHandler.sendToPlayer((Player)player, VersionedText.translatable("commands.neruina.report.processing", new Object[0]), false, messageHandler.generateCancelLoginAction());
        record.inProgress = true;
        record.authLatch = new AbortableCountDownLatch(1);
        record.loginLatch = new CountDownLatch(1);
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                Neruina.LOGGER.info("Logging into GitHub...");
                return GithubAuthManager.getAuthorisationCode(record);
            }
            catch (Exception e) {
                Neruina.LOGGER.error("Failed to login to GitHub");
                throw new CompletionException(e);
            }
        }).thenApply(code -> {
            if (code == null) {
                throw new CancellationException("Authentication timed out");
            }
            try {
                Neruina.LOGGER.info("Getting OAuth token...");
                return GithubAuthManager.getOAuthToken(code);
            }
            catch (Exception e) {
                Neruina.LOGGER.error("Failed to get OAuth token");
                throw new CompletionException(e);
            }
        })).thenApply(oauthCode -> {
            try {
                Neruina.LOGGER.info("Authenticating with GitHub...");
                record.gitHub = GitHub.connectUsingOAuth((String)oauthCode);
                Neruina.LOGGER.info("Successfully Logged into GitHub as {}", (Object)record.gitHub.getMyself().getLogin());
                messageHandler.sendToPlayer((Player)player, VersionedText.translatable("commands.neruina.report.authenticated", new Object[0]), false, new Component[0]);
                return record.gitHub;
            }
            catch (IOException e) {
                Neruina.LOGGER.error("Failed to authenticate with GitHub");
                throw new CompletionException(e);
            }
        })).whenComplete((a, b) -> {
            record.inProgress = false;
            record.loginLatch.countDown();
        });
    }

    private static String getAuthorisationCode(LoginRecord record) throws IOException, AbortedException {
        URI uri;
        String state = RandomStringUtils.randomAlphabetic((int)8);
        HttpServer server = HttpServer.create(new InetSocketAddress(25595), 0);
        AtomicReference code = new AtomicReference();
        server.createContext("/github/callback", exchange -> {
            Map<String, String> query = URLEncodedUtils.parse((URI)exchange.getRequestURI(), (Charset)StandardCharsets.UTF_8).stream().collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue));
            if (!state.equals(query.get("state"))) {
                return;
            }
            code.set(query.getOrDefault("code", null));
            byte[] message = "Successfully Authenticated. You can now close this tab.".getBytes(StandardCharsets.UTF_8);
            exchange.sendResponseHeaders(200, message.length);
            exchange.getResponseBody().write(message);
            exchange.getResponseBody().close();
            record.authLatch.countDown();
        });
        try {
            URIBuilder builder = new URIBuilder(GITHUB_AUTH_URL).addParameter("scope", "public_repo gist").addParameter("client_id", CLIENT_ID).addParameter("state", state);
            uri = builder.build();
            Util.m_137581_().m_137648_(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        try {
            Neruina.LOGGER.info("Begun listening on \"http://localhost:{}/github/callback\" for Github authentication...", (Object)25595);
            server.start();
            boolean success = record.authLatch.await(5L, TimeUnit.MINUTES);
            if (!success) {
                uri = null;
                return uri;
            }
            String authCode = (String)code.get();
            if (authCode == null) {
                throw new AbortedException("Failed to authenticate with GitHub");
            }
            String string = authCode;
            return string;
        }
        catch (AbortedException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Neruina.LOGGER.warn("Github authentication was interrupted", (Throwable)e);
            throw new CancellationException("Interrupted");
        }
        finally {
            server.stop(2);
        }
    }

    private static String getOAuthToken(String code) {
        String string;
        block8: {
            CloseableHttpClient client = HttpClients.createMinimal();
            try {
                HttpPost request = GithubAuthManager.createRequest(code);
                CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                JsonObject json = GsonHelper.m_13864_((String)EntityUtils.toString((HttpEntity)response.getEntity()));
                string = json.get("access_token").getAsString();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Neruina.LOGGER.error("Failed to get OAuth token");
                    throw new RuntimeException(e);
                }
            }
            client.close();
        }
        return string;
    }

    @NotNull
    private static HttpPost createRequest(String code) {
        HttpPost request = new HttpPost(GITHUB_TOKEN_URL);
        request.setEntity((HttpEntity)new UrlEncodedFormEntity(List.of(new BasicNameValuePair("client_id", CLIENT_ID), new BasicNameValuePair("client_secret", Storage.get()), new BasicNameValuePair("code", code)), StandardCharsets.UTF_8));
        request.setHeader("Accept", "application/json");
        request.setHeader("Content-Type", "application/x-www-form-urlencoded");
        return request;
    }

    static class LoginRecord {
        private CountDownLatch loginLatch;
        private AbortableCountDownLatch authLatch;
        private boolean inProgress;
        @Nullable
        private GitHub gitHub;

        LoginRecord() {
        }
    }
}

