/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.network;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class SyncPacket {
    private boolean canTeleport;
    private List<ResourceLocation> allowedBiomes;
    private ListMultimap<ResourceLocation, ResourceLocation> dimensionKeysForAllowedBiomeKeys;

    public SyncPacket() {
    }

    public SyncPacket(boolean canTeleport, List<ResourceLocation> allowedBiomes, ListMultimap<ResourceLocation, ResourceLocation> dimensionKeysForAllowedBiomeKeys) {
        this.canTeleport = canTeleport;
        this.allowedBiomes = allowedBiomes;
        this.dimensionKeysForAllowedBiomeKeys = dimensionKeysForAllowedBiomeKeys;
    }

    public SyncPacket(FriendlyByteBuf buf) {
        this.canTeleport = buf.readBoolean();
        this.allowedBiomes = new ArrayList<ResourceLocation>();
        this.dimensionKeysForAllowedBiomeKeys = ArrayListMultimap.create();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            ResourceLocation biomeKey = buf.m_130281_();
            int numDimensions = buf.readInt();
            ArrayList<ResourceLocation> dimensionKeys = new ArrayList<ResourceLocation>();
            for (int j = 0; j < numDimensions; ++j) {
                dimensionKeys.add(buf.m_130281_());
            }
            if (biomeKey == null) continue;
            this.allowedBiomes.add(biomeKey);
            this.dimensionKeysForAllowedBiomeKeys.putAll((Object)biomeKey, dimensionKeys);
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.canTeleport);
        buf.writeInt(this.allowedBiomes.size());
        for (ResourceLocation biomeKey : this.allowedBiomes) {
            buf.m_130085_(biomeKey);
            List dimensionKeys = this.dimensionKeysForAllowedBiomeKeys.get((Object)biomeKey);
            buf.writeInt(dimensionKeys.size());
            for (ResourceLocation dimensionKey : dimensionKeys) {
                buf.m_130085_(dimensionKey);
            }
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            NaturesCompass.canTeleport = this.canTeleport;
            NaturesCompass.allowedBiomes = this.allowedBiomes;
            NaturesCompass.dimensionKeysForAllowedBiomeKeys = this.dimensionKeysForAllowedBiomeKeys;
        });
        ctx.get().setPacketHandled(true);
    }
}

