/*
 * Decompiled with CFR 0.152.
 */
package me.kall.potacore.mixinextras.utils;

import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import me.kall.potacore.mixinextras.utils.MixinExtrasLogger;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Bytecode;

public class InjectorUtils {
    private static final MixinExtrasLogger LOGGER = MixinExtrasLogger.get("InjectorUtils");

    public static boolean isVirtualRedirect(InjectionNodes.InjectionNode node) {
        return node.isReplaced() && node.hasDecoration("redirector") && node.getCurrentTarget().getOpcode() != 184;
    }

    public static boolean isDynamicInstanceofRedirect(InjectionNodes.InjectionNode node) {
        AbstractInsnNode originalTarget = node.getOriginalTarget();
        AbstractInsnNode currentTarget = node.getCurrentTarget();
        return originalTarget.getOpcode() == 193 && currentTarget instanceof MethodInsnNode && Type.getReturnType((String)((MethodInsnNode)currentTarget).desc).equals((Object)Type.getType(Class.class));
    }

    public static void checkForDupedNews(Map<Target, List<InjectionNodes.InjectionNode>> targets) {
        for (Map.Entry<Target, List<InjectionNodes.InjectionNode>> entry : targets.entrySet()) {
            for (InjectionNodes.InjectionNode node : entry.getValue()) {
                AbstractInsnNode currentTarget = node.getCurrentTarget();
                if (currentTarget.getOpcode() != 187 || currentTarget.getNext().getOpcode() != 89) continue;
                node.decorate("mixinextras_newIsDuped", (Object)true);
            }
        }
    }

    public static boolean isDupedNew(InjectionNodes.InjectionNode node) {
        AbstractInsnNode currentTarget = node.getCurrentTarget();
        return currentTarget != null && currentTarget.getOpcode() == 187 && node.hasDecoration("mixinextras_newIsDuped");
    }

    public static boolean isDupedFactoryRedirect(InjectionNodes.InjectionNode node) {
        AbstractInsnNode originalTarget = node.getOriginalTarget();
        return node.isReplaced() && originalTarget.getOpcode() == 187 && !node.hasDecoration("mixinextras_wrappedOperation") && node.hasDecoration("mixinextras_newIsDuped");
    }

    public static AbstractInsnNode findFactoryRedirectThrowString(Target target, AbstractInsnNode start) {
        ListIterator it = target.insns.iterator(target.indexOf(start));
        while (it.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)it.next();
            if (!(insn instanceof LdcInsnNode)) continue;
            LdcInsnNode ldc = (LdcInsnNode)insn;
            if (!(ldc.cst instanceof String) || !((String)ldc.cst).startsWith("@Redirect constructor handler ")) continue;
            return ldc;
        }
        LOGGER.warn("Please inform LlamaLad7! Failed to find factory redirect throw string for {}", Bytecode.describeNode((AbstractInsnNode)start));
        return null;
    }

    public static void checkForImmediatePops(Map<Target, List<InjectionNodes.InjectionNode>> targets) {
        for (List<InjectionNodes.InjectionNode> nodeList : targets.values()) {
            for (InjectionNodes.InjectionNode node : nodeList) {
                Type returnType;
                AbstractInsnNode currentTarget = node.getCurrentTarget();
                if (!(currentTarget instanceof MethodInsnNode) || !InjectorUtils.isTypePoppedByInstruction(returnType = Type.getReturnType((String)((MethodInsnNode)currentTarget).desc), currentTarget.getNext())) continue;
                node.decorate("mixinextras_operationIsImmediatelyPopped", (Object)true);
            }
        }
    }

    private static boolean isTypePoppedByInstruction(Type type, AbstractInsnNode insn) {
        switch (type.getSize()) {
            case 2: {
                return insn.getOpcode() == 88;
            }
            case 1: {
                return insn.getOpcode() == 87;
            }
        }
        return false;
    }
}

