/*
 * Decompiled with CFR 0.152.
 */
package com.teampotato.potacore.iteration;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterableIterator<K>
implements Iterator<K> {
    private final Predicate<K> filter;
    private final Iterator<K> iterator;
    @Nullable
    private K next;

    public FilterableIterator(@NotNull Iterator<K> iterator, @NotNull Predicate<K> filter) {
        this.filter = filter;
        this.iterator = iterator;
    }

    private void advance() {
        block2: {
            while (this.iterator.hasNext()) {
                K candidate = this.iterator.next();
                if (this.filter.test(candidate)) {
                    this.next = candidate;
                    break block2;
                }
                this.next = null;
            }
            this.next = null;
        }
    }

    @Override
    public boolean hasNext() {
        this.advance();
        return this.next != null;
    }

    @Override
    public K next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        return this.next;
    }

    @Override
    public void forEachRemaining(@NotNull Consumer<? super K> action) {
        while (this.hasNext()) {
            action.accept(this.next());
        }
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

