/*
 * Decompiled with CFR 0.152.
 */
package com.teampotato.potacore.client;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.minecraftforge.fml.loading.FMLLoader;
import org.jetbrains.annotations.Nullable;

public class SimpleJsonConfig {
    private final Path configPath;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private Map<String, Object> configMap = new Object2ObjectOpenHashMap();

    private SimpleJsonConfig(Path configPath) {
        try {
            this.configPath = configPath;
            this.loadConfig();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static SimpleJsonConfig create(Path configPath) {
        return FMLLoader.getDist().isClient() ? new SimpleJsonConfig(configPath) : null;
    }

    private void loadConfig() throws IOException {
        if (Files.exists(this.configPath, new LinkOption[0])) {
            byte[] bytes = Files.readAllBytes(this.configPath);
            String json = new String(bytes, StandardCharsets.UTF_8);
            if (json.trim().isEmpty()) {
                this.configMap = new Object2ObjectOpenHashMap();
            } else {
                this.configMap = (Map)this.gson.fromJson(json, new TypeToken<Map<String, Object>>(){}.getType());
                if (this.configMap == null) {
                    this.configMap = new Object2ObjectOpenHashMap();
                }
            }
        } else {
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            Files.createFile(this.configPath, new FileAttribute[0]);
            this.configMap = new Object2ObjectOpenHashMap();
            this.saveConfig();
        }
    }

    public void saveConfig() {
        try {
            String json = this.gson.toJson(this.configMap);
            Files.writeString(this.configPath, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void reloadConfig() {
        try {
            this.loadConfig();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @CanIgnoreReturnValue
    public SimpleJsonConfig put(String key, Object value) {
        this.configMap.put(key, value);
        this.saveConfig();
        return this;
    }

    @Nullable
    public <T> T get(String key) {
        return (T)this.configMap.get(key);
    }

    @Nullable
    public <T> T get(String key, Class<T> type) {
        Object value = this.configMap.get(key);
        if (value != null) {
            return type.cast(value);
        }
        return null;
    }
}

