/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.item;

import dev.quarris.ppfluids.registry.ItemSetup;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.ItemFluidContainer;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class FluidItem
extends ItemFluidContainer {
    public FluidItem() {
        super(new Item.Properties(), Integer.MAX_VALUE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"info.ppfluids.fluid_item.usage"));
        FluidStack fluidStack = FluidItem.getFluidCopyFromItem(stack);
        tooltip.add((Component)Component.m_237115_((String)fluidStack.getTranslationKey()).m_130946_(": ").m_130946_(String.valueOf(fluidStack.getAmount())));
    }

    public static ItemStack createItemFromFluid(FluidStack fluid) {
        ItemStack item = new ItemStack((ItemLike)ItemSetup.FLUID_HOLDER.get());
        int filled = FluidUtil.getFluidHandler((ItemStack)item).map(tank -> tank.fill(fluid, IFluidHandler.FluidAction.EXECUTE)).orElse(0);
        return item;
    }

    public static FluidStack getFluidCopyFromItem(ItemStack item) {
        return FluidUtil.getFluidHandler((ItemStack)item).map(handler -> handler.getFluidInTank(0).copy()).orElse(FluidStack.EMPTY);
    }

    public static ItemStack insertFluid(IFluidHandler handler, ItemStack fluidItem, boolean simulate) {
        FluidStack fluidStack = FluidItem.getFluidCopyFromItem(fluidItem);
        int filled = handler.fill(fluidStack, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        fluidStack.shrink(filled);
        if (fluidStack.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return FluidItem.createItemFromFluid(fluidStack);
    }

    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidHandlerItemStack.Consumable(stack, this.capacity){

            public boolean canFillFluidType(FluidStack fluid) {
                return this.getFluid().isEmpty();
            }
        };
    }
}

