/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createmobspawners.network.packet;

import dev.kvnmtz.createmobspawners.block.custom.entity.MechanicalSpawnerBlockEntity;
import dev.kvnmtz.createmobspawners.utils.ParticleUtils;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundSpawnerEventPacket {
    private final BlockPos spawnerPosition;
    private final int spawnedEntityId;

    public ClientboundSpawnerEventPacket(BlockPos spawnerPosition, int spawnedEntityId) {
        this.spawnerPosition = spawnerPosition;
        this.spawnedEntityId = spawnedEntityId;
    }

    public ClientboundSpawnerEventPacket(FriendlyByteBuf buffer) {
        this(buffer.m_130135_(), buffer.readInt());
    }

    public BlockPos getSpawnerPosition() {
        return this.spawnerPosition;
    }

    public int getSpawnedEntityId() {
        return this.spawnedEntityId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.spawnerPosition);
        buffer.writeInt(this.spawnedEntityId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHandler.handle(this)));
        ctx.get().setPacketHandled(true);
    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        public static void handle(ClientboundSpawnerEventPacket packet) {
            MechanicalSpawnerBlockEntity be;
            Optional<Integer> optColor;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.getSpawnedEntityId());
            if (entity == null) {
                return;
            }
            AABB entityBoundingBox = entity.m_20191_();
            Vec3 entityCenter = entityBoundingBox.m_82399_();
            Vec3 spawnerCenter = packet.getSpawnerPosition().m_252807_();
            ParticleUtils.drawParticleLine((ParticleOptions)ParticleTypes.f_123771_, (Level)level, spawnerCenter, entityCenter, 0.5, Vec3.f_82478_);
            ParticleUtils.drawPotionEffectLikeParticles((ParticleOptions)ParticleTypes.f_123771_, (Level)level, entityBoundingBox, entity.m_20182_(), new Vec3(0.1, 0.1, 0.1), ParticleUtils.getParticleCountForEntity(entity), 0.75f);
            BlockEntity blockEntity = level.m_7702_(packet.getSpawnerPosition());
            if (blockEntity instanceof MechanicalSpawnerBlockEntity && (optColor = (be = (MechanicalSpawnerBlockEntity)blockEntity).getParticleColor()).isPresent()) {
                int color = optColor.get();
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                ParticleUtils.drawParticles((ParticleOptions)ParticleTypes.f_123811_, (Level)level, spawnerCenter, 40, 0.5, 0.5, 0.5, new Vec3((double)r / 255.0, (double)g / 255.0, (double)b / 255.0));
            }
        }
    }
}

