/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createmobspawners.item.custom;

import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import dev.kvnmtz.createmobspawners.CreateMobSpawners;
import dev.kvnmtz.createmobspawners.capabilities.entitystorage.EntityStorageItemStackCapabilityProvider;
import dev.kvnmtz.createmobspawners.capabilities.entitystorage.IEntityStorage;
import dev.kvnmtz.createmobspawners.capabilities.entitystorage.StoredEntityData;
import dev.kvnmtz.createmobspawners.capabilities.registry.ModCapabilities;
import dev.kvnmtz.createmobspawners.item.registry.ModItems;
import dev.kvnmtz.createmobspawners.item.renderer.SoulCatcherRenderer;
import dev.kvnmtz.createmobspawners.network.PacketHandler;
import dev.kvnmtz.createmobspawners.network.packet.ClientboundEntityCatchPacket;
import dev.kvnmtz.createmobspawners.network.packet.ClientboundEntityReleasePacket;
import dev.kvnmtz.createmobspawners.utils.BoundingBoxUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.extensions.IForgeItem;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="create_mob_spawners", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SoulCatcherItem
extends Item
implements IForgeItem {
    private static final HashMap<LivingEntity, ShrinkingEntityData> shrinkingEntities = new HashMap();
    private static final HashMap<Entity, Long> shrinkingEntitiesToStartTimeMap = new HashMap();
    private static final float CATCHING_LINE_DRAW_DELAY = 0.2f;

    public SoulCatcherItem(Item.Properties properties) {
        super(properties);
    }

    public static void addShrinkingEntity(Entity entity) {
        shrinkingEntitiesToStartTimeMap.put(entity, System.currentTimeMillis());
    }

    public static void removeShrinkingEntity(Entity entity) {
        shrinkingEntitiesToStartTimeMap.remove(entity);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    protected static void onRenderEntity(RenderLivingEvent.Pre<?, ?> event) {
        LivingEntity entity = event.getEntity();
        if (!shrinkingEntitiesToStartTimeMap.containsKey(entity)) {
            return;
        }
        Long startTime = shrinkingEntitiesToStartTimeMap.get(entity);
        long currentTime = System.currentTimeMillis();
        float elapsedTime = (float)(currentTime - startTime) / 1000.0f;
        float scaleFactor = 1.0f - elapsedTime / SoulCatcherItem.getCatchingDuration((Entity)entity);
        scaleFactor = Math.max(scaleFactor, 0.0f);
        float translationHeight = entity.m_20206_() / 2.0f;
        event.getPoseStack().m_252880_(0.0f, translationHeight - scaleFactor * translationHeight, 0.0f);
        event.getPoseStack().m_85841_(scaleFactor, scaleFactor, scaleFactor);
    }

    @SubscribeEvent
    protected static void onServerTick(TickEvent.ServerTickEvent event) {
        for (LivingEntity shrinkingEntity : shrinkingEntities.keySet()) {
            ShrinkingEntityData data = shrinkingEntities.get(shrinkingEntity);
            Player player = data.player;
            ItemStack itemStack = data.itemStack;
            ItemStack currentItem = player.m_21205_();
            if (!currentItem.equals(itemStack, true) || !SoulCatcherItem.isItemAbleToCatch(currentItem)) {
                SoulCatcherItem.cancelCatch(shrinkingEntity);
                continue;
            }
            if (!SoulCatcherItem.isEntityCatchable(player, shrinkingEntity, component -> player.m_5661_(component, true))) {
                SoulCatcherItem.cancelCatch(shrinkingEntity);
                continue;
            }
            long currentTime = System.currentTimeMillis();
            float elapsedTime = (float)(currentTime - data.startTime) / 1000.0f;
            if (elapsedTime >= data.nextLineAfterElapsedSeconds) {
                PacketHandler.sendToNearbyPlayers(new ClientboundEntityCatchPacket(shrinkingEntity.m_19879_(), player.m_19879_(), ClientboundEntityCatchPacket.EntityCatchState.IN_PROGRESS), player.m_146892_(), 16.0, (ResourceKey<Level>)player.m_9236_().m_46472_());
                data.nextLineAfterElapsedSeconds += 0.2f;
            }
            if (!(elapsedTime >= SoulCatcherItem.getCatchingDuration((Entity)shrinkingEntity))) continue;
            SoulCatcherItem.onShrinkComplete(shrinkingEntity);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    protected static void addMobTooltip(ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (itemStack.m_41720_() != ModItems.SOUL_CATCHER.get()) {
            return;
        }
        boolean hasEntityData = SoulCatcherItem.getEntityData(itemStack).isPresent();
        if (!hasEntityData) {
            return;
        }
        Optional<String> displayName = SoulCatcherItem.getEntityData(itemStack).get().getEntityDisplayName();
        if (displayName.isEmpty()) {
            return;
        }
        event.getToolTip().add(1, Component.m_237113_((String)displayName.get()).m_130940_(ChatFormatting.GRAY));
    }

    @SubscribeEvent
    protected static void onServerClose(ServerStoppingEvent event) {
        for (LivingEntity shrinkingEntity : shrinkingEntities.keySet()) {
            SoulCatcherItem.cancelCatch(shrinkingEntity);
        }
    }

    @SubscribeEvent
    protected static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        for (Map.Entry<LivingEntity, ShrinkingEntityData> entry : shrinkingEntities.entrySet()) {
            if (player != entry.getValue().player) continue;
            SoulCatcherItem.cancelCatch(entry.getKey());
        }
    }

    @SubscribeEvent
    protected static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        for (Map.Entry<LivingEntity, ShrinkingEntityData> entry : shrinkingEntities.entrySet()) {
            if (player != entry.getValue().player) continue;
            SoulCatcherItem.cancelCatch(entry.getKey());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    protected static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getLevel().f_46443_) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        if (itemStack.m_41720_() != ModItems.EMPTY_SOUL_CATCHER.get()) {
            return;
        }
        event.setCancellationResult(InteractionResult.FAIL);
        event.setCanceled(true);
        Player player = event.getEntity();
        Entity targetEntity = event.getTarget();
        if (!(targetEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)targetEntity;
        if (!SoulCatcherItem.isItemAbleToCatch(itemStack)) {
            return;
        }
        if (!SoulCatcherItem.isEntityCatchable(player, target, component -> player.m_5661_(component, true))) {
            return;
        }
        if (shrinkingEntities.containsKey(target)) {
            return;
        }
        for (ShrinkingEntityData shrinkingEntityData : shrinkingEntities.values()) {
            if (!shrinkingEntityData.player.equals((Object)player)) continue;
            return;
        }
        event.setCancellationResult(InteractionResult.SUCCESS);
        SoulCatcherItem.startCatchingEntity(target, player, itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    protected static void onEntityRemoved(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        shrinkingEntitiesToStartTimeMap.remove(entity);
    }

    private static void cancelCatch(LivingEntity entity) {
        ShrinkingEntityData data = shrinkingEntities.get(entity);
        if (data.hadAi && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_21557_(false);
        }
        PacketHandler.sendToAllPlayers(new ClientboundEntityCatchPacket(entity.m_19879_(), data.player.m_19879_(), ClientboundEntityCatchPacket.EntityCatchState.CANCELED));
        shrinkingEntities.remove(entity);
    }

    private static float getCatchingDuration(Entity entity) {
        AABB boundingBox = entity.m_20191_();
        double volume = BoundingBoxUtils.getBoundingBoxVolume(boundingBox);
        return (float)(1.3811 * Math.pow(volume, 0.5026));
    }

    public static int getCatchingDurationInTicks(AABB boundingBox) {
        double volume = BoundingBoxUtils.getBoundingBoxVolume(boundingBox);
        return Math.round((float)(1.3811 * Math.pow(volume, 0.5026)) * 20.0f);
    }

    private static void onShrinkComplete(LivingEntity entity) {
        ShrinkingEntityData data = shrinkingEntities.get(entity);
        if (data == null) {
            return;
        }
        PacketHandler.sendToAllPlayers(new ClientboundEntityCatchPacket(entity.m_19879_(), data.player.m_19879_(), ClientboundEntityCatchPacket.EntityCatchState.FINISHED));
        ItemStack newItemStack = SoulCatcherItem.catchEntity(data.itemStack, entity, data.hadAi);
        Player player = data.player;
        player.m_21008_(InteractionHand.MAIN_HAND, newItemStack);
        shrinkingEntities.remove(entity);
    }

    private static void startCatchingEntity(LivingEntity entity, Player player, ItemStack itemStack) {
        Mob mob;
        boolean hadAi = false;
        if (entity instanceof Mob) {
            mob = (Mob)entity;
            hadAi = !mob.m_21525_();
        }
        shrinkingEntities.put(entity, new ShrinkingEntityData(player, itemStack, hadAi));
        if (entity instanceof Mob) {
            mob = (Mob)entity;
            mob.m_21557_(true);
        }
        PacketHandler.sendToAllPlayers(new ClientboundEntityCatchPacket(entity.m_19879_(), player.m_19879_(), ClientboundEntityCatchPacket.EntityCatchState.STARTED));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_().f_46443_) {
            return InteractionResult.FAIL;
        }
        if (context.m_43722_().m_41720_() != ModItems.SOUL_CATCHER.get()) {
            return InteractionResult.FAIL;
        }
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Optional<Entity> optEntity = SoulCatcherItem.releaseEntity(context.m_43725_(), context.m_43722_(), context.m_43719_(), context.m_8083_(), emptyCatcher -> player.m_21008_(context.m_43724_(), emptyCatcher), component -> player.m_5661_(component, true));
        optEntity.ifPresent(entity -> PacketHandler.sendToNearbyPlayers(new ClientboundEntityReleasePacket(entity.m_19879_(), player.m_19879_()), entity.m_20182_(), 16.0, (ResourceKey<Level>)entity.m_9236_().m_46472_()));
        return InteractionResult.SUCCESS;
    }

    private static CapturableStatus getCapturableStatus(EntityType<? extends LivingEntity> type, @Nullable Entity entity) {
        if (entity != null && SoulCatcherItem.isBoss(entity) && !((Boolean)CreateMobSpawners.SERVER_CONFIG.soulCatcherAllowBosses.get()).booleanValue()) {
            return CapturableStatus.BOSS;
        }
        if (!type.m_20584_()) {
            return CapturableStatus.INCOMPATIBLE;
        }
        if (((List)CreateMobSpawners.SERVER_CONFIG.soulCatcherEntityBlacklist.get()).contains(EntityType.m_20613_(type).toString())) {
            return CapturableStatus.BLACKLISTED;
        }
        return CapturableStatus.CAPTURABLE;
    }

    public static boolean isBoss(Entity entity) {
        return entity.m_6095_().m_204039_(Tags.EntityTypes.BOSSES);
    }

    private static boolean isItemAbleToCatch(ItemStack soulCatcher) {
        Optional<StoredEntityData> entityData = SoulCatcherItem.getEntityData(soulCatcher);
        return entityData.isEmpty() || entityData.get().getEntityTypeResourceLocation().isEmpty();
    }

    private static boolean isEntityCatchable(Player player, LivingEntity entity, Consumer<Component> displayCallback) {
        float maxHealthPercentage;
        String capturableStatusKeyPrefix = "item.create_mob_spawners.empty_soul_catcher.capturable_status.";
        if (entity instanceof Player) {
            displayCallback.accept((Component)Component.m_237115_((String)"item.create_mob_spawners.empty_soul_catcher.capturable_status.player").m_130940_(ChatFormatting.RED));
            return false;
        }
        CapturableStatus status = SoulCatcherItem.getCapturableStatus((EntityType<? extends LivingEntity>)entity.m_6095_(), (Entity)entity);
        if (status != CapturableStatus.CAPTURABLE) {
            displayCallback.accept(status.errorMessage());
            return false;
        }
        boolean isBoss = SoulCatcherItem.isBoss((Entity)entity);
        if (!entity.m_21023_(MobEffects.f_19613_) && !isBoss) {
            displayCallback.accept((Component)Component.m_237115_((String)"item.create_mob_spawners.empty_soul_catcher.capturable_status.no_weakness").m_130940_(ChatFormatting.RED));
            return false;
        }
        if (!entity.m_6084_()) {
            displayCallback.accept((Component)Component.m_237115_((String)"item.create_mob_spawners.empty_soul_catcher.capturable_status.dead").m_130940_(ChatFormatting.RED));
            return false;
        }
        if ((double)entity.m_20270_((Entity)player) > (Double)CreateMobSpawners.SERVER_CONFIG.soulCatcherMaxDistance.get()) {
            displayCallback.accept((Component)Component.m_237115_((String)"item.create_mob_spawners.empty_soul_catcher.capturable_status.too_far").m_130940_(ChatFormatting.RED));
            return false;
        }
        float f = maxHealthPercentage = isBoss ? ((Double)CreateMobSpawners.SERVER_CONFIG.soulCatcherBossMaxHealthPercentage.get()).floatValue() : ((Double)CreateMobSpawners.SERVER_CONFIG.soulCatcherMaxHealthPercentage.get()).floatValue();
        if (maxHealthPercentage != 1.0f) {
            float health = entity.m_21223_();
            if (maxHealthPercentage == 0.0f) {
                boolean hasHalfHeartLeft;
                boolean bl = hasHalfHeartLeft = health == 1.0f;
                if (!hasHalfHeartLeft) {
                    displayCallback.accept((Component)Component.m_237115_((String)"item.create_mob_spawners.empty_soul_catcher.capturable_status.too_much_health").m_130940_(ChatFormatting.RED));
                    return false;
                }
            } else {
                float percentageLeft = health / entity.m_21233_();
                if (percentageLeft > maxHealthPercentage) {
                    displayCallback.accept((Component)Component.m_237115_((String)"item.create_mob_spawners.empty_soul_catcher.capturable_status.too_much_health").m_130940_(ChatFormatting.RED));
                    return false;
                }
            }
        }
        return true;
    }

    private static ItemStack catchEntity(ItemStack itemStack, LivingEntity entity, boolean hadAi) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (mob.m_21524_() != null) {
                mob.m_21455_(true, true);
            }
            if (hadAi) {
                mob.m_21557_(false);
            }
        }
        itemStack.m_41774_(1);
        ItemStack catcher = ((SoulCatcherItem)((Object)ModItems.SOUL_CATCHER.get())).m_7968_();
        SoulCatcherItem.setEntityData(catcher, entity);
        entity.m_146870_();
        return catcher;
    }

    private static Optional<Entity> releaseEntity(Level level, ItemStack catcher, Direction face, BlockPos pos, Consumer<ItemStack> emptyCatcherSetter, Consumer<Component> displayCallback) {
        AtomicReference spawnedEntity = new AtomicReference(Optional.empty());
        catcher.getCapability(ModCapabilities.ENTITY_STORAGE).ifPresent(entityStorage -> {
            if (entityStorage.hasStoredEntity()) {
                StoredEntityData entityData = entityStorage.getStoredEntityData();
                double spawnX = (double)(pos.m_123341_() + face.m_122429_()) + 0.5;
                int spawnY = pos.m_123342_() + face.m_122430_();
                double spawnZ = (double)(pos.m_123343_() + face.m_122431_()) + 0.5;
                float rotation = Mth.m_14177_((float)(level.m_213780_().m_188501_() * 360.0f));
                Optional<EntityType<?>> optEntityType = entityData.getEntityType();
                if (optEntityType.isEmpty()) {
                    return;
                }
                EntityType<?> entityType = optEntityType.get();
                if (!level.m_45772_(entityType.m_20585_(spawnX, (double)spawnY, spawnZ))) {
                    displayCallback.accept((Component)Component.m_237115_((String)"item.create_mob_spawners.soul_catcher.no_space").m_130940_(ChatFormatting.RED));
                    return;
                }
                Optional optEntity = EntityType.m_20642_((CompoundTag)entityData.getEntityTag(), (Level)level);
                optEntity.ifPresent(ent -> {
                    ent.m_6034_(spawnX, (double)spawnY, spawnZ);
                    ent.m_146922_(rotation);
                    level.m_7967_(ent);
                    emptyCatcherSetter.accept(((SoulCatcherItem)((Object)((Object)((Object)ModItems.EMPTY_SOUL_CATCHER.get())))).m_7968_());
                    spawnedEntity.set(optEntity);
                });
            }
        });
        return spawnedEntity.get();
    }

    private static void setEntityData(ItemStack stack, LivingEntity entity) {
        stack.getCapability(ModCapabilities.ENTITY_STORAGE).ifPresent(storage -> storage.setStoredEntityData(StoredEntityData.of(entity)));
    }

    public static Optional<StoredEntityData> getEntityData(ItemStack stack) {
        return stack.getCapability(ModCapabilities.ENTITY_STORAGE).map(IEntityStorage::getStoredEntityData);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new EntityStorageItemStackCapabilityProvider(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new SoulCatcherRenderer()));
    }

    private static class ShrinkingEntityData {
        private final Player player;
        private final ItemStack itemStack;
        private final long startTime;
        private float nextLineAfterElapsedSeconds;
        private final boolean hadAi;

        public ShrinkingEntityData(Player player, ItemStack itemStack, boolean hadAi) {
            this.player = player;
            this.itemStack = itemStack;
            this.startTime = System.currentTimeMillis();
            this.nextLineAfterElapsedSeconds = 0.2f;
            this.hadAi = hadAi;
        }
    }

    public static enum CapturableStatus {
        CAPTURABLE((Component)Component.m_237119_()),
        BOSS((Component)Component.m_237115_((String)"item.create_mob_spawners.empty_soul_catcher.capturable_status.boss").m_130940_(ChatFormatting.RED)),
        BLACKLISTED((Component)Component.m_237115_((String)"item.create_mob_spawners.empty_soul_catcher.capturable_status.blacklisted").m_130940_(ChatFormatting.RED)),
        INCOMPATIBLE((Component)Component.m_237115_((String)"item.create_mob_spawners.empty_soul_catcher.capturable_status.incompatible").m_130940_(ChatFormatting.RED));

        private final Component errorMessage;

        private CapturableStatus(Component errorMessage) {
            this.errorMessage = errorMessage;
        }

        public Component errorMessage() {
            return this.errorMessage;
        }
    }
}

