/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createmobspawners.compat.jei.category;

import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import dev.kvnmtz.createmobspawners.CreateMobSpawners;
import dev.kvnmtz.createmobspawners.block.custom.entity.MechanicalSpawnerBlockEntity;
import dev.kvnmtz.createmobspawners.block.registry.ModBlocks;
import dev.kvnmtz.createmobspawners.gui.animations.AnimatedSpawner;
import dev.kvnmtz.createmobspawners.gui.registry.ModGuiTextures;
import dev.kvnmtz.createmobspawners.item.custom.SoulCatcherItem;
import dev.kvnmtz.createmobspawners.item.registry.ModItems;
import dev.kvnmtz.createmobspawners.recipe.custom.SpawningRecipe;
import dev.kvnmtz.createmobspawners.utils.DrawStringUtils;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SpawningCategory
implements IRecipeCategory<SpawningRecipe> {
    public static final ResourceLocation UID = CreateMobSpawners.asResource("spawning");
    public static final RecipeType<SpawningRecipe> SPAWNING_RECIPE_TYPE = new RecipeType(UID, SpawningRecipe.class);
    private final IDrawable icon;
    private final AnimatedSpawner spawner = new AnimatedSpawner();
    private static final int START_Y = 23;
    private final IDrawable background;

    public SpawningCategory(IGuiHelper helper) {
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.MECHANICAL_SPAWNER.get()));
        this.background = new EmptyBackground(this.getWidth(), this.getHeight());
    }

    public RecipeType<SpawningRecipe> getRecipeType() {
        return SPAWNING_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"create_mob_spawners.jei.spawning.title");
    }

    public int getWidth() {
        return 196;
    }

    public int getHeight() {
        return 107;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nullable
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SpawningRecipe recipe, IFocusGroup iFocusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, this.getWidth() / 2 - AllGuiTextures.JEI_LONG_ARROW.getWidth() / 2 - 16 - 16, 5).setBackground(CreateRecipeCategory.getRenderedSlot(), -1, -1).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((SoulCatcherItem)((Object)ModItems.SOUL_CATCHER.get())).m_7968_());
        CreateRecipeCategory.addFluidSlot((IRecipeLayoutBuilder)builder, (int)(this.getWidth() / 2 - AllGuiTextures.JEI_LONG_ARROW.getWidth() / 2 - 16 - 16), (int)25, (FluidIngredient)recipe.getFluidIngredient());
    }

    public void draw(SpawningRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        AllGuiTextures.JEI_SHADOW.render(graphics, this.getWidth() / 2 - AllGuiTextures.JEI_SHADOW.getWidth() / 2, 23 - AllGuiTextures.JEI_SHADOW.getHeight() / 2 + 9);
        AllGuiTextures.JEI_LONG_ARROW.render(graphics, this.getWidth() / 2 - AllGuiTextures.JEI_LONG_ARROW.getWidth() / 2, 23 - AllGuiTextures.JEI_LONG_ARROW.getHeight() / 2);
        int questionMarkPosX = this.getWidth() / 2 + AllGuiTextures.JEI_LONG_ARROW.getWidth() / 2 + 16;
        int questionMarkPosY = 23 - AllGuiTextures.JEI_QUESTION_MARK.getHeight() / 2;
        Rect2i questionMarkRect = new Rect2i(questionMarkPosX, questionMarkPosY, AllGuiTextures.JEI_QUESTION_MARK.getWidth(), AllGuiTextures.JEI_QUESTION_MARK.getHeight());
        AllGuiTextures.JEI_QUESTION_MARK.render(graphics, questionMarkPosX, questionMarkPosY);
        if (!recipe.getBlacklist().isEmpty() || !recipe.getWhitelist().isEmpty()) {
            ModGuiTextures.WARNING.render(graphics, questionMarkPosX + questionMarkRect.m_110090_() - 4, questionMarkPosY - questionMarkRect.m_110091_() + 4);
        }
        if (questionMarkRect.m_110087_((int)mouseX, (int)mouseY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            components.add(Component.m_237115_((String)"create_mob_spawners.jei.spawning.question_mark"));
            if (!recipe.getBlacklist().isEmpty()) {
                components.add(Component.m_237115_((String)"create_mob_spawners.jei.spawning.blacklist"));
                for (ResourceLocation entityId : recipe.getBlacklist()) {
                    Optional optional = EntityType.m_20632_((String)entityId.toString());
                    optional.ifPresent(entityType -> components.add(Component.m_237113_((String)(" - " + entityType.m_20676_().getString()))));
                }
            } else if (!recipe.getWhitelist().isEmpty()) {
                components.add(Component.m_237115_((String)"create_mob_spawners.jei.spawning.whitelist"));
                for (ResourceLocation entityId : recipe.getWhitelist()) {
                    Optional optional = EntityType.m_20632_((String)entityId.toString());
                    optional.ifPresent(entityType -> components.add(Component.m_237113_((String)(" - " + entityType.m_20676_().getString()))));
                }
            }
            int longestComponent = 0;
            for (Component component : components) {
                int width = font.m_92895_(component.getString());
                if (width <= longestComponent) continue;
                longestComponent = width;
            }
            graphics.m_280666_(font, components, (int)mouseX - longestComponent / 2 - 12, (int)mouseY - 12);
        }
        this.spawner.withFluid((FluidStack)recipe.getFluidIngredient().getMatchingFluidStacks().get(0)).draw(graphics, this.getWidth() / 2 - 13, 31);
        ModGuiTextures.renderFrameBorder(graphics, 4, 48, this.getWidth() - 8, 55);
        int textY = 54;
        graphics.m_280056_(font, Component.m_237115_((String)"create_mob_spawners.jei.spawning.duration").getString(), 9, textY, 0xFFFFFF, false);
        Objects.requireNonNull(font);
        int[] rpms = new int[]{128, 256};
        DrawStringUtils.drawTable(graphics, 17, textY += 9, 0xFFFFFF, false, 2, 0, 4, new DrawStringUtils.TableColumnDefinition(DrawStringUtils.TableColumnDefinition.HorizontalAlignment.RIGHT, row -> String.format(Locale.US, "%.1fs", Float.valueOf(1.0f / MechanicalSpawnerBlockEntity.getProgressForTick(rpms[row], recipe.getSpawnTicksAtMaxSpeed()) / 20.0f))), new DrawStringUtils.TableColumnDefinition(DrawStringUtils.TableColumnDefinition.HorizontalAlignment.LEFT, row -> Component.m_237115_((String)"create_mob_spawners.jei.spawning.at").getString()), new DrawStringUtils.TableColumnDefinition(DrawStringUtils.TableColumnDefinition.HorizontalAlignment.RIGHT, row -> String.valueOf(rpms[row])), new DrawStringUtils.TableColumnDefinition(DrawStringUtils.TableColumnDefinition.HorizontalAlignment.LEFT, row -> Component.m_237115_((String)"create_mob_spawners.jei.spawning.rpm").getString()));
        Objects.requireNonNull(font);
        graphics.m_280056_(font, Component.m_237110_((String)"create_mob_spawners.jei.spawning.additional_spawn_attempts", (Object[])new Object[]{recipe.getAdditionalSpawnAttempts()}).getString(), 9, textY += 9 * 3, 0xFFFFFF, false);
    }
}

