/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createmobspawners.block.custom;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.foundation.block.IBE;
import dev.kvnmtz.createmobspawners.CreateMobSpawners;
import dev.kvnmtz.createmobspawners.block.custom.entity.MechanicalSpawnerBlockEntity;
import dev.kvnmtz.createmobspawners.block.custom.entity.registry.ModBlockEntities;
import dev.kvnmtz.createmobspawners.capabilities.entitystorage.StoredEntityData;
import dev.kvnmtz.createmobspawners.gui.screens.SpawnerScreen;
import dev.kvnmtz.createmobspawners.item.custom.SoulCatcherItem;
import dev.kvnmtz.createmobspawners.item.registry.ModItems;
import java.util.Optional;
import net.createmod.catnip.gui.ScreenOpener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MechanicalSpawnerBlock
extends KineticBlock
implements IBE<MechanicalSpawnerBlockEntity> {
    public static final DirectionProperty FACING = DirectionProperty.m_61549_((String)"facing", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST});

    public MechanicalSpawnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
        super.m_7926_(pBuilder);
    }

    private MechanicalSpawnerBlockEntity getBlockEntity(Level level, BlockPos pos) {
        return (MechanicalSpawnerBlockEntity)level.m_7702_(pos);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        boolean sneaking = pPlayer.m_6144_();
        ItemStack itemStack = pPlayer.m_21205_();
        boolean nothingInHand = itemStack.m_41619_();
        MechanicalSpawnerBlockEntity blockEntity = this.getBlockEntity(pLevel, pPos);
        boolean hasStoredEntity = blockEntity.hasStoredEntity();
        if (!sneaking) {
            if (((Boolean)CreateMobSpawners.SERVER_CONFIG.mechanicalSpawnerConfigurationAllowed.get()).booleanValue() && (nothingInHand || itemStack.m_150930_(AllItems.WRENCH.m_5456_()))) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.withBlockEntityDo((BlockGetter)pLevel, pPos, be -> this.displayScreen((MechanicalSpawnerBlockEntity)be, pPlayer)));
            } else if (itemStack.m_41720_() == ModItems.SOUL_CATCHER.get() && !hasStoredEntity) {
                Optional<StoredEntityData> entityData = SoulCatcherItem.getEntityData(itemStack);
                if (entityData.isEmpty()) {
                    return InteractionResult.FAIL;
                }
                blockEntity.setStoredEntityData(entityData.get());
                itemStack.m_41774_(1);
            }
        } else if (hasStoredEntity && nothingInHand) {
            blockEntity.ejectSoulCatcher();
        } else {
            return InteractionResult.PASS;
        }
        blockEntity.m_6596_();
        blockEntity.sendData();
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (pState.m_60734_() != pNewState.m_60734_()) {
            MechanicalSpawnerBlockEntity blockEntity = this.getBlockEntity(pLevel, pPos);
            blockEntity.ejectSoulCatcher();
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    public Class<MechanicalSpawnerBlockEntity> getBlockEntityClass() {
        return MechanicalSpawnerBlockEntity.class;
    }

    public BlockEntityType<? extends MechanicalSpawnerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlockEntities.MECHANICAL_SPAWNER.get();
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    public Direction.Axis getRotationAxis(BlockState blockState) {
        return Direction.Axis.Y;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.m_122434_() == Direction.Axis.Y;
    }

    private Direction getPlacementDirection(BlockPlaceContext context) {
        boolean mirror;
        Player player = context.m_43723_();
        boolean bl = mirror = player != null && player.m_6144_();
        if (mirror) {
            return context.m_8125_();
        }
        return context.m_8125_().m_122424_();
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)this.getPlacementDirection(pContext));
    }

    public IRotate.SpeedLevel getMinimumRequiredSpeedLevel() {
        return IRotate.SpeedLevel.of((float)((Double)CreateMobSpawners.SERVER_CONFIG.mechanicalSpawnerMinRpm.get()).floatValue());
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void displayScreen(MechanicalSpawnerBlockEntity be, Player player) {
        if (player instanceof LocalPlayer) {
            ScreenOpener.open((Screen)new SpawnerScreen(be));
        }
    }
}

