/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.registry.slabfish;

import com.teamabnormals.blueprint.core.other.tags.BlueprintBiomeTags;
import com.teamabnormals.environmental.common.slabfish.SlabfishType;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishAndCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishBreedCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishDimensionCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishEventCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishHeightCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishImpossibleCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishInBiomeCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishInBiomeKeyCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishInFluidCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishInsomniaCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishLightCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishModLoadedCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishOrCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishRaidCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishTimeCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishTypeCondition;
import com.teamabnormals.environmental.core.other.EnvironmentalConstants;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBiomeTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalBiomes;
import com.teamabnormals.environmental.core.registry.EnvironmentalRegistries;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;

public class EnvironmentalSlabfishTypes {
    public static final ResourceKey<SlabfishType> SWAMP = EnvironmentalSlabfishTypes.createKey("swamp");
    public static final ResourceKey<SlabfishType> BADLANDS = EnvironmentalSlabfishTypes.createKey("badlands");
    public static final ResourceKey<SlabfishType> BAMBOO = EnvironmentalSlabfishTypes.createKey("bamboo");
    public static final ResourceKey<SlabfishType> BEACH = EnvironmentalSlabfishTypes.createKey("beach");
    public static final ResourceKey<SlabfishType> DARK_FOREST = EnvironmentalSlabfishTypes.createKey("dark_forest");
    public static final ResourceKey<SlabfishType> DESERT = EnvironmentalSlabfishTypes.createKey("desert");
    public static final ResourceKey<SlabfishType> FLOWER_FOREST = EnvironmentalSlabfishTypes.createKey("flower_forest");
    public static final ResourceKey<SlabfishType> FOREST = EnvironmentalSlabfishTypes.createKey("forest");
    public static final ResourceKey<SlabfishType> HILL = EnvironmentalSlabfishTypes.createKey("hill");
    public static final ResourceKey<SlabfishType> ICE_SPIKES = EnvironmentalSlabfishTypes.createKey("ice_spikes");
    public static final ResourceKey<SlabfishType> JUNGLE = EnvironmentalSlabfishTypes.createKey("jungle");
    public static final ResourceKey<SlabfishType> MANGROVE = EnvironmentalSlabfishTypes.createKey("mangrove");
    public static final ResourceKey<SlabfishType> MOUNTAIN = EnvironmentalSlabfishTypes.createKey("mountain");
    public static final ResourceKey<SlabfishType> PLAINS = EnvironmentalSlabfishTypes.createKey("plains");
    public static final ResourceKey<SlabfishType> RIVER = EnvironmentalSlabfishTypes.createKey("river");
    public static final ResourceKey<SlabfishType> SAVANNA = EnvironmentalSlabfishTypes.createKey("savanna");
    public static final ResourceKey<SlabfishType> SNOWY = EnvironmentalSlabfishTypes.createKey("snowy");
    public static final ResourceKey<SlabfishType> TAIGA = EnvironmentalSlabfishTypes.createKey("taiga");
    public static final ResourceKey<SlabfishType> CHERRY_GROVE = EnvironmentalSlabfishTypes.createKey("cherry_grove");
    public static final ResourceKey<SlabfishType> MARSH = EnvironmentalSlabfishTypes.createKey("marsh");
    public static final ResourceKey<SlabfishType> PINE = EnvironmentalSlabfishTypes.createKey("pine");
    public static final ResourceKey<SlabfishType> BLOSSOM = EnvironmentalSlabfishTypes.createKey("blossom");
    public static final ResourceKey<SlabfishType> RAINFOREST = EnvironmentalSlabfishTypes.createKey("rainforest");
    public static final ResourceKey<SlabfishType> DUNES = EnvironmentalSlabfishTypes.createKey("dunes");
    public static final ResourceKey<SlabfishType> SCRUBLAND = EnvironmentalSlabfishTypes.createKey("scrubland");
    public static final ResourceKey<SlabfishType> SPINY_THICKET = EnvironmentalSlabfishTypes.createKey("spiny_thicket");
    public static final ResourceKey<SlabfishType> ASPEN = EnvironmentalSlabfishTypes.createKey("aspen");
    public static final ResourceKey<SlabfishType> LAUREL = EnvironmentalSlabfishTypes.createKey("laurel");
    public static final ResourceKey<SlabfishType> KOUSA = EnvironmentalSlabfishTypes.createKey("kousa");
    public static final ResourceKey<SlabfishType> MAPLE = EnvironmentalSlabfishTypes.createKey("maple");
    public static final ResourceKey<SlabfishType> OCEAN = EnvironmentalSlabfishTypes.createKey("ocean");
    public static final ResourceKey<SlabfishType> WARM_OCEAN = EnvironmentalSlabfishTypes.createKey("warm_ocean");
    public static final ResourceKey<SlabfishType> FROZEN_OCEAN = EnvironmentalSlabfishTypes.createKey("frozen_ocean");
    public static final ResourceKey<SlabfishType> CAVE = EnvironmentalSlabfishTypes.createKey("cave");
    public static final ResourceKey<SlabfishType> DEEPSLATE = EnvironmentalSlabfishTypes.createKey("deepslate");
    public static final ResourceKey<SlabfishType> LUSH_CAVES = EnvironmentalSlabfishTypes.createKey("lush_caves");
    public static final ResourceKey<SlabfishType> DRIPSTONE_CAVES = EnvironmentalSlabfishTypes.createKey("dripstone_caves");
    public static final ResourceKey<SlabfishType> DEEP_DARK = EnvironmentalSlabfishTypes.createKey("deep_dark");
    public static final ResourceKey<SlabfishType> NETHER = EnvironmentalSlabfishTypes.createKey("nether");
    public static final ResourceKey<SlabfishType> CRIMSON = EnvironmentalSlabfishTypes.createKey("crimson");
    public static final ResourceKey<SlabfishType> WARPED = EnvironmentalSlabfishTypes.createKey("warped");
    public static final ResourceKey<SlabfishType> BASALT_DELTAS = EnvironmentalSlabfishTypes.createKey("basalt_deltas");
    public static final ResourceKey<SlabfishType> SOUL_SAND_VALLEY = EnvironmentalSlabfishTypes.createKey("soul_sand_valley");
    public static final ResourceKey<SlabfishType> GHOST = EnvironmentalSlabfishTypes.createKey("ghost");
    public static final ResourceKey<SlabfishType> END = EnvironmentalSlabfishTypes.createKey("end");
    public static final ResourceKey<SlabfishType> CHORUS = EnvironmentalSlabfishTypes.createKey("chorus");
    public static final ResourceKey<SlabfishType> POISE = EnvironmentalSlabfishTypes.createKey("poise");
    public static final ResourceKey<SlabfishType> MUSHROOM = EnvironmentalSlabfishTypes.createKey("mushroom");
    public static final ResourceKey<SlabfishType> BROWN_MUSHROOM = EnvironmentalSlabfishTypes.createKey("brown_mushroom");
    public static final ResourceKey<SlabfishType> DROWNED = EnvironmentalSlabfishTypes.createKey("drowned");
    public static final ResourceKey<SlabfishType> NIGHTMARE = EnvironmentalSlabfishTypes.createKey("nightmare");
    public static final ResourceKey<SlabfishType> SKY = EnvironmentalSlabfishTypes.createKey("sky");
    public static final ResourceKey<SlabfishType> SKELETON = EnvironmentalSlabfishTypes.createKey("skeleton");
    public static final ResourceKey<SlabfishType> STRAY = EnvironmentalSlabfishTypes.createKey("stray");
    public static final ResourceKey<SlabfishType> WITHER = EnvironmentalSlabfishTypes.createKey("wither");
    public static final ResourceKey<SlabfishType> TOTEM = EnvironmentalSlabfishTypes.createKey("totem");
    public static final List<ResourceKey<SlabfishType>> ATMOSPHERIC_SLABFISH = List.of(RAINFOREST, DUNES, SCRUBLAND, SPINY_THICKET, ASPEN, KOUSA, LAUREL);
    public static final List<ResourceKey<SlabfishType>> AUTUMNITY_SLABFISH = List.of(MAPLE);
    public static final List<ResourceKey<SlabfishType>> ENDERGETIC_SLABFISH = List.of(POISE);
    public static final List<ResourceKey<SlabfishType>> COMPAT_SLABFISH = Stream.concat(Stream.concat(ATMOSPHERIC_SLABFISH.stream(), AUTUMNITY_SLABFISH.stream()), ENDERGETIC_SLABFISH.stream()).collect(Collectors.toList());

    public static void bootstrap(BootstapContext<SlabfishType> context) {
        EnvironmentalSlabfishTypes.register(context, SWAMP, -1, (TagKey<Biome>)Tags.Biomes.IS_SWAMP);
        EnvironmentalSlabfishTypes.register(context, BADLANDS, 0, (TagKey<Biome>)BiomeTags.f_207607_);
        EnvironmentalSlabfishTypes.register(context, BEACH, 0, EnvironmentalSlabfishTypes.spawn(), EnvironmentalSlabfishTypes.or(EnvironmentalSlabfishTypes.biome(context, (TagKey<Biome>)BiomeTags.f_207604_), EnvironmentalSlabfishTypes.biome(context, (ResourceKey<Biome>)Biomes.f_186760_)));
        EnvironmentalSlabfishTypes.register(context, DESERT, 0, (ResourceKey<Biome>)Biomes.f_48203_);
        EnvironmentalSlabfishTypes.register(context, FOREST, 0, (TagKey<Biome>)BiomeTags.f_207611_);
        EnvironmentalSlabfishTypes.register(context, HILL, 0, (TagKey<Biome>)BiomeTags.f_207608_);
        EnvironmentalSlabfishTypes.register(context, JUNGLE, 0, (TagKey<Biome>)BiomeTags.f_207610_);
        EnvironmentalSlabfishTypes.register(context, OCEAN, 0, (TagKey<Biome>)BiomeTags.f_207603_);
        EnvironmentalSlabfishTypes.register(context, PLAINS, 0, (TagKey<Biome>)Tags.Biomes.IS_PLAINS);
        EnvironmentalSlabfishTypes.register(context, RIVER, 0, (ResourceKey<Biome>)Biomes.f_48208_);
        EnvironmentalSlabfishTypes.register(context, SAVANNA, 0, (TagKey<Biome>)BiomeTags.f_215816_);
        EnvironmentalSlabfishTypes.register(context, TAIGA, 0, (TagKey<Biome>)BiomeTags.f_207609_);
        EnvironmentalSlabfishTypes.register(context, WARM_OCEAN, 1, (ResourceKey<Biome>)Biomes.f_48166_);
        EnvironmentalSlabfishTypes.register(context, BAMBOO, 1, (ResourceKey<Biome>)Biomes.f_48197_);
        EnvironmentalSlabfishTypes.register(context, CHERRY_GROVE, 1, (ResourceKey<Biome>)Biomes.f_271432_);
        EnvironmentalSlabfishTypes.register(context, DARK_FOREST, 1, (ResourceKey<Biome>)Biomes.f_48151_);
        EnvironmentalSlabfishTypes.register(context, FLOWER_FOREST, 1, (ResourceKey<Biome>)Biomes.f_48179_);
        EnvironmentalSlabfishTypes.register(context, ICE_SPIKES, 1, (ResourceKey<Biome>)Biomes.f_48182_);
        EnvironmentalSlabfishTypes.register(context, MANGROVE, 1, (ResourceKey<Biome>)Biomes.f_220595_);
        EnvironmentalSlabfishTypes.register(context, MOUNTAIN, 1, EnvironmentalSlabfishTypes.spawn(), EnvironmentalSlabfishTypes.or(EnvironmentalSlabfishTypes.biome(context, (ResourceKey<Biome>)Biomes.f_186754_), EnvironmentalSlabfishTypes.biome(context, (ResourceKey<Biome>)Biomes.f_186759_)));
        EnvironmentalSlabfishTypes.register(context, SNOWY, 1, (TagKey<Biome>)Tags.Biomes.IS_SNOWY);
        EnvironmentalSlabfishTypes.register(context, FROZEN_OCEAN, 2, EnvironmentalSlabfishTypes.spawn(), EnvironmentalSlabfishTypes.or(EnvironmentalSlabfishTypes.biome(context, (ResourceKey<Biome>)Biomes.f_48211_), EnvironmentalSlabfishTypes.biome(context, (ResourceKey<Biome>)Biomes.f_48172_)));
        EnvironmentalSlabfishTypes.register(context, MUSHROOM, 2, EnvironmentalSlabfishTypes.or(EnvironmentalSlabfishTypes.and(EnvironmentalSlabfishTypes.spawn(), EnvironmentalSlabfishTypes.biome(context, (ResourceKey<Biome>)Biomes.f_48215_)), EnvironmentalSlabfishTypes.and(new SlabfishEventCondition(SlabfishConditionContext.Event.LIGHTNING), new SlabfishTypeCondition(BROWN_MUSHROOM.m_135782_()))));
        EnvironmentalSlabfishTypes.register(context, BROWN_MUSHROOM, 2, new SlabfishEventCondition(SlabfishConditionContext.Event.LIGHTNING), new SlabfishTypeCondition(MUSHROOM.m_135782_()));
        EnvironmentalSlabfishTypes.register(context, TOTEM, 3, EnvironmentalSlabfishTypes.spawn(), new SlabfishRaidCondition());
        EnvironmentalSlabfishTypes.register(context, NIGHTMARE, 3, EnvironmentalSlabfishTypes.spawn(), new SlabfishInsomniaCondition(), new SlabfishTimeCondition(SlabfishConditionContext.Time.NIGHT));
        EnvironmentalSlabfishTypes.register(context, CAVE, 4, EnvironmentalSlabfishTypes.spawn(), new SlabfishHeightCondition(0, 48), new SlabfishLightCondition(0, 0, LightLayer.SKY), EnvironmentalSlabfishTypes.overworld());
        EnvironmentalSlabfishTypes.register(context, DEEPSLATE, 4, EnvironmentalSlabfishTypes.spawn(), new SlabfishHeightCondition(Integer.MIN_VALUE, 0), new SlabfishLightCondition(0, 0, LightLayer.SKY), EnvironmentalSlabfishTypes.overworld());
        EnvironmentalSlabfishTypes.register(context, SKY, 4, EnvironmentalSlabfishTypes.spawn(), new SlabfishHeightCondition(256, Integer.MAX_VALUE), EnvironmentalSlabfishTypes.overworld());
        EnvironmentalSlabfishTypes.register(context, LUSH_CAVES, 5, (ResourceKey<Biome>)Biomes.f_151785_);
        EnvironmentalSlabfishTypes.register(context, DRIPSTONE_CAVES, 5, (ResourceKey<Biome>)Biomes.f_151784_);
        EnvironmentalSlabfishTypes.register(context, DEEP_DARK, 5, (ResourceKey<Biome>)Biomes.f_220594_);
        EnvironmentalSlabfishTypes.register(context, DROWNED, 10, EnvironmentalSlabfishTypes.spawn(), EnvironmentalSlabfishTypes.biome(context, (TagKey<Biome>)BiomeTags.f_207603_), new SlabfishHeightCondition(Integer.MIN_VALUE, 48), new SlabfishInFluidCondition((HolderSet<Fluid>)context.m_255420_(Registries.f_256808_).m_254956_(FluidTags.f_13131_)));
        EnvironmentalSlabfishTypes.register(context, SKELETON, 10, new SlabfishEventCondition(SlabfishConditionContext.Event.LIGHTNING));
        EnvironmentalSlabfishTypes.register(context, STRAY, 10, new SlabfishEventCondition(SlabfishConditionContext.Event.BREED), new SlabfishBreedCondition(SKELETON.m_135782_(), SKELETON.m_135782_()), EnvironmentalSlabfishTypes.biome(context, (TagKey<Biome>)Tags.Biomes.IS_SNOWY));
        EnvironmentalSlabfishTypes.register(context, WITHER, 10, new SlabfishEventCondition(SlabfishConditionContext.Event.BREED), new SlabfishBreedCondition(SKELETON.m_135782_(), SKELETON.m_135782_()), EnvironmentalSlabfishTypes.dimension((ResourceKey<DimensionType>)BuiltinDimensionTypes.f_223539_));
        EnvironmentalSlabfishTypes.register(context, BLOSSOM, 1, EnvironmentalSlabfishTypes.spawn(), EnvironmentalSlabfishTypes.or(EnvironmentalSlabfishTypes.biome(context, EnvironmentalBiomes.BLOSSOM_WOODS), EnvironmentalSlabfishTypes.biome(context, EnvironmentalBiomes.BLOSSOM_VALLEYS)));
        EnvironmentalSlabfishTypes.register(context, MARSH, 1, EnvironmentalBiomes.MARSH);
        EnvironmentalSlabfishTypes.register(context, PINE, 1, EnvironmentalSlabfishTypes.spawn(), EnvironmentalSlabfishTypes.or(EnvironmentalSlabfishTypes.biome(context, EnvironmentalBiomeTags.IS_PINE_BARRENS), EnvironmentalSlabfishTypes.biome(context, EnvironmentalBiomes.PINE_SLOPES)));
        EnvironmentalSlabfishTypes.register(context, DUNES, 0, "atmospheric", EnvironmentalBiomeTags.IS_DUNES);
        EnvironmentalSlabfishTypes.register(context, RAINFOREST, 1, "atmospheric", EnvironmentalBiomeTags.IS_RAINFOREST);
        EnvironmentalSlabfishTypes.register(context, ASPEN, 1, "atmospheric", EnvironmentalConstants.ASPEN_PARKLAND);
        EnvironmentalSlabfishTypes.register(context, LAUREL, 1, "atmospheric", EnvironmentalConstants.LAUREL_FOREST);
        EnvironmentalSlabfishTypes.register(context, SPINY_THICKET, 1, "atmospheric", EnvironmentalConstants.SPINY_THICKET);
        EnvironmentalSlabfishTypes.register(context, KOUSA, 2, "atmospheric", EnvironmentalConstants.KOUSA_JUNGLE);
        EnvironmentalSlabfishTypes.register(context, SCRUBLAND, 2, EnvironmentalSlabfishTypes.modLoaded("atmospheric"), EnvironmentalSlabfishTypes.spawn(), EnvironmentalSlabfishTypes.or(EnvironmentalSlabfishTypes.biome(EnvironmentalConstants.SCRUBLAND), EnvironmentalSlabfishTypes.biome(EnvironmentalConstants.SNOWY_SCRUBLAND)));
        EnvironmentalSlabfishTypes.register(context, MAPLE, 1, EnvironmentalSlabfishTypes.modLoaded("autumnity"), EnvironmentalSlabfishTypes.spawn(), EnvironmentalSlabfishTypes.or(EnvironmentalSlabfishTypes.biome(EnvironmentalConstants.MAPLE_FOREST), EnvironmentalSlabfishTypes.biome(EnvironmentalConstants.PUMPKIN_FIELDS)));
        EnvironmentalSlabfishTypes.register(context, NETHER, 0, EnvironmentalSlabfishTypes.spawn(), EnvironmentalSlabfishTypes.dimension((ResourceKey<DimensionType>)BuiltinDimensionTypes.f_223539_));
        EnvironmentalSlabfishTypes.register(context, CRIMSON, 1, (ResourceKey<Biome>)Biomes.f_48200_);
        EnvironmentalSlabfishTypes.register(context, WARPED, 1, (ResourceKey<Biome>)Biomes.f_48201_);
        EnvironmentalSlabfishTypes.register(context, SOUL_SAND_VALLEY, 1, (ResourceKey<Biome>)Biomes.f_48199_);
        EnvironmentalSlabfishTypes.register(context, BASALT_DELTAS, 1, (ResourceKey<Biome>)Biomes.f_48175_);
        EnvironmentalSlabfishTypes.register(context, GHOST, 0, new SlabfishImpossibleCondition());
        EnvironmentalSlabfishTypes.register(context, END, 0, EnvironmentalSlabfishTypes.spawn(), EnvironmentalSlabfishTypes.dimension((ResourceKey<DimensionType>)BuiltinDimensionTypes.f_223540_));
        EnvironmentalSlabfishTypes.register(context, CHORUS, 1, (TagKey<Biome>)BlueprintBiomeTags.IS_OUTER_END);
        EnvironmentalSlabfishTypes.register(context, POISE, 1, "endergetic", EnvironmentalConstants.POISE_FOREST);
    }

    public static void register(BootstapContext<SlabfishType> context, ResourceKey<SlabfishType> key, int priority, SlabfishCondition ... conditions) {
        context.m_255272_(key, (Object)new SlabfishType((Component)Component.m_237115_((String)Util.m_137492_((String)"slabfish.type", (ResourceLocation)key.m_135782_())), new ResourceLocation(key.m_135782_().m_135827_(), "type/" + key.m_135782_().m_135815_()), Optional.empty(), priority, (SlabfishCondition[])Arrays.stream(conditions).toArray(SlabfishCondition[]::new)));
    }

    public static void register(BootstapContext<SlabfishType> context, ResourceKey<SlabfishType> key, int priority, TagKey<Biome> biomes) {
        EnvironmentalSlabfishTypes.register(context, key, priority, EnvironmentalSlabfishTypes.spawn(), EnvironmentalSlabfishTypes.biome(context, biomes));
    }

    public static void register(BootstapContext<SlabfishType> context, ResourceKey<SlabfishType> key, int priority, ResourceKey<Biome> biome) {
        EnvironmentalSlabfishTypes.register(context, key, priority, EnvironmentalSlabfishTypes.spawn(), EnvironmentalSlabfishTypes.biome(context, biome));
    }

    public static void register(BootstapContext<SlabfishType> context, ResourceKey<SlabfishType> key, int priority, String modid, TagKey<Biome> biomes) {
        EnvironmentalSlabfishTypes.register(context, key, priority, EnvironmentalSlabfishTypes.modLoaded(modid), EnvironmentalSlabfishTypes.spawn(), EnvironmentalSlabfishTypes.biome(context, biomes));
    }

    public static void register(BootstapContext<SlabfishType> context, ResourceKey<SlabfishType> key, int priority, String modid, ResourceLocation biome) {
        EnvironmentalSlabfishTypes.register(context, key, priority, EnvironmentalSlabfishTypes.modLoaded(modid), EnvironmentalSlabfishTypes.spawn(), EnvironmentalSlabfishTypes.biome(biome));
    }

    public static SlabfishEventCondition spawn() {
        return new SlabfishEventCondition(SlabfishConditionContext.Event.SPAWN, SlabfishConditionContext.Event.BREED);
    }

    public static SlabfishOrCondition or(SlabfishCondition ... conditions) {
        return new SlabfishOrCondition(conditions);
    }

    public static SlabfishAndCondition and(SlabfishCondition ... conditions) {
        return new SlabfishAndCondition(conditions);
    }

    public static SlabfishInBiomeCondition biome(BootstapContext<SlabfishType> context, ResourceKey<Biome> biome) {
        return new SlabfishInBiomeCondition((HolderSet<Biome>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256952_).m_255043_(biome)}));
    }

    public static SlabfishInBiomeCondition biome(BootstapContext<SlabfishType> context, TagKey<Biome> biomes) {
        return new SlabfishInBiomeCondition((HolderSet<Biome>)context.m_255420_(Registries.f_256952_).m_254956_(biomes));
    }

    public static SlabfishInBiomeKeyCondition biome(ResourceLocation biome) {
        return new SlabfishInBiomeKeyCondition(biome);
    }

    public static SlabfishDimensionCondition dimension(ResourceKey<DimensionType> dimension) {
        return new SlabfishDimensionCondition(dimension.m_135782_());
    }

    public static SlabfishDimensionCondition overworld() {
        return EnvironmentalSlabfishTypes.dimension((ResourceKey<DimensionType>)BuiltinDimensionTypes.f_223538_);
    }

    public static SlabfishModLoadedCondition modLoaded(String modid) {
        return new SlabfishModLoadedCondition(modid);
    }

    public static ResourceKey<SlabfishType> createKey(String name) {
        return ResourceKey.m_135785_(EnvironmentalRegistries.SLABFISH_TYPE, (ResourceLocation)new ResourceLocation("environmental", name));
    }
}

