/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.other;

import com.google.common.collect.Sets;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.blueprint.core.util.MathUtil;
import com.teamabnormals.environmental.common.block.GiantLilyPadBlock;
import com.teamabnormals.environmental.common.block.LargeLilyPadBlock;
import com.teamabnormals.environmental.common.entity.ai.goal.CatLeapAtDwarfSpruceGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.HuntTruffleGoal;
import com.teamabnormals.environmental.common.entity.animal.koi.Koi;
import com.teamabnormals.environmental.common.entity.animal.slabfish.Slabfish;
import com.teamabnormals.environmental.common.entity.animal.slabfish.SlabfishOverlay;
import com.teamabnormals.environmental.core.EnvironmentalConfig;
import com.teamabnormals.environmental.core.other.EnvironmentalCriteriaTriggers;
import com.teamabnormals.environmental.core.other.EnvironmentalDataProcessors;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBlockTags;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalEntityTypeTags;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalItemTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.environmental.core.registry.EnvironmentalMobEffects;
import com.teamabnormals.environmental.core.registry.EnvironmentalParticleTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import com.teamabnormals.environmental.core.registry.slabfish.EnvironmentalSlabfishTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="environmental")
public class EnvironmentalEvents {
    public static final List<MobSpawnType> VALID_SPAWNS = List.of(MobSpawnType.NATURAL, MobSpawnType.CHUNK_GENERATION, MobSpawnType.JOCKEY, MobSpawnType.REINFORCEMENT, MobSpawnType.PATROL);
    protected static final Set<Block> DIRT_SPREADABLES = Sets.newHashSet((Object[])new Block[]{Blocks.f_50440_, Blocks.f_50195_});

    @SubscribeEvent
    public static void onLivingSpawn(MobSpawnEvent.FinalizeSpawn event) {
        boolean spawner;
        Mob entity = event.getEntity();
        ServerLevelAccessor level = event.getLevel();
        boolean natural = VALID_SPAWNS.contains(event.getSpawnType());
        boolean bl = spawner = (Boolean)EnvironmentalConfig.COMMON.blockOnlyNaturalSpawns.get() == false && event.getSpawnType() == MobSpawnType.SPAWNER;
        if ((natural || spawner) && entity.m_6095_().m_20674_() == MobCategory.MONSTER && !entity.m_6095_().m_204039_(EnvironmentalEntityTypeTags.UNAFFECTED_BY_SERENITY)) {
            int horizontalRange = (Integer)EnvironmentalConfig.COMMON.koiHorizontalSerenityRange.get();
            int verticalRange = (Integer)EnvironmentalConfig.COMMON.koiVerticalSerenityRange.get();
            for (Koi koi : level.m_45976_(Koi.class, entity.m_20191_().m_82377_((double)horizontalRange, (double)verticalRange, (double)horizontalRange))) {
                if (!(MathUtil.distanceBetweenPoints2d((double)entity.m_20185_(), (double)entity.m_20189_(), (double)koi.m_20185_(), (double)koi.m_20189_()) <= (double)horizontalRange)) continue;
                event.setSpawnCancelled(true);
                event.setResult(Event.Result.DENY);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onEndermanPlaceBlock(EntityMobGriefingEvent event) {
        EnderMan enderman;
        Entity entity = event.getEntity();
        if (entity instanceof EnderMan && (enderman = (EnderMan)entity).m_21023_((MobEffect)EnvironmentalMobEffects.SERENITY.get())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        List list;
        Entity itemstack;
        Entity entity = event.getEntity();
        if (entity instanceof ThrownPotion) {
            ThrownPotion thrownPotion = (ThrownPotion)entity;
            itemstack = thrownPotion.m_7846_();
            Potion potion = PotionUtils.m_43579_((ItemStack)itemstack);
            list = PotionUtils.m_43547_((ItemStack)itemstack);
            if (potion == Potions.f_43599_ && list.isEmpty()) {
                AABB axisalignedbb = thrownPotion.m_20191_().m_82377_(2.0, 1.0, 2.0);
                List slabs = thrownPotion.m_9236_().m_45976_(Slabfish.class, axisalignedbb);
                if (!slabs.isEmpty()) {
                    for (Slabfish slabfish : slabs) {
                        slabfish.setSlabfishOverlay(SlabfishOverlay.NONE);
                    }
                }
            }
        }
        if ((itemstack = event.getEntity()) instanceof ThrowableItemProjectile) {
            EntityHitResult entity2;
            ThrowableItemProjectile projectile = (ThrowableItemProjectile)itemstack;
            if (event.getRayTraceResult() != null && event.getRayTraceResult().m_6662_() == HitResult.Type.ENTITY && (list = (entity2 = (EntityHitResult)event.getRayTraceResult()).m_82443_()) instanceof Slabfish) {
                Slabfish slabfish = (Slabfish)((Object)list);
                ItemStack stack = projectile.m_7846_();
                if (stack.m_150930_(Items.f_42452_)) {
                    slabfish.setSlabfishOverlay(SlabfishOverlay.SNOWY);
                } else if (stack.m_204117_(Tags.Items.EGGS)) {
                    slabfish.setSlabfishOverlay(SlabfishOverlay.EGG);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        Direction face = event.getFace();
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        if (stack.canPerformAction(ToolActions.SHOVEL_DIG) && !player.m_5833_() && state.m_60713_((Block)EnvironmentalBlocks.BURIED_TRUFFLE.get())) {
            level.m_5594_(player, pos, (SoundEvent)EnvironmentalSoundEvents.SHOVEL_DIG.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.m_5776_()) {
                Vec3i vector3i = face.m_122436_();
                double d0 = (double)pos.m_123341_() + 0.5 + 0.625 * (double)vector3i.m_123341_();
                double d1 = (double)pos.m_123342_() + 0.375 + 0.625 * (double)vector3i.m_123342_();
                double d2 = (double)pos.m_123343_() + 0.5 + 0.625 * (double)vector3i.m_123343_();
                ItemEntity itementity = new ItemEntity(level, d0, d1, d2, new ItemStack((ItemLike)EnvironmentalItems.TRUFFLE.get(), 1));
                level.m_7967_((Entity)itementity);
                stack.m_41622_(1, (LivingEntity)player, damage -> damage.m_21190_(event.getHand()));
                level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 11);
            }
            event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
            event.setCanceled(true);
        } else if (stack.canPerformAction(ToolActions.HOE_TILL) && state.m_60713_((Block)EnvironmentalBlocks.DIRT_PATH.get()) && !player.m_5833_() && level.m_46859_(pos.m_7494_())) {
            level.m_5594_(player, pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.m_5776_()) {
                stack.m_41622_(1, (LivingEntity)player, damage -> damage.m_21190_(event.getHand()));
                level.m_7731_(pos, Blocks.f_50093_.m_49966_(), 11);
            }
            event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
            event.setCanceled(true);
        } else if (event.getFace() != Direction.DOWN && stack.canPerformAction(ToolActions.SHOVEL_FLATTEN) && !player.m_5833_() && level.m_46859_(pos.m_7494_()) && (state.m_60713_(Blocks.f_50599_) || state.m_60713_(Blocks.f_50195_) || state.m_60713_(Blocks.f_50493_) || state.m_60713_(Blocks.f_50546_) || state.m_60713_(Blocks.f_152549_))) {
            level.m_5594_(player, pos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.f_46443_) {
                stack.m_41622_(1, (LivingEntity)player, damage -> damage.m_21190_(event.getHand()));
                level.m_7731_(pos, state.m_60713_(Blocks.f_50599_) ? ((Block)EnvironmentalBlocks.PODZOL_PATH.get()).m_49966_() : (state.m_60713_(Blocks.f_50195_) ? ((Block)EnvironmentalBlocks.MYCELIUM_PATH.get()).m_49966_() : ((Block)EnvironmentalBlocks.DIRT_PATH.get()).m_49966_()), 11);
            }
            event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        Entity target = event.getTarget();
        Level level = event.getLevel();
        RandomSource random = level.m_213780_();
        if (target instanceof Pig) {
            Pig pig = (Pig)target;
            if (target.m_6084_()) {
                IDataManager data = (IDataManager)target;
                if (!pig.m_21523_() && stack.m_204117_(EnvironmentalItemTags.PIG_TRUFFLE_ITEMS) && !pig.m_6162_() && ((Boolean)EnvironmentalConfig.COMMON.pigsHuntTruffles.get()).booleanValue() && (Integer)data.getValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME) == 0) {
                    if (level.m_6042_().f_63858_()) {
                        data.setValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME, (Object)4800);
                        if (!event.getEntity().m_7500_()) {
                            stack.m_41774_(1);
                        }
                        if (level.m_5776_()) {
                            for (int i = 0; i < 7; ++i) {
                                double d0 = random.m_188583_() * 0.02;
                                double d1 = random.m_188583_() * 0.02;
                                double d2 = random.m_188583_() * 0.02;
                                level.m_7106_((ParticleOptions)EnvironmentalParticleTypes.PIG_FINDS_TRUFFLE.get(), target.m_20208_(1.0), target.m_20187_() + 0.5, target.m_20262_(1.0), d0, d1, d2);
                            }
                        }
                    } else if (level.m_5776_()) {
                        for (int i = 0; i < 7; ++i) {
                            double d0 = random.m_188583_() * 0.02;
                            double d1 = random.m_188583_() * 0.02;
                            double d2 = random.m_188583_() * 0.02;
                            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, target.m_20208_(1.0), target.m_20187_() + 0.5, target.m_20262_(1.0), d0, d1, d2);
                        }
                    }
                    event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        LivingEntity livingEntity;
        Pig pig;
        LivingEntity livingEntity2 = event.getEntity();
        if (livingEntity2 instanceof Pig && (pig = (Pig)livingEntity2).m_217005_() && event.getDistance() > 3.75f && (livingEntity = pig.m_6688_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            EnvironmentalCriteriaTriggers.WHEN_PIGS_FLY.trigger(player);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Level world = entity.m_20193_();
        RandomSource rand = RandomSource.m_216327_();
        if (entity instanceof Slabfish) {
            Slabfish slabfish = (Slabfish)entity;
            if (world.m_204166_(entity.m_20183_()).m_203565_(Biomes.f_48199_) && !slabfish.getSlabfishType().equals(EnvironmentalSlabfishTypes.GHOST.m_135782_())) {
                if (world.m_5776_()) {
                    for (int i = 0; i < 7; ++i) {
                        double d0 = rand.m_188583_() * 0.02;
                        double d1 = rand.m_188583_() * 0.02;
                        double d2 = rand.m_188583_() * 0.02;
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123746_, entity.m_20208_(1.0), entity.m_20187_() + 0.5, entity.m_20262_(1.0), d0, d1, d2);
                    }
                }
                if (!world.m_5776_()) {
                    Slabfish ghost = (Slabfish)((EntityType)EnvironmentalEntityTypes.SLABFISH.get()).m_20615_(world);
                    if (ghost == null) {
                        return;
                    }
                    ghost.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 140, 0, false, false));
                    ghost.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 140, 0, false, false));
                    world.m_5594_(null, entity.m_20183_(), SoundEvents.f_11887_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    ghost.m_6034_(slabfish.m_20185_(), slabfish.m_20186_(), slabfish.m_20189_());
                    ghost.m_7678_(slabfish.m_20185_(), slabfish.m_20186_(), slabfish.m_20189_(), slabfish.m_146908_(), slabfish.m_146909_());
                    ghost.m_21557_(slabfish.m_21525_());
                    ghost.m_146762_(slabfish.m_146764_());
                    ghost.setSlabfishTypeFromLocation(EnvironmentalSlabfishTypes.GHOST.m_135782_());
                    ghost.m_20254_(0);
                    if (slabfish.m_8077_()) {
                        ghost.m_6593_(entity.m_7770_());
                        ghost.m_20340_(entity.m_20151_());
                    }
                    world.m_7967_((Entity)ghost);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBabySpawn(BabyEntitySpawnEvent event) {
        Pig baby;
        int i;
        int piglets;
        int minBonus;
        Mob level;
        Mob mob = event.getParentA();
        if (mob instanceof Pig) {
            Pig pig = (Pig)mob;
            if (event.getParentB() instanceof Pig && ((Boolean)EnvironmentalConfig.COMMON.largerPigLitters.get()).booleanValue()) {
                level = pig.m_9236_();
                minBonus = (Integer)EnvironmentalConfig.COMMON.minimumAdditionalPiglets.get();
                piglets = minBonus + level.f_46441_.m_188503_((Integer)EnvironmentalConfig.COMMON.maximumAdditionalPiglets.get() + 1 - minBonus);
                for (i = 0; i < piglets; ++i) {
                    baby = (Pig)EntityType.f_20510_.m_20615_((Level)level);
                    if (baby == null) continue;
                    baby.m_6863_(true);
                    baby.m_7678_(pig.m_20185_(), pig.m_20186_(), pig.m_20189_(), 0.0f, 0.0f);
                    level.m_7967_((Entity)baby);
                }
            }
        }
        if ((level = event.getParentA()) instanceof Hoglin) {
            Hoglin hoglin = (Hoglin)level;
            if (event.getParentB() instanceof Hoglin && ((Boolean)EnvironmentalConfig.COMMON.largerHoglinLitters.get()).booleanValue()) {
                level = hoglin.m_9236_();
                minBonus = (Integer)EnvironmentalConfig.COMMON.minimumAdditionalHoglets.get();
                piglets = minBonus + level.f_46441_.m_188503_((Integer)EnvironmentalConfig.COMMON.maximumAdditionalHoglets.get() + 1 - minBonus);
                for (i = 0; i < piglets; ++i) {
                    baby = (Hoglin)EntityType.f_20456_.m_20615_((Level)level);
                    if (baby == null) continue;
                    baby.m_6863_(true);
                    baby.m_7678_(hoglin.m_20185_(), hoglin.m_20186_(), hoglin.m_20189_(), 0.0f, 0.0f);
                    level.m_7967_((Entity)baby);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            wolf.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)wolf, Animal.class, false, target -> {
                EntityType type = target.m_6095_();
                return type == EnvironmentalEntityTypes.DEER.get() || type == EnvironmentalEntityTypes.TAPIR.get() || type == EnvironmentalEntityTypes.REINDEER.get();
            }));
        }
        if (entity instanceof Ocelot) {
            Ocelot ocelot = (Ocelot)entity;
            ocelot.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)ocelot, Animal.class, 10, false, false, targetEntity -> targetEntity.m_6095_() == EnvironmentalEntityTypes.DUCK.get()));
        }
        if (entity instanceof Cat) {
            Cat cat = (Cat)entity;
            cat.f_21346_.m_25352_(8, (Goal)new CatLeapAtDwarfSpruceGoal(cat));
        }
        if (entity instanceof Pig) {
            Set goals;
            Pig pig = (Pig)entity;
            if (((Boolean)EnvironmentalConfig.COMMON.pigsHuntTruffles.get()).booleanValue() && (goals = pig.f_21345_.f_25345_).stream().noneMatch(goal -> goal.m_26015_() instanceof HuntTruffleGoal)) {
                pig.f_21345_.m_25352_(2, (Goal)new HuntTruffleGoal(pig));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.m_20193_();
        RandomSource random = level.m_213780_();
        if (entity instanceof Pig && entity.m_6084_()) {
            IDataManager data = (IDataManager)entity;
            int huntingtime = (Integer)data.getValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME);
            BlockPos trufflepos = (BlockPos)data.getValue(EnvironmentalDataProcessors.TRUFFLE_POS);
            if (huntingtime == 0 || ((Boolean)data.getValue(EnvironmentalDataProcessors.HAS_TRUFFLE_TARGET)).booleanValue() && level.m_8055_(trufflepos).m_60734_() != EnvironmentalBlocks.BURIED_TRUFFLE.get()) {
                data.setValue(EnvironmentalDataProcessors.HAS_TRUFFLE_TARGET, (Object)false);
                if (huntingtime > 0) {
                    data.setValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME, (Object)Math.max(-400, -huntingtime));
                }
            } else if (huntingtime > 0) {
                data.setValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME, (Object)(huntingtime - 1));
            } else {
                data.setValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME, (Object)(huntingtime + 1));
                if (level.m_5776_() && ((Boolean)data.getValue(EnvironmentalDataProcessors.HAS_TRUFFLE_TARGET)).booleanValue() && huntingtime % 10 == 0) {
                    double d0 = random.m_188583_() * 0.02;
                    double d1 = random.m_188583_() * 0.02;
                    double d2 = random.m_188583_() * 0.02;
                    level.m_7106_((ParticleOptions)EnvironmentalParticleTypes.PIG_FINDS_TRUFFLE.get(), entity.m_20208_(1.0), entity.m_20187_() + 0.5, entity.m_20262_(1.0), d0, d1, d2);
                }
            }
            int sniffsoundtime = (Integer)data.getValue(EnvironmentalDataProcessors.SNIFF_SOUND_TIME);
            data.setValue(EnvironmentalDataProcessors.SNIFF_SOUND_TIME, (Object)(sniffsoundtime + 1));
            if (!level.m_5776_() && ((Boolean)data.getValue(EnvironmentalDataProcessors.LOOKING_FOR_TRUFFLE)).booleanValue() && random.m_188503_(60) < sniffsoundtime) {
                entity.m_5496_((SoundEvent)EnvironmentalSoundEvents.PIG_SNIFF.get(), 1.0f, (random.m_188501_() - random.m_188501_()) * 0.2f + 1.0f);
                data.setValue(EnvironmentalDataProcessors.SNIFF_SOUND_TIME, (Object)-20);
            }
        }
    }

    @SubscribeEvent
    public static void onBonemeal(BonemealEvent event) {
        Level level = event.getLevel();
        BlockState state = event.getBlock();
        BlockPos pos = event.getPos();
        RandomSource random = level.m_213780_();
        if (((Boolean)EnvironmentalConfig.COMMON.cactusBobble.get()).booleanValue() && state.m_204336_(EnvironmentalBlockTags.CACTUS_BOBBLE_PLANTABLE_ON) && level.m_8055_(pos.m_7494_()).m_60795_()) {
            if (!level.m_5776_()) {
                level.m_46597_(pos.m_7494_(), ((Block)EnvironmentalBlocks.CACTUS_BOBBLE.get()).m_49966_());
            }
            event.setResult(Event.Result.ALLOW);
        }
        if (state.m_60713_(Blocks.f_50493_) && level.m_8055_(pos.m_7494_()).m_60631_((BlockGetter)level, pos)) {
            ArrayList<BlockState> potentialStates = new ArrayList<BlockState>();
            for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-1, -1, -1), (BlockPos)pos.m_7918_(1, 1, 1))) {
                Block block = level.m_8055_(blockpos).m_60734_();
                if (!DIRT_SPREADABLES.contains(block) || potentialStates.contains(block.m_49966_())) continue;
                potentialStates.add(block.m_49966_());
            }
            if (!potentialStates.isEmpty()) {
                if (!level.m_5776_()) {
                    level.m_7731_(pos, (BlockState)potentialStates.get(level.m_213780_().m_188503_(potentialStates.size())), 3);
                }
                event.setResult(Event.Result.ALLOW);
            }
        }
        if (state.m_60713_(Blocks.f_50195_) && level.m_8055_(pos.m_7494_()).m_60795_()) {
            if (!level.m_5776_()) {
                BlockPos abovePos = pos.m_7494_();
                for (int i = 0; i < 128; ++i) {
                    BlockPos newPos = abovePos;
                    for (int j = 0; j < i / 16 && level.m_8055_((newPos = newPos.m_7918_(random.m_188503_(3) - 1, (random.m_188503_(3) - 1) * random.m_188503_(3) / 2, random.m_188503_(3) - 1)).m_7495_()).m_60713_(Blocks.f_50195_) && !level.m_8055_(newPos).m_60838_((BlockGetter)level, newPos); ++j) {
                    }
                    if (!level.m_8055_(newPos).m_60795_() || !((Block)EnvironmentalBlocks.MYCELIUM_SPROUTS.get()).m_49966_().m_60710_((LevelReader)level, newPos)) continue;
                    level.m_7731_(newPos, ((Block)EnvironmentalBlocks.MYCELIUM_SPROUTS.get()).m_49966_(), 3);
                }
            }
            event.setResult(Event.Result.ALLOW);
        }
        if (event.getBlock().m_60713_(Blocks.f_50359_)) {
            if (!level.m_5776_()) {
                DoublePlantBlock.m_153173_((LevelAccessor)level, (BlockState)((Block)EnvironmentalBlocks.GIANT_TALL_GRASS.get()).m_49966_(), (BlockPos)(state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.LOWER ? pos : pos.m_7495_()), (int)2);
            }
            event.setResult(Event.Result.ALLOW);
        }
        if (state.m_60713_(Blocks.f_50196_)) {
            if (!level.m_5776_() && random.m_188503_(3) == 0) {
                if (random.m_188499_()) {
                    if (LargeLilyPadBlock.checkPositions(level, pos, ((Block)EnvironmentalBlocks.LARGE_LILY_PAD.get()).m_49966_())) {
                        LargeLilyPadBlock.placeAt(level, pos, ((Block)EnvironmentalBlocks.LARGE_LILY_PAD.get()).m_49966_(), 3);
                    }
                } else if (GiantLilyPadBlock.checkPositions(level, pos, ((Block)EnvironmentalBlocks.GIANT_LILY_PAD.get()).m_49966_())) {
                    GiantLilyPadBlock.placeAt(level, pos, ((Block)EnvironmentalBlocks.GIANT_LILY_PAD.get()).m_49966_(), 3);
                }
            }
            event.setResult(Event.Result.ALLOW);
        }
    }
}

