/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.data.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.teamabnormals.environmental.common.block.CattailBlock;
import com.teamabnormals.environmental.common.block.CupLichenBlock;
import com.teamabnormals.environmental.common.block.DwarfSpruceHeadBlock;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class EnvironmentalLootTableProvider
extends LootTableProvider {
    public EnvironmentalLootTableProvider(PackOutput output) {
        super(output, BuiltInLootTables.m_78766_(), (List)ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(EnvironmentalBlockLoot::new, LootContextParamSets.f_81421_), (Object)new LootTableProvider.SubProviderEntry(EnvironmentalEntityLoot::new, LootContextParamSets.f_81415_), (Object)new LootTableProvider.SubProviderEntry(EnvironmentalChestLoot::new, LootContextParamSets.f_81411_)));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext context) {
    }

    private static class EnvironmentalChestLoot
    implements LootTableSubProvider {
        private EnvironmentalChestLoot() {
        }

        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(new ResourceLocation("environmental", "chests/log_cabin_junk"), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)6.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)6.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalBlocks.DWARF_SPRUCE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalBlocks.PINE_PLANKS.get())).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)6.0f, (float)12.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalBlocks.PINE_LOG.get())).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)6.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalBlocks.STRIPPED_PINE_LOG.get())).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)6.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalBlocks.PINE_LEAVES.get())).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)8.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)3.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42778_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42618_).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalBlocks.PINE_TRAPDOOR.get())).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalBlocks.PINE_SAPLING.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalBlocks.PINECONE.get())).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
            consumer.accept(new ResourceLocation("environmental", "chests/log_cabin"), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42428_).m_79707_(3).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42386_))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42574_).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.8f, (float)1.0f))).m_79078_((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().m_80444_(Enchantments.f_44986_))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42574_).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.5f, (float)0.8f))).m_79078_((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().m_80444_(Enchantments.f_44986_)).m_79078_((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().m_80444_(Enchantments.f_44984_)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42409_).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.5f, (float)0.8f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalItems.LUMBERER_BANNER_PATTERN.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalItems.HELPER_BANNER_PATTERN.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)5.0f, (float)6.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42583_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)6.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42413_).m_79707_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42454_).m_79707_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalItems.VENISON.get())).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalItems.COOKED_VENISON.get())).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42649_).m_79707_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42697_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42698_).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42781_).m_79707_(4))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42407_).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42408_).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42462_).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42463_).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42407_).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42408_).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42462_).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42463_).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_()))));
            consumer.accept(new ResourceLocation("environmental", "chests/log_cabin_dispenser"), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42047_))));
            consumer.accept(new ResourceLocation("environmental", "chests/log_cabin_dropper"), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalBlocks.PINE_SAPLING.get())))));
        }
    }

    private static class EnvironmentalEntityLoot
    extends EntityLootSubProvider {
        private static final Set<EntityType<?>> SPECIAL_LOOT_TABLE_TYPES = ImmutableSet.of((Object)((EntityType)EnvironmentalEntityTypes.PINECONE_GOLEM.get()));

        protected EnvironmentalEntityLoot() {
            super(FeatureFlags.f_244280_.m_247355_());
        }

        public void m_246942_() {
            this.m_245309_((EntityType)EnvironmentalEntityTypes.DEER.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42454_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalItems.VENISON.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_244460_))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_245309_((EntityType)EnvironmentalEntityTypes.REINDEER.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42454_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalItems.VENISON.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_244460_))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_245309_((EntityType)EnvironmentalEntityTypes.DUCK.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42402_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalItems.DUCK.get())).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_244460_))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_245309_((EntityType)EnvironmentalEntityTypes.KOI.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalItems.KOI.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42499_)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.05f))));
            this.m_245309_((EntityType)EnvironmentalEntityTypes.SLABFISH.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)EnvironmentalEntityTypes.TAPIR.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)EnvironmentalEntityTypes.YAK.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalItems.YAK_HAIR.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)5.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42579_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_244460_))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_245309_((EntityType)EnvironmentalEntityTypes.ZEBRA.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42454_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_245309_((EntityType)EnvironmentalEntityTypes.ZORSE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42454_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_245309_((EntityType)EnvironmentalEntityTypes.ZONKEY.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42454_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_245309_((EntityType)EnvironmentalEntityTypes.PINECONE_GOLEM.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalBlocks.PINE_SAPLING.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
            this.m_245309_(EntityType.f_20494_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalItems.MUSIC_DISC_LEAVING_HOME.get()))).m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_204077_(EntityTypeTags.f_13120_)))));
        }

        public Stream<EntityType<?>> getKnownEntityTypes() {
            return ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(entity -> ForgeRegistries.ENTITY_TYPES.getKey(entity).m_135827_().equals("environmental") || entity == EntityType.f_20494_);
        }

        protected boolean m_245552_(EntityType<?> entityType) {
            return SPECIAL_LOOT_TABLE_TYPES.contains(entityType) || entityType.m_20674_() != MobCategory.MISC;
        }
    }

    public static class EnvironmentalBlockLoot
    extends BlockLootSubProvider {
        private static final Set<Item> EXPLOSION_RESISTANT = Stream.of(Blocks.f_50260_, Blocks.f_50273_, Blocks.f_50569_, Blocks.f_50310_, Blocks.f_50312_, Blocks.f_50316_, Blocks.f_50314_, Blocks.f_50318_, Blocks.f_50320_, Blocks.f_260630_, Blocks.f_50456_, Blocks.f_50525_, Blocks.f_50521_, Blocks.f_50522_, Blocks.f_50466_, Blocks.f_50464_, Blocks.f_50523_, Blocks.f_50460_, Blocks.f_50465_, Blocks.f_50462_, Blocks.f_50459_, Blocks.f_50458_, Blocks.f_50463_, Blocks.f_50520_, Blocks.f_50524_, Blocks.f_50457_, Blocks.f_50461_).map(ItemLike::m_5456_).collect(Collectors.toSet());
        public static final LootItemCondition.Builder HAS_SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
        public static final LootItemCondition.Builder HAS_SHEARS = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42574_}));
        public static final LootItemCondition.Builder HAS_SHEARS_OR_SILK_TOUCH = HAS_SHEARS.m_285888_(HAS_SILK_TOUCH);
        public static final LootItemCondition.Builder HAS_NO_SHEARS_OR_SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42574_})).m_285888_(HAS_SILK_TOUCH).m_81807_();
        private static final float[] NORMAL_LEAVES_SAPLING_CHANCES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
        private static final float[] NORMAL_LEAVES_STICK_CHANCES = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f};
        private static final float[] DOUBLE_LEAVES_STICK_CHANCES = new float[]{0.04f, 0.044444446f, 0.05f, 0.06666667f, 0.2f};

        protected EnvironmentalBlockLoot() {
            super(EXPLOSION_RESISTANT, FeatureFlags.f_244280_.m_247355_());
        }

        public void m_245660_() {
            this.m_245724_((Block)EnvironmentalBlocks.CARTWHEEL.get());
            this.m_245724_((Block)EnvironmentalBlocks.BLUEBELL.get());
            this.m_245724_((Block)EnvironmentalBlocks.VIOLET.get());
            this.m_245724_((Block)EnvironmentalBlocks.DIANTHUS.get());
            this.m_245724_((Block)EnvironmentalBlocks.RED_LOTUS_FLOWER.get());
            this.m_245724_((Block)EnvironmentalBlocks.WHITE_LOTUS_FLOWER.get());
            this.m_245724_((Block)EnvironmentalBlocks.TASSELFLOWER.get());
            this.m_245724_((Block)EnvironmentalBlocks.YELLOW_HIBISCUS.get());
            this.m_245724_((Block)EnvironmentalBlocks.ORANGE_HIBISCUS.get());
            this.m_245724_((Block)EnvironmentalBlocks.RED_HIBISCUS.get());
            this.m_245724_((Block)EnvironmentalBlocks.PINK_HIBISCUS.get());
            this.m_245724_((Block)EnvironmentalBlocks.MAGENTA_HIBISCUS.get());
            this.m_245724_((Block)EnvironmentalBlocks.PURPLE_HIBISCUS.get());
            this.m_246125_((Block)EnvironmentalBlocks.YELLOW_WALL_HIBISCUS.get(), (ItemLike)EnvironmentalBlocks.YELLOW_HIBISCUS.get());
            this.m_246125_((Block)EnvironmentalBlocks.ORANGE_WALL_HIBISCUS.get(), (ItemLike)EnvironmentalBlocks.ORANGE_HIBISCUS.get());
            this.m_246125_((Block)EnvironmentalBlocks.RED_WALL_HIBISCUS.get(), (ItemLike)EnvironmentalBlocks.RED_HIBISCUS.get());
            this.m_246125_((Block)EnvironmentalBlocks.PINK_WALL_HIBISCUS.get(), (ItemLike)EnvironmentalBlocks.PINK_HIBISCUS.get());
            this.m_246125_((Block)EnvironmentalBlocks.MAGENTA_WALL_HIBISCUS.get(), (ItemLike)EnvironmentalBlocks.MAGENTA_HIBISCUS.get());
            this.m_246125_((Block)EnvironmentalBlocks.PURPLE_WALL_HIBISCUS.get(), (ItemLike)EnvironmentalBlocks.PURPLE_HIBISCUS.get());
            this.m_246481_((Block)EnvironmentalBlocks.BIRD_OF_PARADISE.get(), block -> this.m_245178_((Block)block, (Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER));
            this.m_246481_((Block)EnvironmentalBlocks.PINK_DELPHINIUM.get(), block -> this.m_245178_((Block)block, (Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER));
            this.m_246481_((Block)EnvironmentalBlocks.BLUE_DELPHINIUM.get(), block -> this.m_245178_((Block)block, (Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER));
            this.m_246481_((Block)EnvironmentalBlocks.PURPLE_DELPHINIUM.get(), block -> this.m_245178_((Block)block, (Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER));
            this.m_246481_((Block)EnvironmentalBlocks.WHITE_DELPHINIUM.get(), block -> this.m_245178_((Block)block, (Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER));
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_CARTWHEEL.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_BLUEBELL.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_VIOLET.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_DIANTHUS.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_RED_LOTUS_FLOWER.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_WHITE_LOTUS_FLOWER.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_TASSELFLOWER.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_YELLOW_HIBISCUS.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_ORANGE_HIBISCUS.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_RED_HIBISCUS.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_PINK_HIBISCUS.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_MAGENTA_HIBISCUS.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_PURPLE_HIBISCUS.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_BIRD_OF_PARADISE.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_PINK_DELPHINIUM.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_BLUE_DELPHINIUM.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_PURPLE_DELPHINIUM.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_WHITE_DELPHINIUM.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_CATTAIL.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_CUP_LICHEN.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_DWARF_SPRUCE.get());
            this.m_245724_((Block)EnvironmentalBlocks.DIRT_BRICKS.get());
            this.m_245724_((Block)EnvironmentalBlocks.DIRT_BRICK_STAIRS.get());
            this.m_245724_((Block)EnvironmentalBlocks.DIRT_BRICK_WALL.get());
            this.m_246481_((Block)EnvironmentalBlocks.DIRT_BRICK_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)EnvironmentalBlocks.DIRT_TILES.get());
            this.m_245724_((Block)EnvironmentalBlocks.DIRT_TILE_STAIRS.get());
            this.m_245724_((Block)EnvironmentalBlocks.DIRT_TILE_WALL.get());
            this.m_246481_((Block)EnvironmentalBlocks.DIRT_TILE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)EnvironmentalBlocks.SMOOTH_MUD.get());
            this.m_246481_((Block)EnvironmentalBlocks.SMOOTH_MUD_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)EnvironmentalBlocks.CHISELED_MUD_BRICKS.get());
            this.m_245724_((Block)EnvironmentalBlocks.SLABFISH_EFFIGY.get());
            this.m_245724_((Block)EnvironmentalBlocks.GRASS_THATCH.get());
            this.m_245724_((Block)EnvironmentalBlocks.GRASS_THATCH_STAIRS.get());
            this.m_246481_((Block)EnvironmentalBlocks.GRASS_THATCH_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)EnvironmentalBlocks.CATTAIL_THATCH.get());
            this.m_245724_((Block)EnvironmentalBlocks.CATTAIL_THATCH_STAIRS.get());
            this.m_246481_((Block)EnvironmentalBlocks.CATTAIL_THATCH_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)EnvironmentalBlocks.DUCKWEED_THATCH.get());
            this.m_245724_((Block)EnvironmentalBlocks.DUCKWEED_THATCH_STAIRS.get());
            this.m_246481_((Block)EnvironmentalBlocks.DUCKWEED_THATCH_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.BURIED_TRUFFLE.get(), block -> this.m_245514_((Block)block, (ItemLike)EnvironmentalItems.TRUFFLE.get()));
            this.m_246125_((Block)EnvironmentalBlocks.LARGE_LILY_PAD.get(), (ItemLike)Blocks.f_50196_);
            this.m_246125_((Block)EnvironmentalBlocks.GIANT_LILY_PAD.get(), (ItemLike)Blocks.f_50196_);
            this.m_246125_((Block)EnvironmentalBlocks.DIRT_PATH.get(), (ItemLike)Blocks.f_50493_);
            this.m_246125_((Block)EnvironmentalBlocks.MYCELIUM_PATH.get(), (ItemLike)Blocks.f_50493_);
            this.m_246125_((Block)EnvironmentalBlocks.PODZOL_PATH.get(), (ItemLike)Blocks.f_50493_);
            this.m_246481_((Block)EnvironmentalBlocks.CATTAIL_SPROUT.get(), block -> this.createCattailDrops((Block)block, (ItemLike)EnvironmentalItems.CATTAIL_FLUFF.get()));
            this.m_246481_((Block)EnvironmentalBlocks.CATTAIL.get(), block -> this.createCattailDrops((Block)block, (ItemLike)block));
            this.m_247577_((Block)EnvironmentalBlocks.CATTAIL_STALK.get(), EnvironmentalBlockLoot.m_246386_());
            this.m_246481_((Block)EnvironmentalBlocks.HIBISCUS_LEAVES.get(), block -> EnvironmentalBlockLoot.m_246160_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])DOUBLE_LEAVES_STICK_CHANCES))));
            this.m_246481_((Block)EnvironmentalBlocks.HIBISCUS_LEAF_PILE.get(), this::createLeafPileDrops);
            this.m_246481_((Block)EnvironmentalBlocks.MYCELIUM_SPROUTS.get(), x$0 -> BlockLootSubProvider.m_245929_((ItemLike)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.DUCKWEED.get(), x$0 -> BlockLootSubProvider.m_245929_((ItemLike)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.GIANT_TALL_GRASS.get(), block -> this.createDoublePlantWithOtherDrop((Block)block, Blocks.f_50034_, Items.f_42404_, 3, 0.125f));
            this.m_246481_((Block)EnvironmentalBlocks.CUP_LICHEN.get(), this::createCupLichenDrops);
            this.m_247577_((Block)EnvironmentalBlocks.CACTUS_BOBBLE.get(), EnvironmentalBlockLoot.m_246386_());
            this.m_246481_((Block)EnvironmentalBlocks.DWARF_SPRUCE.get(), block -> this.createDwarfSpruceDrops((Block)block, true));
            this.m_246481_((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT.get(), block -> this.createDwarfSpruceDrops((Block)block, false));
            this.m_246481_((Block)EnvironmentalBlocks.DWARF_SPRUCE_TORCH.get(), block -> this.createDwarfSpruceDrops((Block)block, true));
            this.m_246481_((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT_TORCH.get(), block -> this.createDwarfSpruceDrops((Block)block, false));
            this.m_246481_((Block)EnvironmentalBlocks.DWARF_SPRUCE_SOUL_TORCH.get(), block -> this.createDwarfSpruceDrops((Block)block, true));
            this.m_246481_((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT_SOUL_TORCH.get(), block -> this.createDwarfSpruceDrops((Block)block, false));
            this.m_246481_((Block)EnvironmentalBlocks.DWARF_SPRUCE_REDSTONE_TORCH.get(), block -> this.createDwarfSpruceDrops((Block)block, true));
            this.m_246481_((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT_REDSTONE_TORCH.get(), block -> this.createDwarfSpruceDrops((Block)block, false));
            this.m_246481_((Block)EnvironmentalBlocks.DWARF_SPRUCE_ENDER_TORCH.get(), block -> this.createDwarfSpruceDrops((Block)block, true));
            this.m_246481_((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT_ENDER_TORCH.get(), block -> this.createDwarfSpruceDrops((Block)block, false));
            this.m_246481_((Block)EnvironmentalBlocks.DWARF_SPRUCE_CUPRIC_TORCH.get(), block -> this.createDwarfSpruceDrops((Block)block, true));
            this.m_246481_((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT_CUPRIC_TORCH.get(), block -> this.createDwarfSpruceDrops((Block)block, false));
            this.m_245724_((Block)EnvironmentalBlocks.CATTAIL_FLUFF_BLOCK.get());
            this.m_245724_((Block)EnvironmentalBlocks.CHERRY_CRATE.get());
            this.m_245724_((Block)EnvironmentalBlocks.PLUM_CRATE.get());
            this.m_245724_((Block)EnvironmentalBlocks.DUCK_EGG_CRATE.get());
            this.m_245724_((Block)EnvironmentalBlocks.YAK_HAIR_BLOCK.get());
            this.m_245724_((Block)EnvironmentalBlocks.YAK_HAIR_RUG.get());
            this.m_245724_((Block)EnvironmentalBlocks.PINECONE.get());
            this.m_245724_((Block)EnvironmentalBlocks.WAXED_PINECONE.get());
            this.m_245724_((Block)EnvironmentalBlocks.WILLOW_PLANKS.get());
            this.m_245724_((Block)EnvironmentalBlocks.WILLOW_LOG.get());
            this.m_245724_((Block)EnvironmentalBlocks.WILLOW_WOOD.get());
            this.m_245724_((Block)EnvironmentalBlocks.STRIPPED_WILLOW_LOG.get());
            this.m_245724_((Block)EnvironmentalBlocks.STRIPPED_WILLOW_WOOD.get());
            this.m_245724_((Block)((RegistryObject)EnvironmentalBlocks.WILLOW_SIGNS.getFirst()).get());
            this.m_245724_((Block)((RegistryObject)EnvironmentalBlocks.WILLOW_HANGING_SIGNS.getFirst()).get());
            this.m_245724_((Block)EnvironmentalBlocks.WILLOW_PRESSURE_PLATE.get());
            this.m_245724_((Block)EnvironmentalBlocks.WILLOW_TRAPDOOR.get());
            this.m_245724_((Block)EnvironmentalBlocks.WILLOW_BUTTON.get());
            this.m_245724_((Block)EnvironmentalBlocks.WILLOW_STAIRS.get());
            this.m_245724_((Block)EnvironmentalBlocks.WILLOW_FENCE.get());
            this.m_245724_((Block)EnvironmentalBlocks.WILLOW_FENCE_GATE.get());
            this.m_245724_((Block)EnvironmentalBlocks.WILLOW_BOARDS.get());
            this.m_246481_((Block)EnvironmentalBlocks.WILLOW_LEAF_PILE.get(), this::createLeafPileDrops);
            this.m_245724_((Block)EnvironmentalBlocks.WILLOW_SAPLING.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_WILLOW_SAPLING.get());
            this.m_245724_((Block)EnvironmentalBlocks.WILLOW_LADDER.get());
            this.m_246481_((Block)EnvironmentalBlocks.WILLOW_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.WILLOW_DOOR.get(), x$0 -> this.m_247398_((Block)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.WILLOW_BEEHIVE.get(), x$0 -> BlockLootSubProvider.m_247247_((Block)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.WILLOW_CHEST.get(), x$0 -> this.m_246180_((Block)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.TRAPPED_WILLOW_CHEST.get(), x$0 -> this.m_246180_((Block)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.WILLOW_BOOKSHELF.get(), block -> this.m_245142_((Block)block, (ItemLike)Items.f_42517_, (NumberProvider)ConstantValue.m_165692_((float)3.0f)));
            this.m_245644_((Block)EnvironmentalBlocks.CHISELED_WILLOW_BOOKSHELF.get());
            this.m_246481_((Block)EnvironmentalBlocks.WILLOW_LEAVES.get(), block -> this.m_246047_((Block)block, (Block)EnvironmentalBlocks.WILLOW_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.m_246481_((Block)EnvironmentalBlocks.HANGING_WILLOW_LEAVES.get(), x$0 -> BlockLootSubProvider.m_245929_((ItemLike)x$0));
            this.m_245724_((Block)EnvironmentalBlocks.PINE_PLANKS.get());
            this.m_245724_((Block)EnvironmentalBlocks.PINE_LOG.get());
            this.m_245724_((Block)EnvironmentalBlocks.PINE_WOOD.get());
            this.m_245724_((Block)EnvironmentalBlocks.STRIPPED_PINE_LOG.get());
            this.m_245724_((Block)EnvironmentalBlocks.STRIPPED_PINE_WOOD.get());
            this.m_245724_((Block)((RegistryObject)EnvironmentalBlocks.PINE_SIGNS.getFirst()).get());
            this.m_245724_((Block)((RegistryObject)EnvironmentalBlocks.PINE_HANGING_SIGNS.getFirst()).get());
            this.m_245724_((Block)EnvironmentalBlocks.PINE_PRESSURE_PLATE.get());
            this.m_245724_((Block)EnvironmentalBlocks.PINE_TRAPDOOR.get());
            this.m_245724_((Block)EnvironmentalBlocks.PINE_BUTTON.get());
            this.m_245724_((Block)EnvironmentalBlocks.PINE_STAIRS.get());
            this.m_245724_((Block)EnvironmentalBlocks.PINE_FENCE.get());
            this.m_245724_((Block)EnvironmentalBlocks.PINE_FENCE_GATE.get());
            this.m_245724_((Block)EnvironmentalBlocks.PINE_BOARDS.get());
            this.m_246481_((Block)EnvironmentalBlocks.PINE_LEAF_PILE.get(), this::createLeafPileDrops);
            this.m_245724_((Block)EnvironmentalBlocks.PINE_SAPLING.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_PINE_SAPLING.get());
            this.m_245724_((Block)EnvironmentalBlocks.PINE_LADDER.get());
            this.m_246481_((Block)EnvironmentalBlocks.PINE_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.PINE_DOOR.get(), x$0 -> this.m_247398_((Block)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.PINE_BEEHIVE.get(), x$0 -> BlockLootSubProvider.m_247247_((Block)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.PINE_CHEST.get(), x$0 -> this.m_246180_((Block)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.TRAPPED_PINE_CHEST.get(), x$0 -> this.m_246180_((Block)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.PINE_BOOKSHELF.get(), block -> this.m_245142_((Block)block, (ItemLike)Items.f_42517_, (NumberProvider)ConstantValue.m_165692_((float)3.0f)));
            this.m_245644_((Block)EnvironmentalBlocks.CHISELED_PINE_BOOKSHELF.get());
            this.m_246481_((Block)EnvironmentalBlocks.PINE_LEAVES.get(), block -> this.m_246047_((Block)block, (Block)EnvironmentalBlocks.PINE_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.m_245724_((Block)EnvironmentalBlocks.PLUM_PLANKS.get());
            this.m_245724_((Block)EnvironmentalBlocks.PLUM_LOG.get());
            this.m_245724_((Block)EnvironmentalBlocks.PLUM_WOOD.get());
            this.m_245724_((Block)EnvironmentalBlocks.STRIPPED_PLUM_LOG.get());
            this.m_245724_((Block)EnvironmentalBlocks.STRIPPED_PLUM_WOOD.get());
            this.m_245724_((Block)((RegistryObject)EnvironmentalBlocks.PLUM_SIGNS.getFirst()).get());
            this.m_245724_((Block)((RegistryObject)EnvironmentalBlocks.PLUM_HANGING_SIGNS.getFirst()).get());
            this.m_245724_((Block)EnvironmentalBlocks.PLUM_PRESSURE_PLATE.get());
            this.m_245724_((Block)EnvironmentalBlocks.PLUM_TRAPDOOR.get());
            this.m_245724_((Block)EnvironmentalBlocks.PLUM_BUTTON.get());
            this.m_245724_((Block)EnvironmentalBlocks.PLUM_STAIRS.get());
            this.m_245724_((Block)EnvironmentalBlocks.PLUM_FENCE.get());
            this.m_245724_((Block)EnvironmentalBlocks.PLUM_FENCE_GATE.get());
            this.m_245724_((Block)EnvironmentalBlocks.PLUM_BOARDS.get());
            this.m_245724_((Block)EnvironmentalBlocks.PLUM_LADDER.get());
            this.m_246481_((Block)EnvironmentalBlocks.PLUM_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.PLUM_DOOR.get(), x$0 -> this.m_247398_((Block)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.PLUM_BEEHIVE.get(), x$0 -> BlockLootSubProvider.m_247247_((Block)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.PLUM_CHEST.get(), x$0 -> this.m_246180_((Block)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.TRAPPED_PLUM_CHEST.get(), x$0 -> this.m_246180_((Block)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.PLUM_BOOKSHELF.get(), block -> this.m_245142_((Block)block, (ItemLike)Items.f_42517_, (NumberProvider)ConstantValue.m_165692_((float)3.0f)));
            this.m_245644_((Block)EnvironmentalBlocks.CHISELED_PLUM_BOOKSHELF.get());
            this.m_246481_((Block)EnvironmentalBlocks.PLUM_LEAVES.get(), block -> this.createPlumLeavesDrops((Block)block, (Block)EnvironmentalBlocks.PLUM_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.m_246481_((Block)EnvironmentalBlocks.PLUM_LEAF_PILE.get(), this::createLeafPileDrops);
            this.m_245724_((Block)EnvironmentalBlocks.PLUM_SAPLING.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_PLUM_SAPLING.get());
            this.m_246481_((Block)EnvironmentalBlocks.CHEERFUL_PLUM_LEAVES.get(), block -> this.createPlumLeavesDrops((Block)block, (Block)EnvironmentalBlocks.CHEERFUL_PLUM_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.m_246481_((Block)EnvironmentalBlocks.CHEERFUL_PLUM_LEAF_PILE.get(), this::createLeafPileDrops);
            this.m_245724_((Block)EnvironmentalBlocks.CHEERFUL_PLUM_SAPLING.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_CHEERFUL_PLUM_SAPLING.get());
            this.m_246481_((Block)EnvironmentalBlocks.MOODY_PLUM_LEAVES.get(), block -> this.createPlumLeavesDrops((Block)block, (Block)EnvironmentalBlocks.MOODY_PLUM_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.m_246481_((Block)EnvironmentalBlocks.MOODY_PLUM_LEAF_PILE.get(), this::createLeafPileDrops);
            this.m_245724_((Block)EnvironmentalBlocks.MOODY_PLUM_SAPLING.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_MOODY_PLUM_SAPLING.get());
            this.m_245724_((Block)EnvironmentalBlocks.WISTERIA_PLANKS.get());
            this.m_245724_((Block)EnvironmentalBlocks.WISTERIA_LOG.get());
            this.m_245724_((Block)EnvironmentalBlocks.WISTERIA_WOOD.get());
            this.m_245724_((Block)EnvironmentalBlocks.STRIPPED_WISTERIA_LOG.get());
            this.m_245724_((Block)EnvironmentalBlocks.STRIPPED_WISTERIA_WOOD.get());
            this.m_245724_((Block)((RegistryObject)EnvironmentalBlocks.WISTERIA_SIGNS.getFirst()).get());
            this.m_245724_((Block)((RegistryObject)EnvironmentalBlocks.WISTERIA_HANGING_SIGNS.getFirst()).get());
            this.m_245724_((Block)EnvironmentalBlocks.WISTERIA_PRESSURE_PLATE.get());
            this.m_245724_((Block)EnvironmentalBlocks.WISTERIA_TRAPDOOR.get());
            this.m_245724_((Block)EnvironmentalBlocks.WISTERIA_BUTTON.get());
            this.m_245724_((Block)EnvironmentalBlocks.WISTERIA_STAIRS.get());
            this.m_245724_((Block)EnvironmentalBlocks.WISTERIA_FENCE.get());
            this.m_245724_((Block)EnvironmentalBlocks.WISTERIA_FENCE_GATE.get());
            this.m_245724_((Block)EnvironmentalBlocks.WISTERIA_BOARDS.get());
            this.m_246481_((Block)EnvironmentalBlocks.PINK_WISTERIA_LEAF_PILE.get(), this::createLeafPileDrops);
            this.m_246481_((Block)EnvironmentalBlocks.BLUE_WISTERIA_LEAF_PILE.get(), this::createLeafPileDrops);
            this.m_246481_((Block)EnvironmentalBlocks.PURPLE_WISTERIA_LEAF_PILE.get(), this::createLeafPileDrops);
            this.m_246481_((Block)EnvironmentalBlocks.WHITE_WISTERIA_LEAF_PILE.get(), this::createLeafPileDrops);
            this.m_246481_((Block)EnvironmentalBlocks.WISTERIA_LEAVES.get(), block -> EnvironmentalBlockLoot.m_246160_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])DOUBLE_LEAVES_STICK_CHANCES))));
            this.m_246481_((Block)EnvironmentalBlocks.WISTERIA_LEAF_PILE.get(), this::createLeafPileDrops);
            this.m_245724_((Block)EnvironmentalBlocks.PINK_WISTERIA_SAPLING.get());
            this.m_245724_((Block)EnvironmentalBlocks.BLUE_WISTERIA_SAPLING.get());
            this.m_245724_((Block)EnvironmentalBlocks.PURPLE_WISTERIA_SAPLING.get());
            this.m_245724_((Block)EnvironmentalBlocks.WHITE_WISTERIA_SAPLING.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_PINK_WISTERIA_SAPLING.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_BLUE_WISTERIA_SAPLING.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_PURPLE_WISTERIA_SAPLING.get());
            this.m_246535_((Block)EnvironmentalBlocks.POTTED_WHITE_WISTERIA_SAPLING.get());
            this.m_245724_((Block)EnvironmentalBlocks.WISTERIA_LADDER.get());
            this.m_246481_((Block)EnvironmentalBlocks.WISTERIA_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.WISTERIA_DOOR.get(), x$0 -> this.m_247398_((Block)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.WISTERIA_BEEHIVE.get(), x$0 -> BlockLootSubProvider.m_247247_((Block)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.WISTERIA_CHEST.get(), x$0 -> this.m_246180_((Block)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.TRAPPED_WISTERIA_CHEST.get(), x$0 -> this.m_246180_((Block)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.WISTERIA_BOOKSHELF.get(), block -> this.m_245142_((Block)block, (ItemLike)Items.f_42517_, (NumberProvider)ConstantValue.m_165692_((float)3.0f)));
            this.m_245644_((Block)EnvironmentalBlocks.CHISELED_WISTERIA_BOOKSHELF.get());
            this.m_246481_((Block)EnvironmentalBlocks.PINK_WISTERIA_LEAVES.get(), block -> this.createWisteriaLeavesDrops((Block)block, (Block)EnvironmentalBlocks.PINK_WISTERIA_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.m_246481_((Block)EnvironmentalBlocks.BLUE_WISTERIA_LEAVES.get(), block -> this.createWisteriaLeavesDrops((Block)block, (Block)EnvironmentalBlocks.BLUE_WISTERIA_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.m_246481_((Block)EnvironmentalBlocks.PURPLE_WISTERIA_LEAVES.get(), block -> this.createWisteriaLeavesDrops((Block)block, (Block)EnvironmentalBlocks.PURPLE_WISTERIA_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.m_246481_((Block)EnvironmentalBlocks.WHITE_WISTERIA_LEAVES.get(), block -> this.createWisteriaLeavesDrops((Block)block, (Block)EnvironmentalBlocks.WHITE_WISTERIA_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.m_246481_((Block)EnvironmentalBlocks.PINK_HANGING_WISTERIA_LEAVES.get(), x$0 -> BlockLootSubProvider.m_245929_((ItemLike)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.BLUE_HANGING_WISTERIA_LEAVES.get(), x$0 -> BlockLootSubProvider.m_245929_((ItemLike)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.PURPLE_HANGING_WISTERIA_LEAVES.get(), x$0 -> BlockLootSubProvider.m_245929_((ItemLike)x$0));
            this.m_246481_((Block)EnvironmentalBlocks.WHITE_HANGING_WISTERIA_LEAVES.get(), x$0 -> BlockLootSubProvider.m_245929_((ItemLike)x$0));
        }

        protected LootTable.Builder createCupLichenDrops(Block block) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)block, LootItem.m_79579_((ItemLike)block).m_230984_(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), cups -> SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)cups.intValue())).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CupLichenBlock.CUPS, cups.intValue())))))));
        }

        protected LootTable.Builder createDwarfSpruceDrops(Block block, boolean isHead) {
            LootTable.Builder builder = LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalBlocks.DWARF_SPRUCE.get())).m_79080_(HAS_SHEARS)).m_7170_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)))))));
            if (isHead) {
                builder = builder.m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42686_)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)DwarfSpruceHeadBlock.STAR, true))));
            }
            return builder;
        }

        protected LootTable.Builder createCattailDrops(Block block, ItemLike drop) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)block, LootItem.m_79579_((ItemLike)drop).m_230984_(List.of(Integer.valueOf(2), Integer.valueOf(3)), cattails -> SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)cattails.intValue())).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CattailBlock.CATTAILS, cattails.intValue())))))));
        }

        protected LootTable.Builder createPlumLeavesDrops(Block block, Block sapling, float ... saplingChances) {
            return this.m_246047_(block, sapling, saplingChances).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(HAS_NO_SHEARS_OR_SILK_TOUCH).m_79076_(((LootPoolSingletonContainer.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalItems.PLUM.get())))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.05f, 0.055555556f, 0.0625f, 0.08333334f, 0.25f}))));
        }

        protected LootTable.Builder createWisteriaLeavesDrops(Block block, Block sapling, float ... saplingChances) {
            LootItemBlockStatePropertyCondition.Builder isBottom = LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)BlockStateProperties.f_61402_, (Comparable)Half.BOTTOM));
            LootItemCondition.Builder isTop = isBottom.m_81807_();
            LootPool.Builder coloredLeafPool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_((LootItemCondition.Builder)isBottom).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79080_(HAS_SHEARS_OR_SILK_TOUCH)).m_7170_(((LootPoolSingletonContainer.Builder)this.m_247733_((ItemLike)sapling, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)sapling))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])saplingChances))));
            LootPool.Builder greenLeafPool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(isTop).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalBlocks.WISTERIA_LEAVES.get())).m_79080_(HAS_SHEARS_OR_SILK_TOUCH));
            LootPool.Builder coloredStickPool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_((LootItemCondition.Builder)isBottom).m_79080_(HAS_NO_SHEARS_OR_SILK_TOUCH).m_79076_(((LootPoolSingletonContainer.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])NORMAL_LEAVES_STICK_CHANCES)));
            LootPool.Builder greenStickPool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(isTop).m_79080_(HAS_NO_SHEARS_OR_SILK_TOUCH).m_79076_(((LootPoolSingletonContainer.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])DOUBLE_LEAVES_STICK_CHANCES)));
            return LootTable.m_79147_().m_79161_(coloredLeafPool).m_79161_(greenLeafPool).m_79161_(coloredStickPool).m_79161_(greenStickPool);
        }

        protected LootTable.Builder createLeafPileDrops(Block block) {
            return this.m_246235_(block, MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.SHEARS)));
        }

        protected LootTable.Builder createDoublePlantWithOtherDrop(Block block, Block grass, Item drop, int count, float chance) {
            AlternativesEntry.Builder builder = ((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)grass).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)count))).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.SHEARS)))).m_7170_(((LootPoolSingletonContainer.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)drop))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)chance)));
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)builder).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER))).m_79080_(LocationCheck.m_81727_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52652_(BlockPredicate.Builder.m_17924_().m_146726_(new Block[]{block}).m_17929_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER).m_67706_()).m_17931_()), (BlockPos)new BlockPos(0, 1, 0)))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)builder).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER))).m_79080_(LocationCheck.m_81727_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52652_(BlockPredicate.Builder.m_17924_().m_146726_(new Block[]{block}).m_17929_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER).m_67706_()).m_17931_()), (BlockPos)new BlockPos(0, -1, 0))));
        }

        public Iterable<Block> getKnownBlocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> ForgeRegistries.BLOCKS.getKey(block).m_135827_().equals("environmental")).collect(Collectors.toSet());
        }
    }
}

