/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.slabfish;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public record SweaterType(Optional<Component> displayName, Optional<ResourceLocation> texture, Optional<Holder<Item>> item, Optional<TagKey<Item>> tagKey) implements Predicate<ItemStack>
{
    public static final Codec<SweaterType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_252442_.optionalFieldOf("description").forGetter(entry -> entry.displayName), (App)ResourceLocation.f_135803_.optionalFieldOf("texture").forGetter(entry -> entry.texture), (App)RegistryFixedCodec.m_206740_((ResourceKey)Registries.f_256913_).optionalFieldOf("item").forGetter(entry -> entry.item), (App)TagKey.m_203877_((ResourceKey)Registries.f_256913_).optionalFieldOf("tag").forGetter(entry -> entry.tagKey)).apply((Applicative)instance, SweaterType::new));
    public static final Codec<SweaterType> NETWORK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_252442_.optionalFieldOf("description").forGetter(entry -> entry.displayName), (App)ResourceLocation.f_135803_.optionalFieldOf("texture").forGetter(entry -> entry.texture)).apply((Applicative)instance, (component, texture) -> new SweaterType((Optional<Component>)component, (Optional<ResourceLocation>)texture, Optional.empty(), Optional.empty())));

    public static SweaterType create(Component displayName, ResourceLocation texture, ItemLike item) {
        return new SweaterType(Optional.of(displayName), Optional.of(texture), Optional.of(BuiltInRegistries.f_257033_.m_263177_((Object)item.m_5456_())), Optional.empty());
    }

    public static SweaterType create(Component displayName, ResourceLocation texture, TagKey<Item> tag) {
        return new SweaterType(Optional.of(displayName), Optional.of(texture), Optional.empty(), Optional.of(tag));
    }

    public boolean isEmpty() {
        return this.texture.isEmpty();
    }

    @Override
    public boolean test(ItemStack stack) {
        return !this.isEmpty() && (this.item.isPresent() && Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)this.item.get().get()}).test(stack) || this.tagKey.isPresent() && Ingredient.m_204132_(this.tagKey.get()).test(stack));
    }
}

