/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.slabfish;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.item.ItemStack;

public abstract class DynamicInventory
implements Container {
    private final Int2ObjectOpenHashMap<ItemStack> inventory = new Int2ObjectOpenHashMap();
    private Set<ContainerListener> listeners = null;

    private int getNextEmptySlot(ItemStack stack, int loopStart, int loopEnd) {
        for (int i = loopStart; i < loopEnd; ++i) {
            if (!this.m_7013_(i, stack) || !((ItemStack)this.inventory.getOrDefault(i, (Object)ItemStack.f_41583_)).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    private void mergeStacks(ItemStack stack, ItemStack stackInSlot, int index) {
        int maxStackSize = Math.min(this.getSlotStackLimit(index), stackInSlot.m_41741_());
        int addAmount = Math.min(stack.m_41613_(), maxStackSize - stackInSlot.m_41613_());
        if (addAmount > 0) {
            stackInSlot.m_41769_(addAmount);
            stack.m_41774_(addAmount);
        }
    }

    public void addListener(ContainerListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet<ContainerListener>();
        }
        this.listeners.add(listener);
    }

    public void removeListener(ContainerListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    public ItemStack addItem(ItemStack stack) {
        return this.addItem(stack, 0, this.m_6643_());
    }

    public ItemStack addItem(ItemStack stack, int startIndex, int endIndex) {
        int index;
        int loopStart = Math.max(0, startIndex);
        int loopEnd = Math.min(this.m_6643_(), endIndex);
        ItemStack copy = stack.m_41777_();
        for (int i = loopStart; i < loopEnd; ++i) {
            ItemStack stackInSlot = this.m_8020_(i);
            if (!this.m_7013_(i, stack) || !ItemStack.m_41656_((ItemStack)stackInSlot, (ItemStack)copy) || !ItemStack.m_150942_((ItemStack)stackInSlot, (ItemStack)copy)) continue;
            this.mergeStacks(copy, stackInSlot, i);
            if (!copy.m_41619_()) continue;
            this.m_6596_();
            return ItemStack.f_41583_;
        }
        while (!copy.m_41619_() && (index = this.getNextEmptySlot(copy, loopStart, loopEnd)) >= 0) {
            if (copy.m_41613_() > this.getSlotStackLimit(index)) {
                this.inventory.put(index, (Object)copy.m_41620_(this.getSlotStackLimit(index)));
                continue;
            }
            this.inventory.put(index, (Object)copy.m_41777_());
            copy = ItemStack.f_41583_;
        }
        if (!ItemStack.m_41728_((ItemStack)stack, (ItemStack)copy)) {
            this.m_6596_();
        }
        return copy;
    }

    public boolean m_7983_() {
        return this.inventory.isEmpty();
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.inventory.getOrDefault(index, (Object)ItemStack.f_41583_);
    }

    public ItemStack m_7407_(int index, int count) {
        if (((ItemStack)this.inventory.getOrDefault(index, (Object)ItemStack.f_41583_)).m_41619_() || count <= 0) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = ((ItemStack)this.inventory.getOrDefault(index, (Object)ItemStack.f_41583_)).m_41620_(count);
        this.m_6596_();
        return stack;
    }

    public ItemStack m_8016_(int index) {
        if (((ItemStack)this.inventory.getOrDefault(index, (Object)ItemStack.f_41583_)).m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = (ItemStack)this.inventory.remove(index);
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.m_6596_();
        return stack;
    }

    public void m_6836_(int index, ItemStack stack) {
        if (index < 0 || index >= this.m_6643_()) {
            return;
        }
        this.inventory.put(index, (Object)stack);
        if (!stack.m_41619_() && stack.m_41613_() > this.getSlotStackLimit(index)) {
            stack.m_41764_(this.getSlotStackLimit(index));
        }
        this.m_6596_();
    }

    public void m_6596_() {
        if (this.listeners == null) {
            return;
        }
        for (ContainerListener listener : this.listeners) {
            listener.m_5757_((Container)this);
        }
    }

    public int getSlotStackLimit(int index) {
        return this.m_6893_();
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    public void write(CompoundTag nbt) {
        ListTag list = new ListTag();
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack stack = (ItemStack)this.inventory.getOrDefault(i, (Object)ItemStack.f_41583_);
            if (stack.m_41619_()) continue;
            CompoundTag slotNbt = new CompoundTag();
            slotNbt.m_128344_("Slot", (byte)i);
            stack.m_41739_(slotNbt);
            list.add((Object)slotNbt);
        }
        nbt.m_128365_("Items", (Tag)list);
    }

    public void read(CompoundTag nbt) {
        this.m_6211_();
        ListTag list = nbt.m_128437_("Items", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag slotNbt = list.m_128728_(i);
            int index = slotNbt.m_128445_("Slot") & 0xFF;
            if (index >= this.m_6643_()) continue;
            this.inventory.put(index, (Object)ItemStack.m_41712_((CompoundTag)slotNbt));
        }
    }
}

