/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.slabfish;

import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.util.StringRepresentable;

public enum SlabfishOverlay implements StringRepresentable
{
    NONE(0, "none"),
    MUDDY(1, "mud"),
    SNOWY(2, "snow"),
    EGG(3, "egg");

    private static final SlabfishOverlay[] VALUES;
    private final int id;
    private final String name;
    private final LazyLoadedValue<ResourceLocation> textureLocation = new LazyLoadedValue(() -> new ResourceLocation("environmental", "overlay/" + this.m_7912_()));
    private final LazyLoadedValue<ResourceLocation> backpackTextureLocation = new LazyLoadedValue(() -> new ResourceLocation("environmental", "overlay/" + this.m_7912_() + "_backpack"));

    private SlabfishOverlay(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public String m_7912_() {
        return this.name;
    }

    public ResourceLocation getTextureLocation() {
        return (ResourceLocation)this.textureLocation.m_13971_();
    }

    public ResourceLocation getBackpackTextureLocation() {
        return (ResourceLocation)this.backpackTextureLocation.m_13971_();
    }

    public static SlabfishOverlay byId(int id) {
        if (id < 0 || id >= VALUES.length) {
            id = 0;
        }
        return VALUES[id];
    }

    public static SlabfishOverlay byTranslationKey(String key, SlabfishOverlay type) {
        for (SlabfishOverlay slabfishtype : SlabfishOverlay.values()) {
            if (!slabfishtype.name.equals(key)) continue;
            return slabfishtype;
        }
        return type;
    }

    static {
        VALUES = (SlabfishOverlay[])Arrays.stream(SlabfishOverlay.values()).sorted(Comparator.comparingInt(SlabfishOverlay::getId)).toArray(SlabfishOverlay[]::new);
    }
}

