/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal.zebroid;

import com.teamabnormals.environmental.common.entity.animal.zebroid.Zebra;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class ZebraFleeGoal
extends Goal {
    private final Zebra zebra;
    private final PathNavigation pathNav;
    private final double speedModifier;
    private boolean trigger;
    private boolean running;
    private boolean isStuck;
    private int nextStartTicks;
    private int fleeTime;
    private int stuckTime;
    private float fleeDirection;

    public ZebraFleeGoal(Zebra zebra, double speed) {
        this.zebra = zebra;
        this.pathNav = zebra.m_21573_();
        this.speedModifier = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        List<Zebra> zebras;
        if (this.trigger) {
            return true;
        }
        if (--this.nextStartTicks > 0) {
            return false;
        }
        if (!this.zebra.m_30614_() && this.zebra.m_5448_() == null && !(zebras = this.zebra.m_9236_().m_6443_(Zebra.class, this.zebra.m_20191_().m_82377_(10.0, 4.0, 10.0), zebra1 -> zebra1 != this.zebra && zebra1.isFleeing()).stream().sorted(Comparator.comparingDouble(entity -> entity.m_20280_((Entity)this.zebra))).toList()).isEmpty()) {
            Zebra zebra12 = zebras.get(0);
            this.fleeTime = zebra12.getFleeGoal().fleeTime + this.m_183277_(this.zebra.m_217043_().m_188503_(30) - 30);
            this.fleeDirection = zebra12.getFleeGoal().fleeDirection;
            this.nextStartTicks = this.m_183277_(60);
            return true;
        }
        this.nextStartTicks = this.m_183277_(this.zebra.m_217043_().m_188503_(10) + 10);
        return false;
    }

    public boolean m_8045_() {
        return --this.fleeTime >= 0;
    }

    public void m_8056_() {
        this.running = true;
        this.trigger = false;
        this.isStuck = false;
        this.stuckTime = 0;
        this.pathNav.m_26573_();
        this.zebra.m_30661_(false);
        this.zebra.m_30665_(false);
        this.zebra.m_8032_();
    }

    public void m_8041_() {
        this.running = false;
    }

    public void m_8037_() {
        if (this.pathNav.m_26571_() || this.pathNav.m_26567_().m_203195_((Position)this.zebra.m_20182_(), 5.0)) {
            float f = this.fleeDirection * ((float)Math.PI / 180);
            Vec3 vec3 = this.zebra.m_20182_().m_82549_(new Vec3(Math.sin(f) * 32.0, 0.0, Math.cos(f) * 32.0));
            for (int i = 0; i < 3; ++i) {
                Vec3 vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.zebra, (int)16, (int)7, (Vec3)vec3, (double)0.5235987755982988);
                if (vec31 == null) continue;
                double d0 = this.speedModifier;
                double d1 = this.zebra.m_21051_(Attributes.f_22279_).m_22115_();
                if (d1 < 0.225 && d1 != 0.0) {
                    d0 = 0.4 / d1;
                }
                this.pathNav.m_26519_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, d0);
                this.stuckTime = 0;
                if (this.isStuck) {
                    this.isStuck = false;
                    this.zebra.m_8032_();
                }
                return;
            }
            if (++this.stuckTime > this.m_183277_(20)) {
                List<Zebra> zebras = this.zebra.m_9236_().m_6443_(Zebra.class, this.zebra.m_20191_().m_82377_(10.0, 4.0, 10.0), zebra1 -> zebra1 != this.zebra && zebra1.isFleeing() && zebra1.getFleeGoal().fleeDirection != this.fleeDirection && !zebra1.getFleeGoal().isStuck).stream().sorted(Comparator.comparingDouble(entity -> entity.m_20280_((Entity)this.zebra))).toList();
                if (!zebras.isEmpty()) {
                    this.fleeDirection = zebras.get((int)0).getFleeGoal().fleeDirection;
                } else {
                    int i = this.zebra.m_217043_().m_188503_(2) - 1;
                    if (i >= 0) {
                        ++i;
                    }
                    this.fleeDirection = Mth.m_14177_((float)(this.fleeDirection + (float)i * 60.0f));
                }
                this.stuckTime = 0;
                this.isStuck = true;
            }
        }
    }

    public boolean running() {
        return this.running;
    }

    public void trigger(int fleeTime, float fleeDirection) {
        this.trigger = true;
        this.fleeTime = fleeTime;
        this.fleeDirection = fleeDirection;
    }
}

